const page = document.querySelector("html");
const main = document.querySelector("main");
const modals = document.querySelectorAll(".modal");
const existingModal = document.querySelector(".modal-wrapper");

const onboardingModal = document.querySelector(".onboarding-modal");
const modalBody = onboardingModal.querySelector(".body");

window.addEventListener("load", () => {
  // setTimeout(() => {
  //   onboardingModal.show();
  //   onboardingModal.classList.add("modal-visible");
  // }, 1000);
  // onboardingModal.classList.remove("modal-visible");
});

modalBody.innerHTML = `
    <img src="./assets/icons/fruit-bowl.svg" alt="fruit bowl" />
    <div>
    <h2 class="modal-head">Welcome, Lisa 👋🏾</h2>
    <p class="modal-text">
        It’s beautiful to have you here, Let’s set up your restaurant,
        just few things needed like, Restaurant or Business Name, Dish
        type, Location and Payment Option. 😉😉
    </p>
    </div>
    <button class="primary-button" onclick="openModal('step-1')">
      <span>Get Started</span>
      <img src="./assets/icons/right-arrow.svg" alt="right arrow" class="right-arrow"/>
    </button>
`;

// Close Modals
document.querySelectorAll("dialog").forEach((modal) => {
  modal.addEventListener("click", (event) => {
    if (event.target === modal) {
      modal.close();
      if (modal === onboardingModal) {
        onboardingModal.classList.remove("modal-visible");
      }
    }
  });
});

// Manage dropdown menu
let dropdownContainers = document.querySelectorAll(
  ".select-dropdown, .static-dropdown"
);
function manageDropdowns() {
  // Add a delegated click listener to the container
  page.addEventListener("click", (event) => {
    // Dropdown button click logic
    const dropdownButton = event.target.closest(".dropdown-button");
    const dropdownContainer = event.target.closest(
      ".select-dropdown, .static-dropdown"
    );

    if (dropdownButton && dropdownContainer) {
      // Toggle the open class for the clicked dropdown
      dropdownContainer.classList.toggle("open");
    } else {
      // Close all open dropdowns when clicking outside
      page
        .querySelectorAll(".select-dropdown.open, .static-dropdown.open")
        .forEach((openDropdown) => {
          openDropdown.classList.remove("open");
        });
    }

    // Dropdown item click logic
    const dropdownItem = event.target.closest("ul li");
    if (dropdownItem && dropdownContainer) {
      const isNestedDropdown =
        dropdownItem.classList.contains("nested-dropdown");
      if (!isNestedDropdown) {
        const dropdownButtonText = dropdownContainer.querySelector(
          ".dropdown-button span"
        );
        if (
          dropdownContainer.classList.contains("select-dropdown") &&
          dropdownButtonText
        ) {
          dropdownButtonText.textContent = dropdownItem.textContent;
        }
        dropdownContainer.classList.remove("open");
      }
    }
  });
}

// Apply the dropdown management logic
manageDropdowns();

function setupDropdownDelegation(container) {
  container.addEventListener("click", (event) => {
    const dropdownButton = event.target.closest(
      ".floating-controls.dropdown button"
    );
    if (dropdownButton) {
      const dropdownContainer = dropdownButton.closest(
        ".floating-controls.dropdown"
      );
      if (dropdownContainer) {
        dropdownContainer.classList.toggle("open");
      }
      return;
    }

    // Handle dropdown item selection
    const dropdownItem = event.target.closest("ul li");
    if (dropdownItem) {
      const dropdownContainer = dropdownItem.closest(
        ".floating-controls.dropdown"
      );
      if (dropdownContainer) {
        const dropdownButton = dropdownContainer.querySelector("button");
        if (dropdownButton) {
          dropdownButton.textContent = dropdownItem.textContent; // Update button text
        }
        dropdownContainer.classList.add("selected");
        dropdownContainer.classList.remove("open");
      }
    }
  });
}

const AMTimesArray = [
  "00:00 AM",
  "01:00 AM",
  "02:00 AM",
  "03:00 AM",
  "04:00 AM",
  "05:00 AM",
  "06:00 AM",
  "07:00 AM",
  "08:00 AM",
  "09:00 AM",
  "10:00 AM",
  "11:00 AM",
];

const PMTimesArray = [
  "01:00 PM",
  "02:00 PM",
  "03:00 PM",
  "04:00 PM",
  "05:00 PM",
  "06:00 PM",
  "07:00 PM",
  "08:00 PM",
  "09:00 PM",
  "10:00 PM",
  "11:00 PM",
  "12:00 PM",
];

function generateDropdownList(times) {
  return times.map((time) => `<li>${time}</li>`).join("");
}

function openModal(type) {
  if (type === "step-1") {
    onboardingModal.setAttribute("id", "step-1");
    onboardingModal.classList.add("steps");

    const pages = document.querySelectorAll(".steps .heading ul li");
    pages.forEach((page) => page.classList.remove("active"));
    pages[0].classList.add("active");

    modalBody.innerHTML = `
          <div>
            <h2>Lisa, what should we call your business</h2>
            <p>
              You can enter your registered business name, select your business
              type in the field below
            </p>
          </div>
          <form action="">
            <div class="form-group">
              <div class="floating-controls">
                <input
                  type="text"
                  id="name"
                  name="name"
                  placeholder=" "
                />
                <label for="name">Business Name</label>
              </div>
              <div class="floating-controls dropdown">
                <button type="button"></button>
                <label for="email">
                  <span>Business Type</span>
                  <img src="./assets/icons/gray-arrow-down.svg" alt="down arrow" class="right-arrow"/>
                </label>
                <ul>
                  <span>Business Type</span>
                  <li>Restaurant</li>
                  <li>Home Kitchen</li>
                </ul>
              </div>
            </div>
          </form>
          <button class="primary-button" onclick="openModal('step-2')">
            <span>Continue</span>
            <img src="./assets/icons/right-arrow.svg" alt="right arrow" class="right-arrow"/>
          </button>
        `;
  } else if (type === "step-2") {
    const dropdownHTML1 = generateDropdownList(AMTimesArray);
    const dropdownHTML2 = generateDropdownList(PMTimesArray);

    onboardingModal.setAttribute("id", "step-2");

    const pages = document.querySelectorAll(".steps .heading ul li");
    pages.forEach((page) => page.classList.remove("active"));
    pages[1].classList.add("active");

    modalBody.innerHTML = `
          <div>
            <h2>Let’ set your opening hours</h2>
            <p>
              Your business opening hours helps customers to know when they can
              come get their treats 😉
            </p>
          </div>
          <form action="">
            <div class="form-group">
              <div class="floating-controls dropdown">
                <button type="button"></button>
                <label for="email">
                  <span>Morning Opening Time in 24H Format</span>
                  <img src="./assets/icons/gray-arrow-down.svg" alt="down arrow" class="right-arrow"/>
                </label>
                <div class="dropdown-container modal">
                  <div class="dropdown-heading">
                    <p>
                      <img
                        src="./assets/icons/clock.svg"
                        alt="clock icon"
                        width="12"
                        class="clock-icon"
                      />
                      <span>Set Opening Time</span>
                    </p>
                    <img
                      src="./assets/icons/close.svg"
                      alt="close icon"
                      class="close-icon"
                    />
                  </div>
                  <ul>
                    ${dropdownHTML1}
                  </ul>
                </div>
              </div>
              <div class="floating-controls dropdown">
                <button type="button"></button>
                <label for="email">
                  <span>Morning Closing Time in 24H Format</span>
                  <img src="./assets/icons/gray-arrow-down.svg" alt="down arrow" class="right-arrow"/>
                </label>
                <div class="dropdown-container modal">
                  <div class="dropdown-heading">
                    <p>
                      <img
                        src="./assets/icons/clock.svg"
                        alt="clock icon"
                        width="12"
                        class="clock-icon"
                      />
                      <span>Set Closing Time</span>
                    </p>
                    <img
                      src="./assets/icons/close.svg"
                      alt="close icon"
                      class="close-icon"
                    />
                  </div>
                  <ul>
                    ${dropdownHTML1}
                  </ul>
                </div>
              </div>
              <div class="floating-controls dropdown">
                <button type="button"></button>
                <label for="email">
                  <span>Evening Opening Time in 24H Format</span>
                  <img src="./assets/icons/gray-arrow-down.svg" alt="down arrow" class="right-arrow"/>
                </label>
                <div class="dropdown-container modal">
                  <div class="dropdown-heading">
                    <p>
                      <img
                        src="./assets/icons/clock.svg"
                        alt="clock icon"
                        width="12"
                        class="clock-icon"
                      />
                      <span>Set Opening Time</span>
                    </p>
                    <img
                      src="./assets/icons/close.svg"
                      alt="close icon"
                      class="close-icon"
                    />
                  </div>
                  <ul>
                    ${dropdownHTML2}
                  </ul>
                </div>
              </div>
              <div class="floating-controls dropdown">
                <button type="button"></button>
                <label for="email">
                  <span>Evening Closing Time in 24H Format</span>
                <img src="./assets/icons/gray-arrow-down.svg" alt="down arrow" class="right-arrow"/>
                </label>
                <div class="dropdown-container modal">
                  <div class="dropdown-heading">
                    <p>
                      <img
                        src="./assets/icons/clock.svg"
                        alt="clock icon"
                        width="12"
                        class="clock-icon"
                      />
                      <span>Set Closing Time</span>
                    </p>
                    <img
                      src="./assets/icons/close.svg"
                      alt="close icon"
                      class="close-icon"
                    />
                  </div>
                  <ul>
                    ${dropdownHTML2}
                  </ul>
                </div>
              </div>
            </div>
          </form>
          <button class="primary-button" onclick="openModal('step-3')" >
            <span>Continue</span>
            <img src="./assets/icons/right-arrow.svg" alt="right arrow" class="right-arrow"/>
          </button>
          <button onclick="openModal('step-1')" id="back-button">
            <span>Back</span>
          </button>
        `;

    const eachDropdown = modalBody.querySelectorAll(".dropdown-container ul");

    eachDropdown.forEach((dropdown) => {
      const listItem = dropdown.querySelectorAll("li");
      listItem.forEach((item) => {
        item.addEventListener("click", () => {
          listItem.forEach((item) => {
            item.classList.remove("active");
          });
          item.classList.add("active");
        });
      });
    });
  } else if (type === "step-3") {
    onboardingModal.setAttribute("id", "step-3");

    const pages = document.querySelectorAll(".steps .heading ul li");
    pages.forEach((page) => page.classList.remove("active"));
    pages[2].classList.add("active");

    modalBody.innerHTML = `
          <div>
            <h2>A call line is also important to your customers</h2>
            <p>
              Yeah, it can be overwhelming sometimes but they need to talk to a
              support team when they feel that order is taking too long.
            </p>
          </div>
          <form action="">
            <div class="form-group">
              <div class="floating-controls">
                <input
                  type="text"
                  id="name"
                  name="name"
                  required
                  placeholder=" "
                />
                <label for="name">Phone Number</label>
                <p class="hint">Please include your Country Code</p>
              </div>
              <label class="checkbox">
                <span>Use same as Phone Number</span>
                <input type="checkbox" />
                <svg
                  width="20"
                  height="20"
                  viewBox="0 0 20 20"
                  fill="none"
                  xmlns="http://www.w3.org/2000/svg"
                >
                  <path
                    d="M10 0.25C8.07164 0.25 6.18657 0.821828 4.58319 1.89317C2.97982 2.96451 1.73013 4.48726 0.992179 6.26884C0.254225 8.05042 0.061142 10.0108 0.437348 11.9021C0.813554 13.7934 1.74215 15.5307 3.10571 16.8943C4.46928 18.2579 6.20656 19.1865 8.09787 19.5627C9.98919 19.9389 11.9496 19.7458 13.7312 19.0078C15.5127 18.2699 17.0355 17.0202 18.1068 15.4168C19.1782 13.8134 19.75 11.9284 19.75 10C19.7473 7.41498 18.7192 4.93661 16.8913 3.10872C15.0634 1.28084 12.585 0.25273 10 0.25ZM14.2806 8.28063L9.03063 13.5306C8.96097 13.6004 8.87826 13.6557 8.78721 13.6934C8.69616 13.7312 8.59857 13.7506 8.5 13.7506C8.40144 13.7506 8.30385 13.7312 8.2128 13.6934C8.12175 13.6557 8.03903 13.6004 7.96938 13.5306L5.71938 11.2806C5.57865 11.1399 5.49959 10.949 5.49959 10.75C5.49959 10.551 5.57865 10.3601 5.71938 10.2194C5.86011 10.0786 6.05098 9.99958 6.25 9.99958C6.44903 9.99958 6.6399 10.0786 6.78063 10.2194L8.5 11.9397L13.2194 7.21937C13.2891 7.14969 13.3718 7.09442 13.4628 7.0567C13.5539 7.01899 13.6515 6.99958 13.75 6.99958C13.8486 6.99958 13.9461 7.01899 14.0372 7.0567C14.1282 7.09442 14.2109 7.14969 14.2806 7.21937C14.3503 7.28906 14.4056 7.37178 14.4433 7.46283C14.481 7.55387 14.5004 7.65145 14.5004 7.75C14.5004 7.84855 14.481 7.94613 14.4433 8.03717C14.4056 8.12822 14.3503 8.21094 14.2806 8.28063Z"
                    fill="none"
                    fill-opacity="0.6"
                  />
                </svg>
              </label>
              <div class="floating-controls phone-number">
                <input
                  type="text"
                  id="name"
                  name="name"
                  placeholder=" "
                />
                <label for="name">Whatsapp Number</label>
                <p class="hint">Please include your Country Code</p>
              </div>
            </div>
          </form>
          <button class="primary-button" onclick="openModal('step-4')">
            <span>Continue</span>
            <img src="./assets/icons/right-arrow.svg" alt="right arrow" class="right-arrow"/>
          </button>
          <button onclick="openModal('step-2')" id="back-button">
            <span>Back</span>
          </button>
        `;
  } else if (type === "step-4") {
    onboardingModal.setAttribute("id", "step-4");

    const pages = document.querySelectorAll(".steps .heading ul li");
    pages.forEach((page) => page.classList.remove("active"));
    pages[3].classList.add("active");

    modalBody.innerHTML = `
      <div>
        <h2>Let’s place your business in the map</h2>
        <p>
          Your business address will helps your customers find you, & your
          business contact is required too, they’re important
        </p>
      </div>
      <div id="map1"></div>
      <button class="location-button">Use current location</button>
      <button class="primary-button" onclick="openModal('great')">
        <span>Done</span>
        <img src="./assets/icons/right-arrow.svg" alt="right arrow" class="right-arrow"/>
      </button>
      <button onclick="openModal('step-3')" id="back-button">
        <span>Back</span>
      </button>
    `;

    var map = L.map("map1", {
      zoomControl: false,
      attributionControl: false,
    }).setView([48.85, 2.35], 10);

    var myIcon = L.icon({
      iconUrl: "./assets/images/map-icon.png",
      iconSize: [40, 40],
      iconAnchor: [20, 40],
      popupAnchor: [0, -40],
    });

    var marker = L.marker([50.505, 30.57], {
      icon: myIcon,
      draggable: true,
    }).addTo(map);

    marker.on("dragend", function () {
      var position = marker.getLatLng();
      // console.log("Marker moved to:", position);
      marker.setLatLng(position);
    });

    var group = L.featureGroup([marker]).addTo(map);

    map.fitBounds(group.getBounds(), {
      padding: [50, 50],
      maxZoom: 12,
    });

    if (map.zoomControl) {
      map.removeControl(map.zoomControl);
    }

    var googleStreets = L.tileLayer(
      "http://{s}.google.com/vt/lyrs=m&x={x}&y={y}&z={z}",
      {
        maxZoom: 20,
        subdomains: ["mt0", "mt1", "mt2", "mt3"],
      }
    );

    googleStreets.addTo(map);

    const locationButton = onboardingModal.querySelector(
      "#step-4 .location-button"
    );
    locationButton.addEventListener("click", () => {
      if ("geolocation" in navigator) {
        navigator.geolocation.getCurrentPosition(
          (position) => {
            const latitude = position.coords.latitude;
            const longitude = position.coords.longitude;
            map.setView([latitude, longitude], 12); // Center the map on the user's location
            marker.setLatLng([latitude, longitude]); // Move the marker to the user's location
            console.log(`Latitude: ${latitude}, Longitude: ${longitude}`);
          },
          (error) => {
            console.error("Error retrieving location:", error.message);
            alert("Could not retrieve location. Please try again.");
          }
        );
      } else {
        alert("Geolocation is not supported by your browser.");
      }
    });
  } else if (type === "great") {
    onboardingModal.setAttribute("id", "great");
    onboardingModal.classList.remove("steps");

    modalBody.innerHTML = `
          <img src="./assets/images/thumbs-up.png" alt="thumbs up" />
          <div>
            <h2>Great Lisa! your ready.</h2>
            <p>It was a smoooth ride</p>
          </div>
          <button class="primary-button" onclick="openModal('close')">
            <span>Let's Explore</span>
            <img src="./assets/icons/right-arrow.svg" alt="right arrow" class="right-arrow"/>          
          </button>
        `;
  } else {
    onboardingModal.close();
    onboardingModal.classList.remove("modal-visible");
  }

  let dropdownButtons = document.querySelectorAll(".floating-controls button");

  dropdownButtons.forEach((button) => {
    const parent = button.parentElement;
    button.addEventListener("click", () => {
      parent.classList.toggle("open");
    });
  });

  let listItems = document.querySelectorAll(".floating-controls ul li");

  listItems.forEach((item) => {
    item.addEventListener("click", () => {
      const ul = item.parentElement;
      const parent = ul.parentElement;
      const grandParent = parent.parentElement;

      const button = parent.querySelector("button");
      button.textContent = item.textContent;
      grandParent.classList.add("selected");
      grandParent.close();
    });
  });

  let dropdownContainers = document.querySelectorAll(".dropdown-container");
  dropdownContainers.forEach((container) => {
    let parent = container.parentElement;
    let dropdownButton = parent.querySelector("button");

    dropdownButton.addEventListener("click", () => {
      parent.classList.add("open");
    });

    let listItems = container.querySelectorAll("ul li");

    // Update button text when a list item is clicked
    listItems.forEach((item) => {
      item.addEventListener("click", () => {
        dropdownButton.textContent = item.textContent;
        parent.classList.add("selected");
        parent.classList.remove("open");
        parent.close();
      });
    });
  });
}
const closeButton = onboardingModal.querySelector(".close-button");
closeButton.addEventListener("click", () => {
  // console.log("clicked");
  onboardingModal.close();
  onboardingModal.classList.remove("modal-visible");
});

let earnings = document.querySelectorAll(".earnings .earning .open-modal-btn");
earnings.forEach((earning) => {
  earning.addEventListener("click", () => {
    populateOrderModal("ZP37646739299399", "view");
  });
});
let notificationItems = document.querySelectorAll(".notification-items li");
notificationItems.forEach((item) => {
  item.addEventListener("click", () => {
    populateOrderModal("ZP37646739299399", "view");
  });
});

// Create Alert
const createAlert = (title, image, color) => {
  const alertContainer = document.getElementById("alert");

  alertContainer.innerHTML = `
    <span>${title}</span>
    <button style="background-color: var(--${color})" class="close-button">
      <img src="${image}" alt="alert icon" />
    </button>
  `;

  alertContainer.showModal();

  const closeButton = alertContainer.querySelector(".close-button");

  closeButton.addEventListener("click", () => {
    alertContainer.classList.add("closing");
    setTimeout(() => {
      alertContainer.close();
      alertContainer.classList.remove("closing");
    }, 600);
  });
};

// Story Preview
const storyItems = document.querySelectorAll(".story-list button");
const storyButton = document.querySelector(".story-item");
const storyCloseButton = document.querySelector(
  ".story-modal .modal-heading .close-button"
);
const storyModal = document.getElementById("story-modal");

storyButton.addEventListener("click", () => {
  storyModal.showModal();
});

storyCloseButton.addEventListener("click", () => {
  storyModal.close();
});

storyItems.forEach((item) => {
  item.addEventListener("click", () => {
    let existingModal = document.getElementById("story-preview-modal");
    if (existingModal) {
      existingModal.remove(); // Remove the existing modal
    }

    const storyPreviewModal = document.createElement("dialog");
    storyPreviewModal.id = "story-preview-modal";
    storyPreviewModal.classList = "story-preview-modal modal";
    storyPreviewModal.style.backgroundImage =
      'url("./assets/images/dummy-image.png")';

    storyPreviewModal.innerHTML = `
      <div class="modal-heading">
        <div class="logo-section">
          <p>
            <img src="./assets/icons/mini-logo.svg" alt="logo" />
          </p>
          <span>Zoop Restaurant</span>
        </div>
        <button type="button" class="close-button" id="delete">
          <svg width="16" height="18" viewBox="0 0 20 22" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M18.25 4.30127H14.875V3.17627C14.875 2.48008 14.5984 1.8124 14.1062 1.32011C13.6139 0.827831 12.9462 0.55127 12.25 0.55127H7.75C7.05381 0.55127 6.38613 0.827831 5.89384 1.32011C5.40156 1.8124 5.125 2.48008 5.125 3.17627V4.30127H1.75C1.45163 4.30127 1.16548 4.4198 0.954505 4.63077C0.743526 4.84175 0.625 5.1279 0.625 5.42627C0.625 5.72464 0.743526 6.01079 0.954505 6.22176C1.16548 6.43274 1.45163 6.55127 1.75 6.55127H2.125V19.3013C2.125 19.7985 2.32254 20.2755 2.67417 20.6271C3.02581 20.9787 3.50272 21.1763 4 21.1763H16C16.4973 21.1763 16.9742 20.9787 17.3258 20.6271C17.6775 20.2755 17.875 19.7985 17.875 19.3013V6.55127H18.25C18.5484 6.55127 18.8345 6.43274 19.0455 6.22176C19.2565 6.01079 19.375 5.72464 19.375 5.42627C19.375 5.1279 19.2565 4.84175 19.0455 4.63077C18.8345 4.4198 18.5484 4.30127 18.25 4.30127ZM7.375 3.17627C7.375 3.07681 7.41451 2.98143 7.48483 2.9111C7.55516 2.84078 7.65054 2.80127 7.75 2.80127H12.25C12.3495 2.80127 12.4448 2.84078 12.5152 2.9111C12.5855 2.98143 12.625 3.07681 12.625 3.17627V4.30127H7.375V3.17627ZM15.625 18.9263H4.375V6.55127H15.625V18.9263ZM8.875 9.55127V15.5513C8.875 15.8496 8.75647 16.1358 8.5455 16.3468C8.33452 16.5577 8.04837 16.6763 7.75 16.6763C7.45163 16.6763 7.16548 16.5577 6.9545 16.3468C6.74353 16.1358 6.625 15.8496 6.625 15.5513V9.55127C6.625 9.2529 6.74353 8.96675 6.9545 8.75577C7.16548 8.5448 7.45163 8.42627 7.75 8.42627C8.04837 8.42627 8.33452 8.5448 8.5455 8.75577C8.75647 8.96675 8.875 9.2529 8.875 9.55127ZM13.375 9.55127V15.5513C13.375 15.8496 13.2565 16.1358 13.0455 16.3468C12.8345 16.5577 12.5484 16.6763 12.25 16.6763C11.9516 16.6763 11.6655 16.5577 11.4545 16.3468C11.2435 16.1358 11.125 15.8496 11.125 15.5513V9.55127C11.125 9.2529 11.2435 8.96675 11.4545 8.75577C11.6655 8.5448 11.9516 8.42627 12.25 8.42627C12.5484 8.42627 12.8345 8.5448 13.0455 8.75577C13.2565 8.96675 13.375 9.2529 13.375 9.55127Z" fill="white"/>
          </svg>
        </button>
        <button type="button" class="close-button" id="close">
          <svg width="14" height="15" viewBox="0 0 16 17" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M15.5459 14.7554C15.7572 14.9667 15.876 15.2534 15.876 15.5522C15.876 15.8511 15.7572 16.1378 15.5459 16.3491C15.3346 16.5605 15.0479 16.6792 14.749 16.6792C14.4501 16.6792 14.1635 16.5605 13.9521 16.3491L7.99996 10.3951L2.0459 16.3472C1.83455 16.5586 1.54791 16.6773 1.24902 16.6773C0.950136 16.6773 0.663491 16.5586 0.452147 16.3472C0.240802 16.1359 0.12207 15.8493 0.12207 15.5504C0.12207 15.2515 0.240803 14.9648 0.452147 14.7535L6.40621 8.80131L0.454022 2.84725C0.242677 2.6359 0.123945 2.34926 0.123945 2.05037C0.123945 1.75149 0.242677 1.46484 0.454022 1.2535C0.665366 1.04215 0.95201 0.923423 1.2509 0.923423C1.54978 0.923423 1.83643 1.04215 2.04777 1.2535L7.99996 7.20756L13.954 1.25256C14.1654 1.04122 14.452 0.922485 14.7509 0.922485C15.0498 0.922485 15.3364 1.04122 15.5478 1.25256C15.7591 1.46391 15.8778 1.75055 15.8778 2.04944C15.8778 2.34832 15.7591 2.63497 15.5478 2.84631L9.59371 8.80131L15.5459 14.7554Z" fill="white"/>
          </svg>
        </button>
      </div>
      <div class="modal-body">
        <div class="progress-container">
          <div class="progress-bar animate" style="width: 70%;">70%</div>
        </div>
        <div class="media-details">
          <div>
            <p>
              <svg
                width="17"
                height="12"
                viewBox="0 0 17 12"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  d="M16.1873 5.69562C16.1641 5.645 15.6166 4.42937 14.4073 3.22C12.7891 1.60437 10.7498 0.75 8.49976 0.75C6.24976 0.75 4.21038 1.60437 2.59413 3.22C1.38476 4.42937 0.837257 5.645 0.812257 5.69562C0.769915 5.79162 0.748047 5.89539 0.748047 6.00031C0.748047 6.10523 0.769915 6.209 0.812257 6.305C0.835382 6.35625 1.38288 7.57125 2.59288 8.78063C4.21038 10.3963 6.24976 11.25 8.49976 11.25C10.7498 11.25 12.7891 10.3963 14.4048 8.78063C15.6148 7.57125 16.1623 6.35625 16.1854 6.305C16.228 6.20913 16.2502 6.10543 16.2505 6.00051C16.2509 5.89559 16.2293 5.79175 16.1873 5.69562ZM13.3085 7.75813C11.9666 9.07938 10.3491 9.75 8.49976 9.75C6.65038 9.75 5.03288 9.07937 3.69288 7.7575C3.1656 7.23577 2.71203 6.64447 2.34476 6C2.71214 5.35579 3.1657 4.76471 3.69288 4.24312C5.03351 2.92062 6.65038 2.25 8.49976 2.25C10.3491 2.25 11.966 2.92062 13.3066 4.24312C13.8339 4.76467 14.2874 5.35575 14.6548 6C14.2874 6.64443 13.8339 7.23572 13.3066 7.7575L13.3085 7.75813ZM8.49976 3.25C7.95586 3.25 7.42417 3.41128 6.97194 3.71346C6.5197 4.01563 6.16723 4.44512 5.95909 4.94762C5.75095 5.45012 5.69649 6.00305 5.8026 6.5365C5.90871 7.06995 6.17062 7.55995 6.55521 7.94454C6.93981 8.32914 7.42981 8.59105 7.96326 8.69716C8.49671 8.80327 9.04964 8.74881 9.55214 8.54067C10.0546 8.33253 10.4841 7.98005 10.7863 7.52782C11.0885 7.07558 11.2498 6.5439 11.2498 6C11.2489 5.27091 10.9589 4.57192 10.4434 4.05637C9.92784 3.54082 9.22885 3.25083 8.49976 3.25ZM8.49976 7.25C8.25253 7.25 8.01086 7.17669 7.80529 7.03934C7.59973 6.90199 7.43952 6.70676 7.34491 6.47835C7.2503 6.24995 7.22554 5.99861 7.27378 5.75614C7.32201 5.51366 7.44106 5.29093 7.61587 5.11612C7.79069 4.9413 8.01342 4.82225 8.25589 4.77402C8.49837 4.72579 8.7497 4.75054 8.97811 4.84515C9.20652 4.93976 9.40174 5.09998 9.53909 5.30554C9.67645 5.5111 9.74976 5.75277 9.74976 6C9.74976 6.33152 9.61806 6.64946 9.38364 6.88388C9.14922 7.1183 8.83128 7.25 8.49976 7.25Z"
                  fill="#FF0828"
                />
              </svg>
              <span>233809</span>
            </p>
            <p>
              <svg
                width="15"
                height="14"
                viewBox="0 0 15 14"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  d="M10.625 0.75C9.36938 0.75 8.255 1.24563 7.5 2.0975C6.745 1.24563 5.63062 0.75 4.375 0.75C3.28139 0.751323 2.23295 1.18635 1.45965 1.95965C0.686345 2.73295 0.251323 3.78139 0.25 4.875C0.25 9.39625 6.86312 13.0088 7.14437 13.1606C7.25367 13.2195 7.37586 13.2503 7.5 13.2503C7.62414 13.2503 7.74633 13.2195 7.85563 13.1606C8.13688 13.0088 14.75 9.39625 14.75 4.875C14.7487 3.78139 14.3137 2.73295 13.5404 1.95965C12.7671 1.18635 11.7186 0.751323 10.625 0.75ZM10.2819 9.6475C9.41142 10.3861 8.48091 11.0509 7.5 11.635C6.51909 11.0509 5.58858 10.3861 4.71812 9.6475C3.36375 8.48563 1.75 6.71375 1.75 4.875C1.75 4.17881 2.02656 3.51113 2.51884 3.01884C3.01113 2.52656 3.67881 2.25 4.375 2.25C5.4875 2.25 6.41875 2.8375 6.80562 3.78375C6.86193 3.92169 6.95805 4.03974 7.08172 4.12283C7.20539 4.20592 7.35101 4.2503 7.5 4.2503C7.64899 4.2503 7.79461 4.20592 7.91828 4.12283C8.04195 4.03974 8.13807 3.92169 8.19438 3.78375C8.58125 2.8375 9.5125 2.25 10.625 2.25C11.3212 2.25 11.9889 2.52656 12.4812 3.01884C12.9734 3.51113 13.25 4.17881 13.25 4.875C13.25 6.71375 11.6362 8.48563 10.2819 9.6475Z"
                  fill="#FF0828"
                />
              </svg>

              <span>45</span>
            </p>
          </div>
          <span>2 hrs ago</span>
        </div>
      </div>
    `;

    main.appendChild(storyPreviewModal);

    storyPreviewModal.showModal();

    const previewDeleteButton = storyPreviewModal.querySelector("#delete");
    const previewCloseButton = storyPreviewModal.querySelector("#close");

    previewCloseButton.addEventListener("click", () => {
      storyPreviewModal.close();
      storyPreviewModal.remove();
    });

    const previewDeleteModal = document.querySelector(".modal-wrapper");

    previewDeleteButton.addEventListener("click", () => {
      previewDeleteModal.innerHTML = `
          <div class="modal-heading">
            <p>
              <img src="./assets/icons/bin.svg" alt="bin" />
              <span>Delete?</span>
            </p>
          </div>
          <div class="modal-body">
          <span>Oh no!</span>
            <h2>Are you sure you want to delete this Story?</h2>
            <p class="button-section">
              <button id="confirm-delete">
                <span>Yes, Delete</span>
              </button>
              <button id="cancel-button">Cancel</button>
            </p>
          </div>
        `;
      previewDeleteModal.classList.add("animated-modal", "active");
      previewDeleteModal.showModal();

      const confirmDeleteButton =
        previewDeleteModal.querySelector("#confirm-delete");

      confirmDeleteButton.addEventListener("click", () => {
        createAlert("deleted", "./assets/icons/bin.svg", "red-5");

        setTimeout(() => {
          previewDeleteModal.close();
          storyPreviewModal.close();
          storyPreviewModal.remove();
        }, 800);
      });

      const confirmCancelButton =
        previewDeleteModal.querySelector("#cancel-button");

      confirmCancelButton.addEventListener("click", () => {
        previewDeleteModal.classList.remove("active");
        previewDeleteModal.classList.add("closing");

        setTimeout(() => {
          previewDeleteModal.classList.remove("closing");
          previewDeleteModal.close();
        }, 400);
      });
    });
  });
});

// Edit Category Modal
const editCategoryModal = (category) => {
  return new Promise((resolve) => {
    const modal = existingModal.cloneNode(true);
    modal.id = "edit-category-modal";
    modal.classList.add("category-modal", "lined-modal");

    modal.innerHTML = `
          <div class="modal-heading">
            <p>
              <svg width="18" height="15" viewBox="0 0 21 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M0.625 2C0.625 1.70163 0.743526 1.41548 0.954505 1.2045C1.16548 0.993526 1.45163 0.875 1.75 0.875H18.25C18.5484 0.875 18.8345 0.993526 19.0455 1.2045C19.2565 1.41548 19.375 1.70163 19.375 2C19.375 2.29837 19.2565 2.58452 19.0455 2.7955C18.8345 3.00647 18.5484 3.125 18.25 3.125H1.75C1.45163 3.125 1.16548 3.00647 0.954505 2.7955C0.743526 2.58452 0.625 2.29837 0.625 2ZM1.75 9.125H18.25C18.5484 9.125 18.8345 9.00647 19.0455 8.79549C19.2565 8.58452 19.375 8.29837 19.375 8C19.375 7.70163 19.2565 7.41548 19.0455 7.2045C18.8345 6.99353 18.5484 6.875 18.25 6.875H1.75C1.45163 6.875 1.16548 6.99353 0.954505 7.2045C0.743526 7.41548 0.625 7.70163 0.625 8C0.625 8.29837 0.743526 8.58452 0.954505 8.79549C1.16548 9.00647 1.45163 9.125 1.75 9.125ZM11.5 12.875H1.75C1.45163 12.875 1.16548 12.9935 0.954505 13.2045C0.743526 13.4155 0.625 13.7016 0.625 14C0.625 14.2984 0.743526 14.5845 0.954505 14.7955C1.16548 15.0065 1.45163 15.125 1.75 15.125H11.5C11.7984 15.125 12.0845 15.0065 12.2955 14.7955C12.5065 14.5845 12.625 14.2984 12.625 14C12.625 13.7016 12.5065 13.4155 12.2955 13.2045C12.0845 12.9935 11.7984 12.875 11.5 12.875ZM19.75 12.875H18.625V11.75C18.625 11.4516 18.5065 11.1655 18.2955 10.9545C18.0845 10.7435 17.7984 10.625 17.5 10.625C17.2016 10.625 16.9155 10.7435 16.7045 10.9545C16.4935 11.1655 16.375 11.4516 16.375 11.75V12.875H15.25C14.9516 12.875 14.6655 12.9935 14.4545 13.2045C14.2435 13.4155 14.125 13.7016 14.125 14C14.125 14.2984 14.2435 14.5845 14.4545 14.7955C14.6655 15.0065 14.9516 15.125 15.25 15.125H16.375V16.25C16.375 16.5484 16.4935 16.8345 16.7045 17.0455C16.9155 17.2565 17.2016 17.375 17.5 17.375C17.7984 17.375 18.0845 17.2565 18.2955 17.0455C18.5065 16.8345 18.625 16.5484 18.625 16.25V15.125H19.75C20.0484 15.125 20.3345 15.0065 20.5455 14.7955C20.7565 14.5845 20.875 14.2984 20.875 14C20.875 13.7016 20.7565 13.4155 20.5455 13.2045C20.3345 12.9935 20.0484 12.875 19.75 12.875Z" fill="#2D2C2C"/>
              </svg>
              <span>Edit Menu Category</span>
            </p>
            <button type="button" class="close-button">
              <img
                src="./assets/icons/close.svg"
                alt="close icon"
                class="close-icon"
              />
            </button>
          </div>
          <div class="modal-body">
            <form action="">
              <div class="form-group">
                <div class="floating-controls">
                  <input
                    type="text"
                    id="edit-menu-category-name"
                    name="edit-menu-category-name"
                    placeholder=" "
                    value="${category.name}"
                  />
                  <label for="edit-menu-category-name">Menu Category Name</label>
                  <p class="hint">Give this menu category a title</p>
                </div>
                  <div class="floating-controls dropdown selected">
                  <button type="button" id="edit-menu-category-type">${category.type}</button>
                  <label>
                    <span>Menu Type</span>
                  </label>
                  <img
                    src="./assets/icons/gray-arrow-down.svg"
                    alt="down arrow"
                    class="right-arrow"
                  />
                  <ul>
                    <span>Select Menu Type</span>
                    <li>
                      <svg width="24" height="24" fill="none">
                        <use
                          xlink:href="./assets/icons/menu-type.svg#icon-vegetarian"
                        ></use>
                      </svg>
                      <span>Vegetarian</span>
                    </li>
                    <li>
                      <svg width="24" height="24" fill="none">
                        <use
                          xlink:href="./assets/icons/menu-type.svg#icon-non-vegetarian"
                        ></use>
                      </svg>
                      <span>Non-vegetarian</span>
                    </li>
                  </ul>
                  <p class="hint">Dish type for more flexibility</p>
                </div>
              </div>
            </form>
            <button class="primary-button" id="confirm-update">
              <span>Update</span>
              <svg width="18" height="17" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M10.5 0.25C8.57164 0.25 6.68657 0.821828 5.08319 1.89317C3.47982 2.96451 2.23013 4.48726 1.49218 6.26884C0.754225 8.05042 0.561142 10.0108 0.937348 11.9021C1.31355 13.7934 2.24215 15.5307 3.60571 16.8943C4.96928 18.2579 6.70656 19.1865 8.59787 19.5627C10.4892 19.9389 12.4496 19.7458 14.2312 19.0078C16.0127 18.2699 17.5355 17.0202 18.6068 15.4168C19.6782 13.8134 20.25 11.9284 20.25 10C20.2473 7.41498 19.2192 4.93661 17.3913 3.10872C15.5634 1.28084 13.085 0.25273 10.5 0.25ZM14.7806 8.28063L9.53063 13.5306C9.46097 13.6004 9.37826 13.6557 9.28721 13.6934C9.19616 13.7312 9.09857 13.7506 9 13.7506C8.90144 13.7506 8.80385 13.7312 8.7128 13.6934C8.62175 13.6557 8.53903 13.6004 8.46938 13.5306L6.21938 11.2806C6.07865 11.1399 5.99959 10.949 5.99959 10.75C5.99959 10.551 6.07865 10.3601 6.21938 10.2194C6.36011 10.0786 6.55098 9.99958 6.75 9.99958C6.94903 9.99958 7.1399 10.0786 7.28063 10.2194L9 11.9397L13.7194 7.21937C13.7891 7.14969 13.8718 7.09442 13.9628 7.0567C14.0539 7.01899 14.1515 6.99958 14.25 6.99958C14.3486 6.99958 14.4461 7.01899 14.5372 7.0567C14.6282 7.09442 14.7109 7.14969 14.7806 7.21937C14.8503 7.28906 14.9056 7.37178 14.9433 7.46283C14.981 7.55387 15.0004 7.65145 15.0004 7.75C15.0004 7.84855 14.981 7.94613 14.9433 8.03717C14.9056 8.12822 14.8503 8.21094 14.7806 8.28063Z" fill="white"/>
              </svg>
            </button>
          </div>
        `;

    main.appendChild(modal);
    modal.showModal();

    const updateButton = modal.querySelector("#confirm-update");
    updateButton.addEventListener("click", () => {
      const categoryName = modal
        .querySelector("#edit-menu-category-name")
        .value.trim();
      const categoryType = modal
        .querySelector("#edit-menu-category-type")
        .textContent.trim();

      if (!categoryName || !categoryType) {
        createAlert(
          "fill all fields",
          "./assets/icons/filled-check.svg",
          "red-5"
        );
      } else {
        createAlert(
          "menu list updated",
          "./assets/icons/filled-check.svg",
          "green-4"
        );
        setTimeout(() => {
          modal.close();
          modal.remove();
          resolve({
            name: categoryName.toLowerCase(),
            type: categoryType.toLowerCase(),
            id: category.id,
            dateCreated: category.dateCreated,
            availability: category.availability,
            status: category.status,
            dishes: category.dishes,
          });
        }, 800);
      }
      createAlert(
        "menu list updated",
        "./assets/icons/filled-check.svg",
        "green-4"
      );
    });

    setupDropdownDelegation(modal);

    const closeButton = modal.querySelector(".close-button");

    closeButton.addEventListener("click", () => {
      modal.close();
      modal.remove();
      resolve(null);
    });
  });
};

const newMenuCategoryModal = () => {
  return new Promise((resolve) => {
    const modal = existingModal.cloneNode(true);
    modal.id = "create-category-modal";
    modal.classList.add("category-modal", "lined-modal");

    modal.innerHTML = `
      <div class="modal-heading">
        <p>
          <svg width="18" height="15" viewBox="0 0 21 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0.625 2C0.625 1.70163 0.743526 1.41548 0.954505 1.2045C1.16548 0.993526 1.45163 0.875 1.75 0.875H18.25C18.5484 0.875 18.8345 0.993526 19.0455 1.2045C19.2565 1.41548 19.375 1.70163 19.375 2C19.375 2.29837 19.2565 2.58452 19.0455 2.7955C18.8345 3.00647 18.5484 3.125 18.25 3.125H1.75C1.45163 3.125 1.16548 3.00647 0.954505 2.7955C0.743526 2.58452 0.625 2.29837 0.625 2ZM1.75 9.125H18.25C18.5484 9.125 18.8345 9.00647 19.0455 8.79549C19.2565 8.58452 19.375 8.29837 19.375 8C19.375 7.70163 19.2565 7.41548 19.0455 7.2045C18.8345 6.99353 18.5484 6.875 18.25 6.875H1.75C1.45163 6.875 1.16548 6.99353 0.954505 7.2045C0.743526 7.41548 0.625 7.70163 0.625 8C0.625 8.29837 0.743526 8.58452 0.954505 8.79549C1.16548 9.00647 1.45163 9.125 1.75 9.125ZM11.5 12.875H1.75C1.45163 12.875 1.16548 12.9935 0.954505 13.2045C0.743526 13.4155 0.625 13.7016 0.625 14C0.625 14.2984 0.743526 14.5845 0.954505 14.7955C1.16548 15.0065 1.45163 15.125 1.75 15.125H11.5C11.7984 15.125 12.0845 15.0065 12.2955 14.7955C12.5065 14.5845 12.625 14.2984 12.625 14C12.625 13.7016 12.5065 13.4155 12.2955 13.2045C12.0845 12.9935 11.7984 12.875 11.5 12.875ZM19.75 12.875H18.625V11.75C18.625 11.4516 18.5065 11.1655 18.2955 10.9545C18.0845 10.7435 17.7984 10.625 17.5 10.625C17.2016 10.625 16.9155 10.7435 16.7045 10.9545C16.4935 11.1655 16.375 11.4516 16.375 11.75V12.875H15.25C14.9516 12.875 14.6655 12.9935 14.4545 13.2045C14.2435 13.4155 14.125 13.7016 14.125 14C14.125 14.2984 14.2435 14.5845 14.4545 14.7955C14.6655 15.0065 14.9516 15.125 15.25 15.125H16.375V16.25C16.375 16.5484 16.4935 16.8345 16.7045 17.0455C16.9155 17.2565 17.2016 17.375 17.5 17.375C17.7984 17.375 18.0845 17.2565 18.2955 17.0455C18.5065 16.8345 18.625 16.5484 18.625 16.25V15.125H19.75C20.0484 15.125 20.3345 15.0065 20.5455 14.7955C20.7565 14.5845 20.875 14.2984 20.875 14C20.875 13.7016 20.7565 13.4155 20.5455 13.2045C20.3345 12.9935 20.0484 12.875 19.75 12.875Z" fill="#2D2C2C"/>
          </svg>
          <span>Create Menu Category</span>
        </p>
        <button type="button" class="close-button">
          <img
            src="./assets/icons/close.svg"
            alt="close icon"
            class="close-icon"
          />
        </button>
      </div>
      <div class="modal-body">
        <form action="">
          <div class="form-group">
            <div class="floating-controls">
              <input
                type="text"
                id="menu-category-name"
                name="menu-category-name"
                placeholder=" "
              />
              <label for="menu-category-name">Menu Category Name</label>
              <p class="hint">Give this menu category a title</p>
            </div>
            <div class="floating-controls dropdown">
              <button type="button" id="menu-category-type"></button>
              <label>
                <span>Menu Type</span>
              </label>
              <img
                src="./assets/icons/gray-arrow-down.svg"
                alt="down arrow"
                class="right-arrow"
              />
              <ul>
                <span>Select Menu Type</span>
                <li>
                  <svg width="24" height="24" fill="none">
                    <use
                      xlink:href="./assets/icons/menu-type.svg#icon-vegetarian"
                    ></use>
                  </svg>
                  <span>Vegetarian</span>
                </li>
                <li>
                  <svg width="24" height="24" fill="none">
                    <use
                      xlink:href="./assets/icons/menu-type.svg#icon-non-vegetarian"
                    ></use>
                  </svg>
                  <span>Non-vegetarian</span>
                </li>
              </ul>
              <p class="hint">Dish type for more flexibility</p>
            </div>
          </div>
        </form>
        <button class="primary-button confirm-publish">
          <span>Publish</span>
          <svg width="18" height="17" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M10.5 0.25C8.57164 0.25 6.68657 0.821828 5.08319 1.89317C3.47982 2.96451 2.23013 4.48726 1.49218 6.26884C0.754225 8.05042 0.561142 10.0108 0.937348 11.9021C1.31355 13.7934 2.24215 15.5307 3.60571 16.8943C4.96928 18.2579 6.70656 19.1865 8.59787 19.5627C10.4892 19.9389 12.4496 19.7458 14.2312 19.0078C16.0127 18.2699 17.5355 17.0202 18.6068 15.4168C19.6782 13.8134 20.25 11.9284 20.25 10C20.2473 7.41498 19.2192 4.93661 17.3913 3.10872C15.5634 1.28084 13.085 0.25273 10.5 0.25ZM14.7806 8.28063L9.53063 13.5306C9.46097 13.6004 9.37826 13.6557 9.28721 13.6934C9.19616 13.7312 9.09857 13.7506 9 13.7506C8.90144 13.7506 8.80385 13.7312 8.7128 13.6934C8.62175 13.6557 8.53903 13.6004 8.46938 13.5306L6.21938 11.2806C6.07865 11.1399 5.99959 10.949 5.99959 10.75C5.99959 10.551 6.07865 10.3601 6.21938 10.2194C6.36011 10.0786 6.55098 9.99958 6.75 9.99958C6.94903 9.99958 7.1399 10.0786 7.28063 10.2194L9 11.9397L13.7194 7.21937C13.7891 7.14969 13.8718 7.09442 13.9628 7.0567C14.0539 7.01899 14.1515 6.99958 14.25 6.99958C14.3486 6.99958 14.4461 7.01899 14.5372 7.0567C14.6282 7.09442 14.7109 7.14969 14.7806 7.21937C14.8503 7.28906 14.9056 7.37178 14.9433 7.46283C14.981 7.55387 15.0004 7.65145 15.0004 7.75C15.0004 7.84855 14.981 7.94613 14.9433 8.03717C14.9056 8.12822 14.8503 8.21094 14.7806 8.28063Z" fill="white"/>
          </svg>
        </button>
      </div>
    `;

    main.appendChild(modal);
    modal.showModal();

    const publishButton = modal.querySelector(".confirm-publish");
    publishButton.addEventListener("click", () => {
      const categoryName = modal
        .querySelector("#menu-category-name")
        .value.trim();
      const categoryType = modal
        .querySelector("#menu-category-type")
        .textContent.trim();

      if (!categoryName || !categoryType) {
        createAlert(
          "fill all fields",
          "./assets/icons/filled-check.svg",
          "red-5"
        );
      } else {
        const categoryId = generateUniqueId("menuCategory");
        createAlert(
          "menu list updated",
          "./assets/icons/filled-check.svg",
          "green-4"
        );
        setTimeout(() => {
          modal.close();
          modal.remove();
          resolve({
            id: categoryId,
            name: categoryName.toLowerCase(),
            type: categoryType.toLowerCase(),
          });
        }, 800);
      }
    });

    setupDropdownDelegation(modal);

    const closeButton = modal.querySelector(".close-button");

    closeButton.addEventListener("click", () => {
      modal.close();
      modal.remove();
      resolve(null);
    });
  });
};

const newItemCategoryModal = () => {
  return new Promise((resolve) => {
    const modal = existingModal.cloneNode(true);
    modal.id = "new-category-modal";
    modal.classList.add("category-modal", "lined-modal");

    modal.innerHTML = `
      <div class="modal-heading">
        <p>
          <svg width="18" height="15" viewBox="0 0 21 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0.625 2C0.625 1.70163 0.743526 1.41548 0.954505 1.2045C1.16548 0.993526 1.45163 0.875 1.75 0.875H18.25C18.5484 0.875 18.8345 0.993526 19.0455 1.2045C19.2565 1.41548 19.375 1.70163 19.375 2C19.375 2.29837 19.2565 2.58452 19.0455 2.7955C18.8345 3.00647 18.5484 3.125 18.25 3.125H1.75C1.45163 3.125 1.16548 3.00647 0.954505 2.7955C0.743526 2.58452 0.625 2.29837 0.625 2ZM1.75 9.125H18.25C18.5484 9.125 18.8345 9.00647 19.0455 8.79549C19.2565 8.58452 19.375 8.29837 19.375 8C19.375 7.70163 19.2565 7.41548 19.0455 7.2045C18.8345 6.99353 18.5484 6.875 18.25 6.875H1.75C1.45163 6.875 1.16548 6.99353 0.954505 7.2045C0.743526 7.41548 0.625 7.70163 0.625 8C0.625 8.29837 0.743526 8.58452 0.954505 8.79549C1.16548 9.00647 1.45163 9.125 1.75 9.125ZM11.5 12.875H1.75C1.45163 12.875 1.16548 12.9935 0.954505 13.2045C0.743526 13.4155 0.625 13.7016 0.625 14C0.625 14.2984 0.743526 14.5845 0.954505 14.7955C1.16548 15.0065 1.45163 15.125 1.75 15.125H11.5C11.7984 15.125 12.0845 15.0065 12.2955 14.7955C12.5065 14.5845 12.625 14.2984 12.625 14C12.625 13.7016 12.5065 13.4155 12.2955 13.2045C12.0845 12.9935 11.7984 12.875 11.5 12.875ZM19.75 12.875H18.625V11.75C18.625 11.4516 18.5065 11.1655 18.2955 10.9545C18.0845 10.7435 17.7984 10.625 17.5 10.625C17.2016 10.625 16.9155 10.7435 16.7045 10.9545C16.4935 11.1655 16.375 11.4516 16.375 11.75V12.875H15.25C14.9516 12.875 14.6655 12.9935 14.4545 13.2045C14.2435 13.4155 14.125 13.7016 14.125 14C14.125 14.2984 14.2435 14.5845 14.4545 14.7955C14.6655 15.0065 14.9516 15.125 15.25 15.125H16.375V16.25C16.375 16.5484 16.4935 16.8345 16.7045 17.0455C16.9155 17.2565 17.2016 17.375 17.5 17.375C17.7984 17.375 18.0845 17.2565 18.2955 17.0455C18.5065 16.8345 18.625 16.5484 18.625 16.25V15.125H19.75C20.0484 15.125 20.3345 15.0065 20.5455 14.7955C20.7565 14.5845 20.875 14.2984 20.875 14C20.875 13.7016 20.7565 13.4155 20.5455 13.2045C20.3345 12.9935 20.0484 12.875 19.75 12.875Z" fill="#2D2C2C"/>
          </svg>
          <span>Create Item Category</span>
        </p>
        <button type="button" class="close-button">
          <img
            src="./assets/icons/close.svg"
            alt="close icon"
            class="close-icon"
          />
        </button>
      </div>
      <div class="modal-body">
        <form action="">
          <div class="form-group">
            <label class="checkbox" for="new-category-required-checkbox">
              <input type="checkbox" id="new-category-required-checkbox" name="new-category-required-checkbox"/>
              <svg
                width="20"
                height="20"
                viewBox="0 0 20 20"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  d="M10 0.25C8.07164 0.25 6.18657 0.821828 4.58319 1.89317C2.97982 2.96451 1.73013 4.48726 0.992179 6.26884C0.254225 8.05042 0.061142 10.0108 0.437348 11.9021C0.813554 13.7934 1.74215 15.5307 3.10571 16.8943C4.46928 18.2579 6.20656 19.1865 8.09787 19.5627C9.98919 19.9389 11.9496 19.7458 13.7312 19.0078C15.5127 18.2699 17.0355 17.0202 18.1068 15.4168C19.1782 13.8134 19.75 11.9284 19.75 10C19.7473 7.41498 18.7192 4.93661 16.8913 3.10872C15.0634 1.28084 12.585 0.25273 10 0.25ZM14.2806 8.28063L9.03063 13.5306C8.96097 13.6004 8.87826 13.6557 8.78721 13.6934C8.69616 13.7312 8.59857 13.7506 8.5 13.7506C8.40144 13.7506 8.30385 13.7312 8.2128 13.6934C8.12175 13.6557 8.03903 13.6004 7.96938 13.5306L5.71938 11.2806C5.57865 11.1399 5.49959 10.949 5.49959 10.75C5.49959 10.551 5.57865 10.3601 5.71938 10.2194C5.86011 10.0786 6.05098 9.99958 6.25 9.99958C6.44903 9.99958 6.6399 10.0786 6.78063 10.2194L8.5 11.9397L13.2194 7.21937C13.2891 7.14969 13.3718 7.09442 13.4628 7.0567C13.5539 7.01899 13.6515 6.99958 13.75 6.99958C13.8486 6.99958 13.9461 7.01899 14.0372 7.0567C14.1282 7.09442 14.2109 7.14969 14.2806 7.21937C14.3503 7.28906 14.4056 7.37178 14.4433 7.46283C14.481 7.55387 14.5004 7.65145 14.5004 7.75C14.5004 7.84855 14.481 7.94613 14.4433 8.03717C14.4056 8.12822 14.3503 8.21094 14.2806 8.28063Z"
                  fill="none"
                  fill-opacity="0.6"
                />
              </svg>
              <span>Required</span>
            </label>
            <div class="floating-controls dropdown">
              <button type="button" id="selectable-items-no"></button>
              <label>
                <span>No. of Selectable Side Item</span>
              </label>
              <img
                src="./assets/icons/gray-arrow-down.svg"
                alt="down arrow"
                class="right-arrow"
              />
              <ul>
                <span>No. of Selectable Side Item</span>
                <div>
                  <li>1</li>
                  <li>2</li>
                  <li>3</li>
                  <li>4</li>
                  <li>5</li>
                  <li>6</li>
                  <li>7</li>
                  <li>8</li>
                  <li>9</li>
                  <li>10</li>
                </div>
              </ul>
              <p class="hint"></p>
            </div>
            <div class="floating-controls">
              <input
                type="text"
                id="new-category-name"
                name="new-category-name"
                placeholder=" "
              />
              <label for="new-category-name">Category Name</label>
              <p class="hint">Give this menu category a title</p>
            </div>
            <div class="floating-controls dropdown">
              <button type="button" id="new-category-type"></button>
              <label>
                <span>Category Type</span>
              </label>
              <img
                src="./assets/icons/gray-arrow-down.svg"
                alt="down arrow"
                class="right-arrow"
              />
              <ul>
                <span>Select Category Type</span>
                <li>
                  <svg width="24" height="24" fill="none">
                    <use
                      xlink:href="./assets/icons/menu-type.svg#icon-vegetarian"
                    ></use>
                  </svg>
                  <span>Vegetarian</span>
                </li>
                <li>
                  <svg width="24" height="24" fill="none">
                    <use
                      xlink:href="./assets/icons/menu-type.svg#icon-non-vegetarian"
                    ></use>
                  </svg>
                  <span>Non-vegetarian</span>
                </li>
              </ul>
              <p class="hint">Dish type for more flexibility</p>
            </div>
          </div>
        </form>
        <button class="primary-button confirm-publish">
          <span>Publish</span>
          <svg width="18" height="17" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M10.5 0.25C8.57164 0.25 6.68657 0.821828 5.08319 1.89317C3.47982 2.96451 2.23013 4.48726 1.49218 6.26884C0.754225 8.05042 0.561142 10.0108 0.937348 11.9021C1.31355 13.7934 2.24215 15.5307 3.60571 16.8943C4.96928 18.2579 6.70656 19.1865 8.59787 19.5627C10.4892 19.9389 12.4496 19.7458 14.2312 19.0078C16.0127 18.2699 17.5355 17.0202 18.6068 15.4168C19.6782 13.8134 20.25 11.9284 20.25 10C20.2473 7.41498 19.2192 4.93661 17.3913 3.10872C15.5634 1.28084 13.085 0.25273 10.5 0.25ZM14.7806 8.28063L9.53063 13.5306C9.46097 13.6004 9.37826 13.6557 9.28721 13.6934C9.19616 13.7312 9.09857 13.7506 9 13.7506C8.90144 13.7506 8.80385 13.7312 8.7128 13.6934C8.62175 13.6557 8.53903 13.6004 8.46938 13.5306L6.21938 11.2806C6.07865 11.1399 5.99959 10.949 5.99959 10.75C5.99959 10.551 6.07865 10.3601 6.21938 10.2194C6.36011 10.0786 6.55098 9.99958 6.75 9.99958C6.94903 9.99958 7.1399 10.0786 7.28063 10.2194L9 11.9397L13.7194 7.21937C13.7891 7.14969 13.8718 7.09442 13.9628 7.0567C14.0539 7.01899 14.1515 6.99958 14.25 6.99958C14.3486 6.99958 14.4461 7.01899 14.5372 7.0567C14.6282 7.09442 14.7109 7.14969 14.7806 7.21937C14.8503 7.28906 14.9056 7.37178 14.9433 7.46283C14.981 7.55387 15.0004 7.65145 15.0004 7.75C15.0004 7.84855 14.981 7.94613 14.9433 8.03717C14.9056 8.12822 14.8503 8.21094 14.7806 8.28063Z" fill="white"/>
          </svg>
        </button>
      </div>
    `;

    main.appendChild(modal);
    modal.showModal();

    const updateButton = modal.querySelector(".confirm-publish");
    updateButton.addEventListener("click", () => {
      const noSelectableItems = modal
        .querySelector("#selectable-items-no")
        .textContent.trim();
      const categoryName = modal
        .querySelector("#new-category-name")
        .value.trim();
      const categoryType = modal
        .querySelector("#new-category-type")
        .textContent.trim();
      const requiredCheckbox = modal.querySelector(
        "#new-category-required-checkbox"
      ).checked;

      if (!noSelectableItems || !categoryName || !categoryType) {
        createAlert(
          "fill all fields",
          "./assets/icons/filled-check.svg",
          "red-5"
        );
      } else {
        const categoryId = generateUniqueId("sideItemCategory");
        createAlert(
          "menu list updated",
          "./assets/icons/filled-check.svg",
          "green-4"
        );
        setTimeout(() => {
          modal.close();
          modal.remove();
          resolve({
            id: categoryId,
            name: categoryName.toLowerCase(),
            type: categoryType.toLowerCase(),
            noOfSides: noSelectableItems,
            required: requiredCheckbox,
            status: "enabled",
          });
        }, 800);
      }
    });

    setupDropdownDelegation(modal);

    const closeButton = modal.querySelector(".close-button");

    closeButton.addEventListener("click", () => {
      modal.close();
      modal.remove();
      resolve(null);
    });
  });
};

const editItemCategoryModal = (data) => {
  return new Promise((resolve) => {
    const modal = existingModal.cloneNode(true);
    modal.id = "edit-item-category-modal";
    modal.classList.add("category-modal", "lined-modal");

    modal.innerHTML = `
      <div class="modal-heading">
        <p>
          <svg width="18" height="15" viewBox="0 0 21 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0.625 2C0.625 1.70163 0.743526 1.41548 0.954505 1.2045C1.16548 0.993526 1.45163 0.875 1.75 0.875H18.25C18.5484 0.875 18.8345 0.993526 19.0455 1.2045C19.2565 1.41548 19.375 1.70163 19.375 2C19.375 2.29837 19.2565 2.58452 19.0455 2.7955C18.8345 3.00647 18.5484 3.125 18.25 3.125H1.75C1.45163 3.125 1.16548 3.00647 0.954505 2.7955C0.743526 2.58452 0.625 2.29837 0.625 2ZM1.75 9.125H18.25C18.5484 9.125 18.8345 9.00647 19.0455 8.79549C19.2565 8.58452 19.375 8.29837 19.375 8C19.375 7.70163 19.2565 7.41548 19.0455 7.2045C18.8345 6.99353 18.5484 6.875 18.25 6.875H1.75C1.45163 6.875 1.16548 6.99353 0.954505 7.2045C0.743526 7.41548 0.625 7.70163 0.625 8C0.625 8.29837 0.743526 8.58452 0.954505 8.79549C1.16548 9.00647 1.45163 9.125 1.75 9.125ZM11.5 12.875H1.75C1.45163 12.875 1.16548 12.9935 0.954505 13.2045C0.743526 13.4155 0.625 13.7016 0.625 14C0.625 14.2984 0.743526 14.5845 0.954505 14.7955C1.16548 15.0065 1.45163 15.125 1.75 15.125H11.5C11.7984 15.125 12.0845 15.0065 12.2955 14.7955C12.5065 14.5845 12.625 14.2984 12.625 14C12.625 13.7016 12.5065 13.4155 12.2955 13.2045C12.0845 12.9935 11.7984 12.875 11.5 12.875ZM19.75 12.875H18.625V11.75C18.625 11.4516 18.5065 11.1655 18.2955 10.9545C18.0845 10.7435 17.7984 10.625 17.5 10.625C17.2016 10.625 16.9155 10.7435 16.7045 10.9545C16.4935 11.1655 16.375 11.4516 16.375 11.75V12.875H15.25C14.9516 12.875 14.6655 12.9935 14.4545 13.2045C14.2435 13.4155 14.125 13.7016 14.125 14C14.125 14.2984 14.2435 14.5845 14.4545 14.7955C14.6655 15.0065 14.9516 15.125 15.25 15.125H16.375V16.25C16.375 16.5484 16.4935 16.8345 16.7045 17.0455C16.9155 17.2565 17.2016 17.375 17.5 17.375C17.7984 17.375 18.0845 17.2565 18.2955 17.0455C18.5065 16.8345 18.625 16.5484 18.625 16.25V15.125H19.75C20.0484 15.125 20.3345 15.0065 20.5455 14.7955C20.7565 14.5845 20.875 14.2984 20.875 14C20.875 13.7016 20.7565 13.4155 20.5455 13.2045C20.3345 12.9935 20.0484 12.875 19.75 12.875Z" fill="#2D2C2C"/>
          </svg>
          <span>Edit Item Category</span>
        </p>
        <button type="button" class="close-button">
          <img
            src="./assets/icons/close.svg"
            alt="close icon"
            class="close-icon"
          />
        </button>
      </div>
      <div class="modal-body">
        <form action="">
          <div class="form-group">
            <label class="checkbox" for="edit-category-required-checkbox">
              <input type="checkbox" id="edit-category-required-checkbox" name="edit-category-required-checkbox" ${
                data.required ? "checked" : ""
              }/>
              <svg
                width="20"
                height="20"
                viewBox="0 0 20 20"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  d="M10 0.25C8.07164 0.25 6.18657 0.821828 4.58319 1.89317C2.97982 2.96451 1.73013 4.48726 0.992179 6.26884C0.254225 8.05042 0.061142 10.0108 0.437348 11.9021C0.813554 13.7934 1.74215 15.5307 3.10571 16.8943C4.46928 18.2579 6.20656 19.1865 8.09787 19.5627C9.98919 19.9389 11.9496 19.7458 13.7312 19.0078C15.5127 18.2699 17.0355 17.0202 18.1068 15.4168C19.1782 13.8134 19.75 11.9284 19.75 10C19.7473 7.41498 18.7192 4.93661 16.8913 3.10872C15.0634 1.28084 12.585 0.25273 10 0.25ZM14.2806 8.28063L9.03063 13.5306C8.96097 13.6004 8.87826 13.6557 8.78721 13.6934C8.69616 13.7312 8.59857 13.7506 8.5 13.7506C8.40144 13.7506 8.30385 13.7312 8.2128 13.6934C8.12175 13.6557 8.03903 13.6004 7.96938 13.5306L5.71938 11.2806C5.57865 11.1399 5.49959 10.949 5.49959 10.75C5.49959 10.551 5.57865 10.3601 5.71938 10.2194C5.86011 10.0786 6.05098 9.99958 6.25 9.99958C6.44903 9.99958 6.6399 10.0786 6.78063 10.2194L8.5 11.9397L13.2194 7.21937C13.2891 7.14969 13.3718 7.09442 13.4628 7.0567C13.5539 7.01899 13.6515 6.99958 13.75 6.99958C13.8486 6.99958 13.9461 7.01899 14.0372 7.0567C14.1282 7.09442 14.2109 7.14969 14.2806 7.21937C14.3503 7.28906 14.4056 7.37178 14.4433 7.46283C14.481 7.55387 14.5004 7.65145 14.5004 7.75C14.5004 7.84855 14.481 7.94613 14.4433 8.03717C14.4056 8.12822 14.3503 8.21094 14.2806 8.28063Z"
                  fill="none"
                  fill-opacity="0.6"
                />
              </svg>
              <span>Required</span>
            </label>
            <div class="floating-controls dropdown selected">
              <button type="button" id="edit-selectable-items-no">${
                data.noOfSides
              }</button>
              <label>
                <span>No. of Selectable Side Item</span>
              </label>
              <img
                src="./assets/icons/gray-arrow-down.svg"
                alt="down arrow"
                class="right-arrow"
              />
              <ul>
                <span>No. of Selectable Side Item</span>
                <div>
                  <li>1</li>
                  <li>2</li>
                  <li>3</li>
                  <li>4</li>
                  <li>5</li>
                  <li>6</li>
                  <li>7</li>
                  <li>8</li>
                  <li>9</li>
                  <li>10</li>
                </div>
              </ul>
              <p class="hint"></p>
            </div>
            <div class="floating-controls">
              <input
                type="text"
                id="edit-category-name"
                name="edit-category-name"
                placeholder=" "
                value="${data.name}"
              />
              <label for="edit-category-name">Category Name</label>
              <p class="hint">Give this menu category a title</p>
            </div>
            <div class="floating-controls dropdown selected">
              <button type="button" id="edit-category-type">${
                data.type
              }</button>
              <label>
                <span>Category Type</span>
              </label>
              <img
                src="./assets/icons/gray-arrow-down.svg"
                alt="down arrow"
                class="right-arrow"
              />
              <ul>
                <span>Select Category Type</span>
                <li>
                  <svg width="24" height="24" fill="none">
                    <use
                      xlink:href="./assets/icons/menu-type.svg#icon-vegetarian"
                    ></use>
                  </svg>
                  <span>Vegetarian</span>
                </li>
                <li>
                  <svg width="24" height="24" fill="none">
                    <use
                      xlink:href="./assets/icons/menu-type.svg#icon-non-vegetarian"
                    ></use>
                  </svg>
                  <span>Non-vegetarian</span>
                </li>
              </ul>
              <p class="hint">Dish type for more flexibility</p>
            </div>
          </div>
        </form>
        <button class="primary-button confirm-publish">
          <span>Publish</span>
          <svg width="18" height="17" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M10.5 0.25C8.57164 0.25 6.68657 0.821828 5.08319 1.89317C3.47982 2.96451 2.23013 4.48726 1.49218 6.26884C0.754225 8.05042 0.561142 10.0108 0.937348 11.9021C1.31355 13.7934 2.24215 15.5307 3.60571 16.8943C4.96928 18.2579 6.70656 19.1865 8.59787 19.5627C10.4892 19.9389 12.4496 19.7458 14.2312 19.0078C16.0127 18.2699 17.5355 17.0202 18.6068 15.4168C19.6782 13.8134 20.25 11.9284 20.25 10C20.2473 7.41498 19.2192 4.93661 17.3913 3.10872C15.5634 1.28084 13.085 0.25273 10.5 0.25ZM14.7806 8.28063L9.53063 13.5306C9.46097 13.6004 9.37826 13.6557 9.28721 13.6934C9.19616 13.7312 9.09857 13.7506 9 13.7506C8.90144 13.7506 8.80385 13.7312 8.7128 13.6934C8.62175 13.6557 8.53903 13.6004 8.46938 13.5306L6.21938 11.2806C6.07865 11.1399 5.99959 10.949 5.99959 10.75C5.99959 10.551 6.07865 10.3601 6.21938 10.2194C6.36011 10.0786 6.55098 9.99958 6.75 9.99958C6.94903 9.99958 7.1399 10.0786 7.28063 10.2194L9 11.9397L13.7194 7.21937C13.7891 7.14969 13.8718 7.09442 13.9628 7.0567C14.0539 7.01899 14.1515 6.99958 14.25 6.99958C14.3486 6.99958 14.4461 7.01899 14.5372 7.0567C14.6282 7.09442 14.7109 7.14969 14.7806 7.21937C14.8503 7.28906 14.9056 7.37178 14.9433 7.46283C14.981 7.55387 15.0004 7.65145 15.0004 7.75C15.0004 7.84855 14.981 7.94613 14.9433 8.03717C14.9056 8.12822 14.8503 8.21094 14.7806 8.28063Z" fill="white"/>
          </svg>
        </button>
      </div>
    `;

    main.appendChild(modal);
    modal.showModal();

    const updateButton = modal.querySelector(".confirm-publish");
    updateButton.addEventListener("click", () => {
      const noSelectableItems = modal
        .querySelector("#edit-selectable-items-no")
        .textContent.trim();
      const categoryName = modal
        .querySelector("#edit-category-name")
        .value.trim();
      const categoryType = modal
        .querySelector("#edit-category-type")
        .textContent.trim();
      const requiredCheckbox = modal.querySelector(
        "#edit-category-required-checkbox"
      ).checked;

      if (!noSelectableItems || !categoryName || !categoryType) {
        createAlert(
          "fill all fields",
          "./assets/icons/filled-check.svg",
          "red-5"
        );
      } else {
        createAlert(
          "menu list updated",
          "./assets/icons/filled-check.svg",
          "green-4"
        );
        setTimeout(() => {
          modal.close();
          modal.remove();
          resolve({
            id: data.id,
            name: categoryName.toLowerCase(),
            type: categoryType.toLowerCase(),
            noOfSides: noSelectableItems,
            required: requiredCheckbox,
            status: data.status,
            items: data.items,
          });
        }, 800);
      }
    });

    setupDropdownDelegation(modal);

    const closeButton = modal.querySelector(".close-button");

    closeButton.addEventListener("click", () => {
      modal.close();
      modal.remove();
      resolve(null);
    });
  });
};

// Rearrange Menu Category Modal
const rearrangeCategoryModal = (data) => {
  return new Promise((resolve) => {
    const modal = existingModal.cloneNode(true);
    modal.id = "rearrange-category-modal";
    modal.classList.add("category-modal", "lined-modal");

    let dummyData = data
      ? data
      : [
          { id: 1, name: "Soup", number: "01" },
          { id: 2, name: "Rice", number: "02" },
          { id: 3, name: "Drink", number: "03" },
          { id: 4, name: "Snack", number: "04" },
        ];

    modal.innerHTML = `
      <div class="modal-heading">
        <p>
          <svg width="18" height="15" viewBox="0 0 21 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0.625 2C0.625 1.70163 0.743526 1.41548 0.954505 1.2045C1.16548 0.993526 1.45163 0.875 1.75 0.875H18.25C18.5484 0.875 18.8345 0.993526 19.0455 1.2045C19.2565 1.41548 19.375 1.70163 19.375 2C19.375 2.29837 19.2565 2.58452 19.0455 2.7955C18.8345 3.00647 18.5484 3.125 18.25 3.125H1.75C1.45163 3.125 1.16548 3.00647 0.954505 2.7955C0.743526 2.58452 0.625 2.29837 0.625 2ZM1.75 9.125H18.25C18.5484 9.125 18.8345 9.00647 19.0455 8.79549C19.2565 8.58452 19.375 8.29837 19.375 8C19.375 7.70163 19.2565 7.41548 19.0455 7.2045C18.8345 6.99353 18.5484 6.875 18.25 6.875H1.75C1.45163 6.875 1.16548 6.99353 0.954505 7.2045C0.743526 7.41548 0.625 7.70163 0.625 8C0.625 8.29837 0.743526 8.58452 0.954505 8.79549C1.16548 9.00647 1.45163 9.125 1.75 9.125ZM11.5 12.875H1.75C1.45163 12.875 1.16548 12.9935 0.954505 13.2045C0.743526 13.4155 0.625 13.7016 0.625 14C0.625 14.2984 0.743526 14.5845 0.954505 14.7955C1.16548 15.0065 1.45163 15.125 1.75 15.125H11.5C11.7984 15.125 12.0845 15.0065 12.2955 14.7955C12.5065 14.5845 12.625 14.2984 12.625 14C12.625 13.7016 12.5065 13.4155 12.2955 13.2045C12.0845 12.9935 11.7984 12.875 11.5 12.875ZM19.75 12.875H18.625V11.75C18.625 11.4516 18.5065 11.1655 18.2955 10.9545C18.0845 10.7435 17.7984 10.625 17.5 10.625C17.2016 10.625 16.9155 10.7435 16.7045 10.9545C16.4935 11.1655 16.375 11.4516 16.375 11.75V12.875H15.25C14.9516 12.875 14.6655 12.9935 14.4545 13.2045C14.2435 13.4155 14.125 13.7016 14.125 14C14.125 14.2984 14.2435 14.5845 14.4545 14.7955C14.6655 15.0065 14.9516 15.125 15.25 15.125H16.375V16.25C16.375 16.5484 16.4935 16.8345 16.7045 17.0455C16.9155 17.2565 17.2016 17.375 17.5 17.375C17.7984 17.375 18.0845 17.2565 18.2955 17.0455C18.5065 16.8345 18.625 16.5484 18.625 16.25V15.125H19.75C20.0484 15.125 20.3345 15.0065 20.5455 14.7955C20.7565 14.5845 20.875 14.2984 20.875 14C20.875 13.7016 20.7565 13.4155 20.5455 13.2045C20.3345 12.9935 20.0484 12.875 19.75 12.875Z" fill="#2D2C2C"/>
          </svg>
          <span>Rearrange Menu Category</span>
        </p>
        <button type="button" class="close-button">
          <img
            src="./assets/icons/close.svg"
            alt="close icon"
            class="close-icon"
          />
        </button>
      </div>
      <div class="modal-body">
        <div class="search-section">
          <div class="search-container" id="main-search">
            <input
              type="text"
              placeholder="Search"
            />
            <svg
              width="20"
              height="20"
              viewBox="0 0 24 24"
              fill="none"
              xmlns="http://www.w3.org/2000/svg"
            >
              <path
                d="M21.7959 20.2041L17.3437 15.75C18.6787 14.0104 19.3019 11.8282 19.087 9.64606C18.8722 7.46389 17.8353 5.44515 16.1867 3.99936C14.5382 2.55356 12.4014 1.78898 10.2098 1.8607C8.01829 1.93243 5.93607 2.83509 4.38558 4.38558C2.83509 5.93607 1.93243 8.01829 1.8607 10.2098C1.78898 12.4014 2.55356 14.5382 3.99936 16.1867C5.44515 17.8353 7.46389 18.8722 9.64606 19.087C11.8282 19.3019 14.0104 18.6787 15.75 17.3437L20.2059 21.8006C20.3106 21.9053 20.4348 21.9883 20.5715 22.0449C20.7083 22.1015 20.8548 22.1307 21.0028 22.1307C21.1508 22.1307 21.2973 22.1015 21.4341 22.0449C21.5708 21.9883 21.695 21.9053 21.7997 21.8006C21.9043 21.696 21.9873 21.5717 22.044 21.435C22.1006 21.2983 22.1298 21.1517 22.1298 21.0037C22.1298 20.8557 22.1006 20.7092 22.044 20.5725C21.9873 20.4357 21.9043 20.3115 21.7997 20.2069L21.7959 20.2041ZM4.12499 10.5C4.12499 9.23914 4.49888 8.0066 5.19938 6.95823C5.89987 5.90987 6.89551 5.09277 8.06039 4.61026C9.22527 4.12775 10.5071 4.00151 11.7437 4.24749C12.9803 4.49347 14.1162 5.10063 15.0078 5.99219C15.8994 6.88375 16.5065 8.01966 16.7525 9.25629C16.9985 10.4929 16.8722 11.7747 16.3897 12.9396C15.9072 14.1045 15.0901 15.1001 14.0418 15.8006C12.9934 16.5011 11.7608 16.875 10.5 16.875C8.80977 16.8733 7.18927 16.201 5.99411 15.0059C4.79894 13.8107 4.12673 12.1902 4.12499 10.5Z"
                fill="currentColor"
                fill-opacity="0.6"
              />
            </svg>
          </div>
          <button class="primary-button" id="confirm-save">
            <span>Save</span>
            <svg width="18" height="17" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M10.5 0.25C8.57164 0.25 6.68657 0.821828 5.08319 1.89317C3.47982 2.96451 2.23013 4.48726 1.49218 6.26884C0.754225 8.05042 0.561142 10.0108 0.937348 11.9021C1.31355 13.7934 2.24215 15.5307 3.60571 16.8943C4.96928 18.2579 6.70656 19.1865 8.59787 19.5627C10.4892 19.9389 12.4496 19.7458 14.2312 19.0078C16.0127 18.2699 17.5355 17.0202 18.6068 15.4168C19.6782 13.8134 20.25 11.9284 20.25 10C20.2473 7.41498 19.2192 4.93661 17.3913 3.10872C15.5634 1.28084 13.085 0.25273 10.5 0.25ZM14.7806 8.28063L9.53063 13.5306C9.46097 13.6004 9.37826 13.6557 9.28721 13.6934C9.19616 13.7312 9.09857 13.7506 9 13.7506C8.90144 13.7506 8.80385 13.7312 8.7128 13.6934C8.62175 13.6557 8.53903 13.6004 8.46938 13.5306L6.21938 11.2806C6.07865 11.1399 5.99959 10.949 5.99959 10.75C5.99959 10.551 6.07865 10.3601 6.21938 10.2194C6.36011 10.0786 6.55098 9.99958 6.75 9.99958C6.94903 9.99958 7.1399 10.0786 7.28063 10.2194L9 11.9397L13.7194 7.21937C13.7891 7.14969 13.8718 7.09442 13.9628 7.0567C14.0539 7.01899 14.1515 6.99958 14.25 6.99958C14.3486 6.99958 14.4461 7.01899 14.5372 7.0567C14.6282 7.09442 14.7109 7.14969 14.7806 7.21937C14.8503 7.28906 14.9056 7.37178 14.9433 7.46283C14.981 7.55387 15.0004 7.65145 15.0004 7.75C15.0004 7.84855 14.981 7.94613 14.9433 8.03717C14.9056 8.12822 14.8503 8.21094 14.7806 8.28063Z" fill="white"/>
            </svg>
          </button>
        </div>
        <ul class="category-list">
          <template id="category-template">
            <li class="draggable-item">
              <div>
                <svg
                  width="16"
                  height="16"
                  viewBox="0 0 18 18"
                  fill="none"
                  xmlns="http://www.w3.org/2000/svg"
                >
                  <path
                    d="M8.25 4.5C8.25 5.24168 8.03007 5.96671 7.61801 6.58339C7.20596 7.20007 6.62029 7.68072 5.93506 7.96455C5.24984 8.24838 4.49584 8.32264 3.76841 8.17795C3.04098 8.03325 2.3728 7.6761 1.84835 7.15165C1.3239 6.6272 0.966751 5.95902 0.822057 5.23159C0.677362 4.50416 0.751625 3.75016 1.03545 3.06494C1.31928 2.37972 1.79993 1.79405 2.41661 1.38199C3.0333 0.969935 3.75832 0.750002 4.5 0.750002C5.49456 0.750002 6.44839 1.14509 7.15165 1.84835C7.85491 2.55161 8.25 3.50544 8.25 4.5ZM13.5 8.25C14.2417 8.25 14.9667 8.03007 15.5834 7.61801C16.2001 7.20596 16.6807 6.62029 16.9646 5.93506C17.2484 5.24984 17.3226 4.49584 17.1779 3.76841C17.0333 3.04098 16.6761 2.3728 16.1517 1.84835C15.6272 1.3239 14.959 0.966751 14.2316 0.822057C13.5042 0.677362 12.7502 0.751625 12.0649 1.03545C11.3797 1.31928 10.794 1.79993 10.382 2.41661C9.96993 3.0333 9.75 3.75832 9.75 4.5C9.75 5.49456 10.1451 6.44839 10.8484 7.15165C11.5516 7.85491 12.5054 8.25 13.5 8.25ZM4.5 9.75C3.75832 9.75 3.0333 9.96993 2.41661 10.382C1.79993 10.794 1.31928 11.3797 1.03545 12.0649C0.751625 12.7502 0.677362 13.5042 0.822057 14.2316C0.966751 14.959 1.3239 15.6272 1.84835 16.1517C2.3728 16.6761 3.04098 17.0333 3.76841 17.1779C4.49584 17.3226 5.24984 17.2484 5.93506 16.9646C6.62029 16.6807 7.20596 16.2001 7.61801 15.5834C8.03007 14.9667 8.25 14.2417 8.25 13.5C8.25 12.5054 7.85491 11.5516 7.15165 10.8484C6.44839 10.1451 5.49456 9.75 4.5 9.75ZM13.5 9.75C12.7583 9.75 12.0333 9.96993 11.4166 10.382C10.7999 10.794 10.3193 11.3797 10.0355 12.0649C9.75162 12.7502 9.67736 13.5042 9.82206 14.2316C9.96675 14.959 10.3239 15.6272 10.8484 16.1517C11.3728 16.6761 12.041 17.0333 12.7684 17.1779C13.4958 17.3226 14.2498 17.2484 14.9351 16.9646C15.6203 16.6807 16.206 16.2001 16.618 15.5834C17.0301 14.9667 17.25 14.2417 17.25 13.5C17.25 12.5054 16.8549 11.5516 16.1517 10.8484C15.4484 10.1451 14.4946 9.75 13.5 9.75Z"
                    fill="#2D2C2C"
                    fill-opacity="0.4"
                  />
                </svg>
                <span></span>
              </div>
              <span></span>
            </li>
          </template>
        </ul>
      </div>
    `;

    main.appendChild(modal);
    modal.showModal();

    const container = modal.querySelector(".category-list");

    // Populate the container with elements
    const template = modal.querySelector("#category-template");

    function populateContainer(data) {
      data.forEach((item) => {
        const clone = template.content.cloneNode(true);
        const nameSpan = clone.querySelector("div span");
        const quantitySpan = clone.querySelector("li > span");

        nameSpan.textContent = item.name;
        quantitySpan.textContent = item.id;

        const listItem = clone.querySelector(".draggable-item");
        listItem.draggable = true;
        listItem.dataset.id = item.id;

        container.appendChild(clone);
      });
    }

    function updateArrayOrder() {
      const newOrder = Array.from(container.children)
        .map((child) => parseInt(child.dataset.id, 10))
        .filter((id) => !isNaN(id));

      const reorderedData = newOrder
        .map((id) => dummyData.find((item) => item.id === id))
        .filter((item) => item !== undefined);

      dummyData.splice(0, dummyData.length, ...reorderedData);
      console.log(dummyData);
    }

    enableDragAndDrop(container, updateArrayOrder);
    populateContainer(dummyData);

    const saveButton = modal.querySelector("#confirm-save");
    saveButton.addEventListener("click", () => {
      createAlert("list updated", "./assets/icons/filled-check.svg", "green-4");
      setTimeout(() => {
        modal.close();
        modal.remove();
        resolve(dummyData);
      }, 800);
    });

    const closeButton = modal.querySelector(".close-button");

    closeButton.addEventListener("click", () => {
      modal.close();
      modal.remove();
      resolve(null);
    });
  });
};

// Rearrange Item Category Modal
const rearrangeItemCategoryModal = (data) => {
  return new Promise((resolve) => {
    const modal = existingModal.cloneNode(true);
    modal.id = "rearrange-item-category-modal";
    modal.classList.add("category-modal", "lined-modal");

    console.log(data);

    let dummyData = data
      ? data
      : [
          { id: 1, name: "Soup", number: "01" },
          { id: 2, name: "Rice", number: "02" },
          { id: 3, name: "Drink", number: "03" },
          { id: 4, name: "Snack", number: "04" },
        ];

    modal.innerHTML = `
      <div class="modal-heading">
        <p>
          <svg width="18" height="15" viewBox="0 0 21 18" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M0.625 2C0.625 1.70163 0.743526 1.41548 0.954505 1.2045C1.16548 0.993526 1.45163 0.875 1.75 0.875H18.25C18.5484 0.875 18.8345 0.993526 19.0455 1.2045C19.2565 1.41548 19.375 1.70163 19.375 2C19.375 2.29837 19.2565 2.58452 19.0455 2.7955C18.8345 3.00647 18.5484 3.125 18.25 3.125H1.75C1.45163 3.125 1.16548 3.00647 0.954505 2.7955C0.743526 2.58452 0.625 2.29837 0.625 2ZM1.75 9.125H18.25C18.5484 9.125 18.8345 9.00647 19.0455 8.79549C19.2565 8.58452 19.375 8.29837 19.375 8C19.375 7.70163 19.2565 7.41548 19.0455 7.2045C18.8345 6.99353 18.5484 6.875 18.25 6.875H1.75C1.45163 6.875 1.16548 6.99353 0.954505 7.2045C0.743526 7.41548 0.625 7.70163 0.625 8C0.625 8.29837 0.743526 8.58452 0.954505 8.79549C1.16548 9.00647 1.45163 9.125 1.75 9.125ZM11.5 12.875H1.75C1.45163 12.875 1.16548 12.9935 0.954505 13.2045C0.743526 13.4155 0.625 13.7016 0.625 14C0.625 14.2984 0.743526 14.5845 0.954505 14.7955C1.16548 15.0065 1.45163 15.125 1.75 15.125H11.5C11.7984 15.125 12.0845 15.0065 12.2955 14.7955C12.5065 14.5845 12.625 14.2984 12.625 14C12.625 13.7016 12.5065 13.4155 12.2955 13.2045C12.0845 12.9935 11.7984 12.875 11.5 12.875ZM19.75 12.875H18.625V11.75C18.625 11.4516 18.5065 11.1655 18.2955 10.9545C18.0845 10.7435 17.7984 10.625 17.5 10.625C17.2016 10.625 16.9155 10.7435 16.7045 10.9545C16.4935 11.1655 16.375 11.4516 16.375 11.75V12.875H15.25C14.9516 12.875 14.6655 12.9935 14.4545 13.2045C14.2435 13.4155 14.125 13.7016 14.125 14C14.125 14.2984 14.2435 14.5845 14.4545 14.7955C14.6655 15.0065 14.9516 15.125 15.25 15.125H16.375V16.25C16.375 16.5484 16.4935 16.8345 16.7045 17.0455C16.9155 17.2565 17.2016 17.375 17.5 17.375C17.7984 17.375 18.0845 17.2565 18.2955 17.0455C18.5065 16.8345 18.625 16.5484 18.625 16.25V15.125H19.75C20.0484 15.125 20.3345 15.0065 20.5455 14.7955C20.7565 14.5845 20.875 14.2984 20.875 14C20.875 13.7016 20.7565 13.4155 20.5455 13.2045C20.3345 12.9935 20.0484 12.875 19.75 12.875Z" fill="#2D2C2C"/>
          </svg>
          <span>Rearrange Item Category</span>
        </p>
        <button type="button" class="close-button">
          <img
            src="./assets/icons/close.svg"
            alt="close icon"
            class="close-icon"
          />
        </button>
      </div>
      <div class="modal-body">
        <div class="search-section">
          <div class="search-container" id="main-search">
            <input
              type="text"
              placeholder="Search"
            />
            <svg
              width="20"
              height="20"
              viewBox="0 0 24 24"
              fill="none"
              xmlns="http://www.w3.org/2000/svg"
            >
              <path
                d="M21.7959 20.2041L17.3437 15.75C18.6787 14.0104 19.3019 11.8282 19.087 9.64606C18.8722 7.46389 17.8353 5.44515 16.1867 3.99936C14.5382 2.55356 12.4014 1.78898 10.2098 1.8607C8.01829 1.93243 5.93607 2.83509 4.38558 4.38558C2.83509 5.93607 1.93243 8.01829 1.8607 10.2098C1.78898 12.4014 2.55356 14.5382 3.99936 16.1867C5.44515 17.8353 7.46389 18.8722 9.64606 19.087C11.8282 19.3019 14.0104 18.6787 15.75 17.3437L20.2059 21.8006C20.3106 21.9053 20.4348 21.9883 20.5715 22.0449C20.7083 22.1015 20.8548 22.1307 21.0028 22.1307C21.1508 22.1307 21.2973 22.1015 21.4341 22.0449C21.5708 21.9883 21.695 21.9053 21.7997 21.8006C21.9043 21.696 21.9873 21.5717 22.044 21.435C22.1006 21.2983 22.1298 21.1517 22.1298 21.0037C22.1298 20.8557 22.1006 20.7092 22.044 20.5725C21.9873 20.4357 21.9043 20.3115 21.7997 20.2069L21.7959 20.2041ZM4.12499 10.5C4.12499 9.23914 4.49888 8.0066 5.19938 6.95823C5.89987 5.90987 6.89551 5.09277 8.06039 4.61026C9.22527 4.12775 10.5071 4.00151 11.7437 4.24749C12.9803 4.49347 14.1162 5.10063 15.0078 5.99219C15.8994 6.88375 16.5065 8.01966 16.7525 9.25629C16.9985 10.4929 16.8722 11.7747 16.3897 12.9396C15.9072 14.1045 15.0901 15.1001 14.0418 15.8006C12.9934 16.5011 11.7608 16.875 10.5 16.875C8.80977 16.8733 7.18927 16.201 5.99411 15.0059C4.79894 13.8107 4.12673 12.1902 4.12499 10.5Z"
                fill="currentColor"
                fill-opacity="0.6"
              />
            </svg>
          </div>
          <button class="primary-button" id="confirm-save">
            <span>Save</span>
            <svg width="18" height="17" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M10.5 0.25C8.57164 0.25 6.68657 0.821828 5.08319 1.89317C3.47982 2.96451 2.23013 4.48726 1.49218 6.26884C0.754225 8.05042 0.561142 10.0108 0.937348 11.9021C1.31355 13.7934 2.24215 15.5307 3.60571 16.8943C4.96928 18.2579 6.70656 19.1865 8.59787 19.5627C10.4892 19.9389 12.4496 19.7458 14.2312 19.0078C16.0127 18.2699 17.5355 17.0202 18.6068 15.4168C19.6782 13.8134 20.25 11.9284 20.25 10C20.2473 7.41498 19.2192 4.93661 17.3913 3.10872C15.5634 1.28084 13.085 0.25273 10.5 0.25ZM14.7806 8.28063L9.53063 13.5306C9.46097 13.6004 9.37826 13.6557 9.28721 13.6934C9.19616 13.7312 9.09857 13.7506 9 13.7506C8.90144 13.7506 8.80385 13.7312 8.7128 13.6934C8.62175 13.6557 8.53903 13.6004 8.46938 13.5306L6.21938 11.2806C6.07865 11.1399 5.99959 10.949 5.99959 10.75C5.99959 10.551 6.07865 10.3601 6.21938 10.2194C6.36011 10.0786 6.55098 9.99958 6.75 9.99958C6.94903 9.99958 7.1399 10.0786 7.28063 10.2194L9 11.9397L13.7194 7.21937C13.7891 7.14969 13.8718 7.09442 13.9628 7.0567C14.0539 7.01899 14.1515 6.99958 14.25 6.99958C14.3486 6.99958 14.4461 7.01899 14.5372 7.0567C14.6282 7.09442 14.7109 7.14969 14.7806 7.21937C14.8503 7.28906 14.9056 7.37178 14.9433 7.46283C14.981 7.55387 15.0004 7.65145 15.0004 7.75C15.0004 7.84855 14.981 7.94613 14.9433 8.03717C14.9056 8.12822 14.8503 8.21094 14.7806 8.28063Z" fill="white"/>
            </svg>
          </button>
        </div>
        <ul class="category-list">
          <template id="category-template">
            <li class="draggable-item">
              <div>
                <svg
                  width="16"
                  height="16"
                  viewBox="0 0 18 18"
                  fill="none"
                  xmlns="http://www.w3.org/2000/svg"
                >
                  <path
                    d="M8.25 4.5C8.25 5.24168 8.03007 5.96671 7.61801 6.58339C7.20596 7.20007 6.62029 7.68072 5.93506 7.96455C5.24984 8.24838 4.49584 8.32264 3.76841 8.17795C3.04098 8.03325 2.3728 7.6761 1.84835 7.15165C1.3239 6.6272 0.966751 5.95902 0.822057 5.23159C0.677362 4.50416 0.751625 3.75016 1.03545 3.06494C1.31928 2.37972 1.79993 1.79405 2.41661 1.38199C3.0333 0.969935 3.75832 0.750002 4.5 0.750002C5.49456 0.750002 6.44839 1.14509 7.15165 1.84835C7.85491 2.55161 8.25 3.50544 8.25 4.5ZM13.5 8.25C14.2417 8.25 14.9667 8.03007 15.5834 7.61801C16.2001 7.20596 16.6807 6.62029 16.9646 5.93506C17.2484 5.24984 17.3226 4.49584 17.1779 3.76841C17.0333 3.04098 16.6761 2.3728 16.1517 1.84835C15.6272 1.3239 14.959 0.966751 14.2316 0.822057C13.5042 0.677362 12.7502 0.751625 12.0649 1.03545C11.3797 1.31928 10.794 1.79993 10.382 2.41661C9.96993 3.0333 9.75 3.75832 9.75 4.5C9.75 5.49456 10.1451 6.44839 10.8484 7.15165C11.5516 7.85491 12.5054 8.25 13.5 8.25ZM4.5 9.75C3.75832 9.75 3.0333 9.96993 2.41661 10.382C1.79993 10.794 1.31928 11.3797 1.03545 12.0649C0.751625 12.7502 0.677362 13.5042 0.822057 14.2316C0.966751 14.959 1.3239 15.6272 1.84835 16.1517C2.3728 16.6761 3.04098 17.0333 3.76841 17.1779C4.49584 17.3226 5.24984 17.2484 5.93506 16.9646C6.62029 16.6807 7.20596 16.2001 7.61801 15.5834C8.03007 14.9667 8.25 14.2417 8.25 13.5C8.25 12.5054 7.85491 11.5516 7.15165 10.8484C6.44839 10.1451 5.49456 9.75 4.5 9.75ZM13.5 9.75C12.7583 9.75 12.0333 9.96993 11.4166 10.382C10.7999 10.794 10.3193 11.3797 10.0355 12.0649C9.75162 12.7502 9.67736 13.5042 9.82206 14.2316C9.96675 14.959 10.3239 15.6272 10.8484 16.1517C11.3728 16.6761 12.041 17.0333 12.7684 17.1779C13.4958 17.3226 14.2498 17.2484 14.9351 16.9646C15.6203 16.6807 16.206 16.2001 16.618 15.5834C17.0301 14.9667 17.25 14.2417 17.25 13.5C17.25 12.5054 16.8549 11.5516 16.1517 10.8484C15.4484 10.1451 14.4946 9.75 13.5 9.75Z"
                    fill="#2D2C2C"
                    fill-opacity="0.4"
                  />
                </svg>
                <span></span>
              </div>
              <span></span>
            </li>
          </template>
        </ul>
      </div>
    `;

    main.appendChild(modal);
    modal.showModal();

    const container = modal.querySelector(".category-list");

    // Populate the container with elements
    const template = modal.querySelector("#category-template");

    function populateContainer(data) {
      data.forEach((item) => {
        const clone = template.content.cloneNode(true);
        const nameSpan = clone.querySelector("div span");

        nameSpan.textContent = item.name;

        const listItem = clone.querySelector(".draggable-item");
        listItem.draggable = true;
        listItem.dataset.id = item.id;

        container.appendChild(clone);
      });
    }

    function updateArrayOrder() {
      const children = Array.from(container.children);

      const newOrder = children
        .map((child) => parseInt(child.dataset.id, 10))
        .filter((id) => !isNaN(id));

      const reorderedData = newOrder
        .map((id) => dummyData.find((item) => item.id == id))
        .filter((item) => item !== undefined);

      dummyData.splice(0, dummyData.length, ...reorderedData);
    }

    enableDragAndDrop(container, updateArrayOrder);
    populateContainer(dummyData);

    const saveButton = modal.querySelector("#confirm-save");
    saveButton.addEventListener("click", () => {
      createAlert("list updated", "./assets/icons/filled-check.svg", "green-4");
      setTimeout(() => {
        modal.close();
        modal.remove();
        resolve(dummyData);
      }, 800);
    });

    const closeButton = modal.querySelector(".close-button");

    closeButton.addEventListener("click", () => {
      modal.close();
      modal.remove();
      resolve(null);
    });
  });
};

// Rearrange Items Modal
const rearrangeItemsModal = (title, data) => {
  return new Promise((resolve) => {
    const modal = existingModal.cloneNode(true);
    modal.id = "rearrange-item-modal";
    modal.classList.add("category-modal", "lined-modal");

    const dummyData = data
      ? data
      : [
          { id: 1, name: "Soup", number: "01" },
          { id: 2, name: "Rice", number: "02" },
          { id: 3, name: "Drink", number: "03" },
          { id: 4, name: "Snack", number: "04" },
        ];

    modal.innerHTML = `
          <div class="modal-heading">
            <p>
              <svg width="18" height="15" viewBox="0 0 21 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M0.625 2C0.625 1.70163 0.743526 1.41548 0.954505 1.2045C1.16548 0.993526 1.45163 0.875 1.75 0.875H18.25C18.5484 0.875 18.8345 0.993526 19.0455 1.2045C19.2565 1.41548 19.375 1.70163 19.375 2C19.375 2.29837 19.2565 2.58452 19.0455 2.7955C18.8345 3.00647 18.5484 3.125 18.25 3.125H1.75C1.45163 3.125 1.16548 3.00647 0.954505 2.7955C0.743526 2.58452 0.625 2.29837 0.625 2ZM1.75 9.125H18.25C18.5484 9.125 18.8345 9.00647 19.0455 8.79549C19.2565 8.58452 19.375 8.29837 19.375 8C19.375 7.70163 19.2565 7.41548 19.0455 7.2045C18.8345 6.99353 18.5484 6.875 18.25 6.875H1.75C1.45163 6.875 1.16548 6.99353 0.954505 7.2045C0.743526 7.41548 0.625 7.70163 0.625 8C0.625 8.29837 0.743526 8.58452 0.954505 8.79549C1.16548 9.00647 1.45163 9.125 1.75 9.125ZM11.5 12.875H1.75C1.45163 12.875 1.16548 12.9935 0.954505 13.2045C0.743526 13.4155 0.625 13.7016 0.625 14C0.625 14.2984 0.743526 14.5845 0.954505 14.7955C1.16548 15.0065 1.45163 15.125 1.75 15.125H11.5C11.7984 15.125 12.0845 15.0065 12.2955 14.7955C12.5065 14.5845 12.625 14.2984 12.625 14C12.625 13.7016 12.5065 13.4155 12.2955 13.2045C12.0845 12.9935 11.7984 12.875 11.5 12.875ZM19.75 12.875H18.625V11.75C18.625 11.4516 18.5065 11.1655 18.2955 10.9545C18.0845 10.7435 17.7984 10.625 17.5 10.625C17.2016 10.625 16.9155 10.7435 16.7045 10.9545C16.4935 11.1655 16.375 11.4516 16.375 11.75V12.875H15.25C14.9516 12.875 14.6655 12.9935 14.4545 13.2045C14.2435 13.4155 14.125 13.7016 14.125 14C14.125 14.2984 14.2435 14.5845 14.4545 14.7955C14.6655 15.0065 14.9516 15.125 15.25 15.125H16.375V16.25C16.375 16.5484 16.4935 16.8345 16.7045 17.0455C16.9155 17.2565 17.2016 17.375 17.5 17.375C17.7984 17.375 18.0845 17.2565 18.2955 17.0455C18.5065 16.8345 18.625 16.5484 18.625 16.25V15.125H19.75C20.0484 15.125 20.3345 15.0065 20.5455 14.7955C20.7565 14.5845 20.875 14.2984 20.875 14C20.875 13.7016 20.7565 13.4155 20.5455 13.2045C20.3345 12.9935 20.0484 12.875 19.75 12.875Z" fill="#2D2C2C"/>
              </svg>
              <span>Rearrange Items</span>
            </p>
            <button type="button" class="close-button">
              <img
                src="./assets/icons/close.svg"
                alt="close icon"
                class="close-icon"
              />
            </button>
          </div>
          <div class="modal-body">
            <div class="category-header-section">
              <svg 
                width="16"
                height="16"
                viewBox="0 0 18 18"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  d="M8.25 4.5C8.25 5.24168 8.03007 5.96671 7.61801 6.58339C7.20596 7.20007 6.62029 7.68072 5.93506 7.96455C5.24984 8.24838 4.49584 8.32264 3.76841 8.17795C3.04098 8.03325 2.3728 7.6761 1.84835 7.15165C1.3239 6.6272 0.966751 5.95902 0.822057 5.23159C0.677362 4.50416 0.751625 3.75016 1.03545 3.06494C1.31928 2.37972 1.79993 1.79405 2.41661 1.38199C3.0333 0.969935 3.75832 0.750002 4.5 0.750002C5.49456 0.750002 6.44839 1.14509 7.15165 1.84835C7.85491 2.55161 8.25 3.50544 8.25 4.5ZM13.5 8.25C14.2417 8.25 14.9667 8.03007 15.5834 7.61801C16.2001 7.20596 16.6807 6.62029 16.9646 5.93506C17.2484 5.24984 17.3226 4.49584 17.1779 3.76841C17.0333 3.04098 16.6761 2.3728 16.1517 1.84835C15.6272 1.3239 14.959 0.966751 14.2316 0.822057C13.5042 0.677362 12.7502 0.751625 12.0649 1.03545C11.3797 1.31928 10.794 1.79993 10.382 2.41661C9.96993 3.0333 9.75 3.75832 9.75 4.5C9.75 5.49456 10.1451 6.44839 10.8484 7.15165C11.5516 7.85491 12.5054 8.25 13.5 8.25ZM4.5 9.75C3.75832 9.75 3.0333 9.96993 2.41661 10.382C1.79993 10.794 1.31928 11.3797 1.03545 12.0649C0.751625 12.7502 0.677362 13.5042 0.822057 14.2316C0.966751 14.959 1.3239 15.6272 1.84835 16.1517C2.3728 16.6761 3.04098 17.0333 3.76841 17.1779C4.49584 17.3226 5.24984 17.2484 5.93506 16.9646C6.62029 16.6807 7.20596 16.2001 7.61801 15.5834C8.03007 14.9667 8.25 14.2417 8.25 13.5C8.25 12.5054 7.85491 11.5516 7.15165 10.8484C6.44839 10.1451 5.49456 9.75 4.5 9.75ZM13.5 9.75C12.7583 9.75 12.0333 9.96993 11.4166 10.382C10.7999 10.794 10.3193 11.3797 10.0355 12.0649C9.75162 12.7502 9.67736 13.5042 9.82206 14.2316C9.96675 14.959 10.3239 15.6272 10.8484 16.1517C11.3728 16.6761 12.041 17.0333 12.7684 17.1779C13.4958 17.3226 14.2498 17.2484 14.9351 16.9646C15.6203 16.6807 16.206 16.2001 16.618 15.5834C17.0301 14.9667 17.25 14.2417 17.25 13.5C17.25 12.5054 16.8549 11.5516 16.1517 10.8484C15.4484 10.1451 14.4946 9.75 13.5 9.75Z"
                  fill="#2D2C2C"
                  fill-opacity="0.4"
                />
              </svg>
              <span>${title}</span>
            </div>
            <div class="search-section">
              <div class="search-container" id="main-search">
                <input
                  type="text"
                  placeholder="Search"
                />
                <svg
                  width="20"
                  height="20"
                  viewBox="0 0 24 24"
                  fill="none"
                  xmlns="http://www.w3.org/2000/svg"
                >
                  <path
                    d="M21.7959 20.2041L17.3437 15.75C18.6787 14.0104 19.3019 11.8282 19.087 9.64606C18.8722 7.46389 17.8353 5.44515 16.1867 3.99936C14.5382 2.55356 12.4014 1.78898 10.2098 1.8607C8.01829 1.93243 5.93607 2.83509 4.38558 4.38558C2.83509 5.93607 1.93243 8.01829 1.8607 10.2098C1.78898 12.4014 2.55356 14.5382 3.99936 16.1867C5.44515 17.8353 7.46389 18.8722 9.64606 19.087C11.8282 19.3019 14.0104 18.6787 15.75 17.3437L20.2059 21.8006C20.3106 21.9053 20.4348 21.9883 20.5715 22.0449C20.7083 22.1015 20.8548 22.1307 21.0028 22.1307C21.1508 22.1307 21.2973 22.1015 21.4341 22.0449C21.5708 21.9883 21.695 21.9053 21.7997 21.8006C21.9043 21.696 21.9873 21.5717 22.044 21.435C22.1006 21.2983 22.1298 21.1517 22.1298 21.0037C22.1298 20.8557 22.1006 20.7092 22.044 20.5725C21.9873 20.4357 21.9043 20.3115 21.7997 20.2069L21.7959 20.2041ZM4.12499 10.5C4.12499 9.23914 4.49888 8.0066 5.19938 6.95823C5.89987 5.90987 6.89551 5.09277 8.06039 4.61026C9.22527 4.12775 10.5071 4.00151 11.7437 4.24749C12.9803 4.49347 14.1162 5.10063 15.0078 5.99219C15.8994 6.88375 16.5065 8.01966 16.7525 9.25629C16.9985 10.4929 16.8722 11.7747 16.3897 12.9396C15.9072 14.1045 15.0901 15.1001 14.0418 15.8006C12.9934 16.5011 11.7608 16.875 10.5 16.875C8.80977 16.8733 7.18927 16.201 5.99411 15.0059C4.79894 13.8107 4.12673 12.1902 4.12499 10.5Z"
                    fill="currentColor"
                    fill-opacity="0.6"
                  />
                </svg>
              </div>
              <button class="primary-button" id="confirm-save">
                <span>Save</span>
                <svg width="18" height="17" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M10.5 0.25C8.57164 0.25 6.68657 0.821828 5.08319 1.89317C3.47982 2.96451 2.23013 4.48726 1.49218 6.26884C0.754225 8.05042 0.561142 10.0108 0.937348 11.9021C1.31355 13.7934 2.24215 15.5307 3.60571 16.8943C4.96928 18.2579 6.70656 19.1865 8.59787 19.5627C10.4892 19.9389 12.4496 19.7458 14.2312 19.0078C16.0127 18.2699 17.5355 17.0202 18.6068 15.4168C19.6782 13.8134 20.25 11.9284 20.25 10C20.2473 7.41498 19.2192 4.93661 17.3913 3.10872C15.5634 1.28084 13.085 0.25273 10.5 0.25ZM14.7806 8.28063L9.53063 13.5306C9.46097 13.6004 9.37826 13.6557 9.28721 13.6934C9.19616 13.7312 9.09857 13.7506 9 13.7506C8.90144 13.7506 8.80385 13.7312 8.7128 13.6934C8.62175 13.6557 8.53903 13.6004 8.46938 13.5306L6.21938 11.2806C6.07865 11.1399 5.99959 10.949 5.99959 10.75C5.99959 10.551 6.07865 10.3601 6.21938 10.2194C6.36011 10.0786 6.55098 9.99958 6.75 9.99958C6.94903 9.99958 7.1399 10.0786 7.28063 10.2194L9 11.9397L13.7194 7.21937C13.7891 7.14969 13.8718 7.09442 13.9628 7.0567C14.0539 7.01899 14.1515 6.99958 14.25 6.99958C14.3486 6.99958 14.4461 7.01899 14.5372 7.0567C14.6282 7.09442 14.7109 7.14969 14.7806 7.21937C14.8503 7.28906 14.9056 7.37178 14.9433 7.46283C14.981 7.55387 15.0004 7.65145 15.0004 7.75C15.0004 7.84855 14.981 7.94613 14.9433 8.03717C14.9056 8.12822 14.8503 8.21094 14.7806 8.28063Z" fill="white"/>
                </svg>
              </button>
            </div>
            <ul class="item-list">
              <template id="item-template">
                <li class="draggable-item">
                  <div>
                    <svg width="20" height="19" viewBox="0 0 20 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M19 7.75012H18.2153C18.0269 5.70157 17.0799 3.79733 15.56 2.41089C14.0402 1.02445 12.0572 0.255859 10 0.255859C7.94279 0.255859 5.95981 1.02445 4.43998 2.41089C2.92015 3.79733 1.97314 5.70157 1.78469 7.75012H1C0.801088 7.75012 0.610322 7.82914 0.46967 7.96979C0.329018 8.11044 0.25 8.30121 0.25 8.50012C0.253295 10.2837 0.744149 12.0325 1.66948 13.5573C2.59481 15.0821 3.9194 16.3249 5.5 17.1514V17.5001C5.5 17.8979 5.65804 18.2795 5.93934 18.5608C6.22064 18.8421 6.60218 19.0001 7 19.0001H13C13.3978 19.0001 13.7794 18.8421 14.0607 18.5608C14.342 18.2795 14.5 17.8979 14.5 17.5001V17.1514C16.0806 16.3249 17.4052 15.0821 18.3305 13.5573C19.2558 12.0325 19.7467 10.2837 19.75 8.50012C19.75 8.30121 19.671 8.11044 19.5303 7.96979C19.3897 7.82914 19.1989 7.75012 19 7.75012ZM14.2638 3.27168C14.4356 3.41231 14.6003 3.56075 14.7578 3.717C12.7613 4.41933 11.1114 5.86275 10.15 7.74825H7.38437C7.85313 6.43427 8.71613 5.29706 9.85547 4.49198C10.9948 3.68689 12.3549 3.25319 13.75 3.25012C13.9216 3.25012 14.0931 3.25856 14.2638 3.27168ZM11.8862 7.75012C12.7955 6.38595 14.1712 5.40029 15.7553 4.97793C16.2733 5.82042 16.5982 6.76714 16.7069 7.75012H11.8862ZM10 1.75012C10.6018 1.75052 11.2009 1.83155 11.7812 1.99106C10.3679 2.34166 9.07195 3.05863 8.02401 4.0697C6.97606 5.08078 6.21316 6.35023 5.81219 7.75012H3.29312C3.47917 6.10093 4.26562 4.57787 5.50254 3.47132C6.73946 2.36476 8.34035 1.75209 10 1.75012Z" fill="#2D2C2C" fill-opacity="0.4"/>
                    </svg>
                    <span></span>
                  </div>
                  <span></span>
                </li>
              </template>
            </ul>
          </div>
        `;

    main.appendChild(modal);
    modal.showModal();

    const container = document.querySelector(".item-list");

    // Populate the container with elements
    const template = document.getElementById("item-template");

    function populateContainer(data) {
      data.forEach((item) => {
        const clone = template.content.cloneNode(true);
        const nameSpan = clone.querySelector("div span");
        const quantitySpan = clone.querySelector("li > span");

        nameSpan.textContent = item.name;
        quantitySpan.textContent = item.id;

        const listItem = clone.querySelector(".draggable-item");
        listItem.draggable = true;
        listItem.dataset.id = item.id;

        container.appendChild(clone);
      });
    }

    // Reorder callback to update the array
    function updateArrayOrder() {
      const newOrder = Array.from(container.children)
        .map((child) => parseInt(child.dataset.id, 10))
        .filter((id) => !isNaN(id));

      const reorderedData = newOrder
        .map((id) => dummyData.find((item) => item.id == id))
        .filter((item) => item !== undefined);

      console.log("Reordered Data:", reorderedData);

      dummyData.splice(0, dummyData.length, ...reorderedData);
      console.log("Updated Data Order:", dummyData);
    }

    enableDragAndDrop(container, updateArrayOrder);
    populateContainer(dummyData);

    const saveButton = modal.querySelector("#confirm-save");
    saveButton.addEventListener("click", () => {
      createAlert("list updated", "./assets/icons/filled-check.svg", "green-4");
      setTimeout(() => {
        modal.close();
        modal.remove();
        resolve(dummyData);
      }, 800);
    });

    const closeButton = modal.querySelector(".close-button");

    closeButton.addEventListener("click", () => {
      modal.close();
      modal.remove();
      resolve(null);
    });
  });
};

// rearrange Dish Modals
const rearrangeDishesModal = (title, data) => {
  return new Promise((resolve) => {
    const modal = existingModal.cloneNode(true);
    modal.id = "rearrange-dishes-modal";
    modal.classList.add("category-modal", "lined-modal");

    const dummyData = data
      ? data
      : [
          { id: 1, name: "Soup", number: "01" },
          { id: 2, name: "Rice", number: "02" },
          { id: 3, name: "Drink", number: "03" },
          { id: 4, name: "Snack", number: "04" },
        ];

    modal.innerHTML = `
          <div class="modal-heading">
            <p>
              <svg width="18" height="15" viewBox="0 0 21 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M0.625 2C0.625 1.70163 0.743526 1.41548 0.954505 1.2045C1.16548 0.993526 1.45163 0.875 1.75 0.875H18.25C18.5484 0.875 18.8345 0.993526 19.0455 1.2045C19.2565 1.41548 19.375 1.70163 19.375 2C19.375 2.29837 19.2565 2.58452 19.0455 2.7955C18.8345 3.00647 18.5484 3.125 18.25 3.125H1.75C1.45163 3.125 1.16548 3.00647 0.954505 2.7955C0.743526 2.58452 0.625 2.29837 0.625 2ZM1.75 9.125H18.25C18.5484 9.125 18.8345 9.00647 19.0455 8.79549C19.2565 8.58452 19.375 8.29837 19.375 8C19.375 7.70163 19.2565 7.41548 19.0455 7.2045C18.8345 6.99353 18.5484 6.875 18.25 6.875H1.75C1.45163 6.875 1.16548 6.99353 0.954505 7.2045C0.743526 7.41548 0.625 7.70163 0.625 8C0.625 8.29837 0.743526 8.58452 0.954505 8.79549C1.16548 9.00647 1.45163 9.125 1.75 9.125ZM11.5 12.875H1.75C1.45163 12.875 1.16548 12.9935 0.954505 13.2045C0.743526 13.4155 0.625 13.7016 0.625 14C0.625 14.2984 0.743526 14.5845 0.954505 14.7955C1.16548 15.0065 1.45163 15.125 1.75 15.125H11.5C11.7984 15.125 12.0845 15.0065 12.2955 14.7955C12.5065 14.5845 12.625 14.2984 12.625 14C12.625 13.7016 12.5065 13.4155 12.2955 13.2045C12.0845 12.9935 11.7984 12.875 11.5 12.875ZM19.75 12.875H18.625V11.75C18.625 11.4516 18.5065 11.1655 18.2955 10.9545C18.0845 10.7435 17.7984 10.625 17.5 10.625C17.2016 10.625 16.9155 10.7435 16.7045 10.9545C16.4935 11.1655 16.375 11.4516 16.375 11.75V12.875H15.25C14.9516 12.875 14.6655 12.9935 14.4545 13.2045C14.2435 13.4155 14.125 13.7016 14.125 14C14.125 14.2984 14.2435 14.5845 14.4545 14.7955C14.6655 15.0065 14.9516 15.125 15.25 15.125H16.375V16.25C16.375 16.5484 16.4935 16.8345 16.7045 17.0455C16.9155 17.2565 17.2016 17.375 17.5 17.375C17.7984 17.375 18.0845 17.2565 18.2955 17.0455C18.5065 16.8345 18.625 16.5484 18.625 16.25V15.125H19.75C20.0484 15.125 20.3345 15.0065 20.5455 14.7955C20.7565 14.5845 20.875 14.2984 20.875 14C20.875 13.7016 20.7565 13.4155 20.5455 13.2045C20.3345 12.9935 20.0484 12.875 19.75 12.875Z" fill="#2D2C2C"/>
              </svg>
              <span>Rearrange Dishes</span>
            </p>
            <button type="button" class="close-button">
              <img
                src="./assets/icons/close.svg"
                alt="close icon"
                class="close-icon"
              />
            </button>
          </div>
          <div class="modal-body">
            <div class="category-header-section">
              <svg 
                width="16"
                height="16"
                viewBox="0 0 18 18"
                fill="none"
                xmlns="http://www.w3.org/2000/svg"
              >
                <path
                  d="M8.25 4.5C8.25 5.24168 8.03007 5.96671 7.61801 6.58339C7.20596 7.20007 6.62029 7.68072 5.93506 7.96455C5.24984 8.24838 4.49584 8.32264 3.76841 8.17795C3.04098 8.03325 2.3728 7.6761 1.84835 7.15165C1.3239 6.6272 0.966751 5.95902 0.822057 5.23159C0.677362 4.50416 0.751625 3.75016 1.03545 3.06494C1.31928 2.37972 1.79993 1.79405 2.41661 1.38199C3.0333 0.969935 3.75832 0.750002 4.5 0.750002C5.49456 0.750002 6.44839 1.14509 7.15165 1.84835C7.85491 2.55161 8.25 3.50544 8.25 4.5ZM13.5 8.25C14.2417 8.25 14.9667 8.03007 15.5834 7.61801C16.2001 7.20596 16.6807 6.62029 16.9646 5.93506C17.2484 5.24984 17.3226 4.49584 17.1779 3.76841C17.0333 3.04098 16.6761 2.3728 16.1517 1.84835C15.6272 1.3239 14.959 0.966751 14.2316 0.822057C13.5042 0.677362 12.7502 0.751625 12.0649 1.03545C11.3797 1.31928 10.794 1.79993 10.382 2.41661C9.96993 3.0333 9.75 3.75832 9.75 4.5C9.75 5.49456 10.1451 6.44839 10.8484 7.15165C11.5516 7.85491 12.5054 8.25 13.5 8.25ZM4.5 9.75C3.75832 9.75 3.0333 9.96993 2.41661 10.382C1.79993 10.794 1.31928 11.3797 1.03545 12.0649C0.751625 12.7502 0.677362 13.5042 0.822057 14.2316C0.966751 14.959 1.3239 15.6272 1.84835 16.1517C2.3728 16.6761 3.04098 17.0333 3.76841 17.1779C4.49584 17.3226 5.24984 17.2484 5.93506 16.9646C6.62029 16.6807 7.20596 16.2001 7.61801 15.5834C8.03007 14.9667 8.25 14.2417 8.25 13.5C8.25 12.5054 7.85491 11.5516 7.15165 10.8484C6.44839 10.1451 5.49456 9.75 4.5 9.75ZM13.5 9.75C12.7583 9.75 12.0333 9.96993 11.4166 10.382C10.7999 10.794 10.3193 11.3797 10.0355 12.0649C9.75162 12.7502 9.67736 13.5042 9.82206 14.2316C9.96675 14.959 10.3239 15.6272 10.8484 16.1517C11.3728 16.6761 12.041 17.0333 12.7684 17.1779C13.4958 17.3226 14.2498 17.2484 14.9351 16.9646C15.6203 16.6807 16.206 16.2001 16.618 15.5834C17.0301 14.9667 17.25 14.2417 17.25 13.5C17.25 12.5054 16.8549 11.5516 16.1517 10.8484C15.4484 10.1451 14.4946 9.75 13.5 9.75Z"
                  fill="#2D2C2C"
                  fill-opacity="0.4"
                />
              </svg>
              <span>${title}</span>
            </div>
            <div class="search-section">
              <div class="search-container" id="main-search">
                <input
                  type="text"
                  placeholder="Search"
                />
                <svg
                  width="20"
                  height="20"
                  viewBox="0 0 24 24"
                  fill="none"
                  xmlns="http://www.w3.org/2000/svg"
                >
                  <path
                    d="M21.7959 20.2041L17.3437 15.75C18.6787 14.0104 19.3019 11.8282 19.087 9.64606C18.8722 7.46389 17.8353 5.44515 16.1867 3.99936C14.5382 2.55356 12.4014 1.78898 10.2098 1.8607C8.01829 1.93243 5.93607 2.83509 4.38558 4.38558C2.83509 5.93607 1.93243 8.01829 1.8607 10.2098C1.78898 12.4014 2.55356 14.5382 3.99936 16.1867C5.44515 17.8353 7.46389 18.8722 9.64606 19.087C11.8282 19.3019 14.0104 18.6787 15.75 17.3437L20.2059 21.8006C20.3106 21.9053 20.4348 21.9883 20.5715 22.0449C20.7083 22.1015 20.8548 22.1307 21.0028 22.1307C21.1508 22.1307 21.2973 22.1015 21.4341 22.0449C21.5708 21.9883 21.695 21.9053 21.7997 21.8006C21.9043 21.696 21.9873 21.5717 22.044 21.435C22.1006 21.2983 22.1298 21.1517 22.1298 21.0037C22.1298 20.8557 22.1006 20.7092 22.044 20.5725C21.9873 20.4357 21.9043 20.3115 21.7997 20.2069L21.7959 20.2041ZM4.12499 10.5C4.12499 9.23914 4.49888 8.0066 5.19938 6.95823C5.89987 5.90987 6.89551 5.09277 8.06039 4.61026C9.22527 4.12775 10.5071 4.00151 11.7437 4.24749C12.9803 4.49347 14.1162 5.10063 15.0078 5.99219C15.8994 6.88375 16.5065 8.01966 16.7525 9.25629C16.9985 10.4929 16.8722 11.7747 16.3897 12.9396C15.9072 14.1045 15.0901 15.1001 14.0418 15.8006C12.9934 16.5011 11.7608 16.875 10.5 16.875C8.80977 16.8733 7.18927 16.201 5.99411 15.0059C4.79894 13.8107 4.12673 12.1902 4.12499 10.5Z"
                    fill="currentColor"
                    fill-opacity="0.6"
                  />
                </svg>
              </div>
              <button class="primary-button" id="confirm-save">
                <span>Save</span>
                <svg width="18" height="17" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M10.5 0.25C8.57164 0.25 6.68657 0.821828 5.08319 1.89317C3.47982 2.96451 2.23013 4.48726 1.49218 6.26884C0.754225 8.05042 0.561142 10.0108 0.937348 11.9021C1.31355 13.7934 2.24215 15.5307 3.60571 16.8943C4.96928 18.2579 6.70656 19.1865 8.59787 19.5627C10.4892 19.9389 12.4496 19.7458 14.2312 19.0078C16.0127 18.2699 17.5355 17.0202 18.6068 15.4168C19.6782 13.8134 20.25 11.9284 20.25 10C20.2473 7.41498 19.2192 4.93661 17.3913 3.10872C15.5634 1.28084 13.085 0.25273 10.5 0.25ZM14.7806 8.28063L9.53063 13.5306C9.46097 13.6004 9.37826 13.6557 9.28721 13.6934C9.19616 13.7312 9.09857 13.7506 9 13.7506C8.90144 13.7506 8.80385 13.7312 8.7128 13.6934C8.62175 13.6557 8.53903 13.6004 8.46938 13.5306L6.21938 11.2806C6.07865 11.1399 5.99959 10.949 5.99959 10.75C5.99959 10.551 6.07865 10.3601 6.21938 10.2194C6.36011 10.0786 6.55098 9.99958 6.75 9.99958C6.94903 9.99958 7.1399 10.0786 7.28063 10.2194L9 11.9397L13.7194 7.21937C13.7891 7.14969 13.8718 7.09442 13.9628 7.0567C14.0539 7.01899 14.1515 6.99958 14.25 6.99958C14.3486 6.99958 14.4461 7.01899 14.5372 7.0567C14.6282 7.09442 14.7109 7.14969 14.7806 7.21937C14.8503 7.28906 14.9056 7.37178 14.9433 7.46283C14.981 7.55387 15.0004 7.65145 15.0004 7.75C15.0004 7.84855 14.981 7.94613 14.9433 8.03717C14.9056 8.12822 14.8503 8.21094 14.7806 8.28063Z" fill="white"/>
                </svg>
              </button>
            </div>
            <ul class="item-list">
              <template id="item-template">
                <li class="draggable-item">
                  <div>
                    <svg width="20" height="19" viewBox="0 0 20 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M19 7.75012H18.2153C18.0269 5.70157 17.0799 3.79733 15.56 2.41089C14.0402 1.02445 12.0572 0.255859 10 0.255859C7.94279 0.255859 5.95981 1.02445 4.43998 2.41089C2.92015 3.79733 1.97314 5.70157 1.78469 7.75012H1C0.801088 7.75012 0.610322 7.82914 0.46967 7.96979C0.329018 8.11044 0.25 8.30121 0.25 8.50012C0.253295 10.2837 0.744149 12.0325 1.66948 13.5573C2.59481 15.0821 3.9194 16.3249 5.5 17.1514V17.5001C5.5 17.8979 5.65804 18.2795 5.93934 18.5608C6.22064 18.8421 6.60218 19.0001 7 19.0001H13C13.3978 19.0001 13.7794 18.8421 14.0607 18.5608C14.342 18.2795 14.5 17.8979 14.5 17.5001V17.1514C16.0806 16.3249 17.4052 15.0821 18.3305 13.5573C19.2558 12.0325 19.7467 10.2837 19.75 8.50012C19.75 8.30121 19.671 8.11044 19.5303 7.96979C19.3897 7.82914 19.1989 7.75012 19 7.75012ZM14.2638 3.27168C14.4356 3.41231 14.6003 3.56075 14.7578 3.717C12.7613 4.41933 11.1114 5.86275 10.15 7.74825H7.38437C7.85313 6.43427 8.71613 5.29706 9.85547 4.49198C10.9948 3.68689 12.3549 3.25319 13.75 3.25012C13.9216 3.25012 14.0931 3.25856 14.2638 3.27168ZM11.8862 7.75012C12.7955 6.38595 14.1712 5.40029 15.7553 4.97793C16.2733 5.82042 16.5982 6.76714 16.7069 7.75012H11.8862ZM10 1.75012C10.6018 1.75052 11.2009 1.83155 11.7812 1.99106C10.3679 2.34166 9.07195 3.05863 8.02401 4.0697C6.97606 5.08078 6.21316 6.35023 5.81219 7.75012H3.29312C3.47917 6.10093 4.26562 4.57787 5.50254 3.47132C6.73946 2.36476 8.34035 1.75209 10 1.75012Z" fill="#2D2C2C" fill-opacity="0.4"/>
                    </svg>
                    <span></span>
                  </div>
                  <span></span>
                </li>
              </template>
            </ul>
          </div>
        `;

    main.appendChild(modal);
    modal.showModal();

    const container = document.querySelector(".item-list");

    // Populate the container with elements
    const template = document.getElementById("item-template");

    function populateContainer(data) {
      data.forEach((item) => {
        const clone = template.content.cloneNode(true);
        const nameSpan = clone.querySelector("div span");
        const quantitySpan = clone.querySelector("li > span");

        nameSpan.textContent = item.name;
        quantitySpan.textContent = item.id;

        const listItem = clone.querySelector(".draggable-item");
        listItem.draggable = true;
        listItem.dataset.id = item.id;

        container.appendChild(clone);
      });
    }

    // Reorder callback to update the array
    function updateArrayOrder() {
      const newOrder = Array.from(container.children)
        .map((child) => parseInt(child.dataset.id, 10))
        .filter((id) => !isNaN(id));

      const reorderedData = newOrder
        .map((id) => dummyData.find((item) => item.id == id))
        .filter((item) => item !== undefined);

      dummyData.splice(0, dummyData.length, ...reorderedData);
    }

    enableDragAndDrop(container, updateArrayOrder);
    populateContainer(dummyData);

    const saveButton = modal.querySelector("#confirm-save");
    saveButton.addEventListener("click", () => {
      createAlert("list updated", "./assets/icons/filled-check.svg", "green-4");
      setTimeout(() => {
        modal.close();
        modal.remove();
        resolve(dummyData);
      }, 800);
    });

    const closeButton = modal.querySelector(".close-button");

    closeButton.addEventListener("click", () => {
      modal.close();
      modal.remove();
      resolve(null);
    });
  });
};

// Drag and drop functionality
function enableDragAndDrop(container, onReorderCallback) {
  let draggedElement = null;

  container.addEventListener("dragstart", (event) => {
    if (event.target.classList.contains("draggable-item")) {
      draggedElement = event.target;
      draggedElement.classList.add("dragging");
    }
  });

  container.addEventListener("dragover", (event) => {
    event.preventDefault();
    const afterElement = getDragAfterElement(container, event.clientY);
    if (afterElement == null) {
      container.appendChild(draggedElement);
    } else {
      container.insertBefore(draggedElement, afterElement);
    }
  });

  container.addEventListener("dragend", () => {
    if (draggedElement) {
      draggedElement.classList.remove("dragging");
      draggedElement = null;
      if (typeof onReorderCallback === "function") {
        onReorderCallback();
      }
    }
  });

  function getDragAfterElement(container, y) {
    const draggableElements = [
      ...container.querySelectorAll(".draggable-item:not(.dragging)"),
    ];

    return draggableElements.reduce(
      (closest, child) => {
        const box = child.getBoundingClientRect();
        const offset = y - box.top - box.height / 2;
        if (offset < 0 && offset > closest.offset) {
          return { offset, element: child };
        } else {
          return closest;
        }
      },
      { offset: Number.NEGATIVE_INFINITY }
    ).element;
  }
}

// Account Settings Modal
const accountSettingsModal = document.getElementById("account-settings-modal");
const populateAccountSettingsModal = (data) => {
  const businessOwner = accountSettingsModal.querySelector(".owners-name");
  const businessName = accountSettingsModal.querySelector(".business-name");
  const businessID = accountSettingsModal.querySelector(".business-id");
  const profileBg = accountSettingsModal.querySelector(".profile-bg");
  const avatar = accountSettingsModal.querySelector(".avatar");

  businessOwner.textContent = data.ownersName;
  businessName.textContent = data.businessName;
  businessID.textContent = data.id;
  profileBg.style.backgroundImage = `url(${data.businessCover})`;
  avatar.src = data.businessAvatar;
};
const clearAccountSettingsForm = () => {
  accountSettingsModal.querySelector(
    ".account-settings-form #owners-name"
  ).value = "";
  accountSettingsModal.querySelector(
    ".account-settings-form #business-name"
  ).value = "";
  accountSettingsModal.querySelector(
    ".account-settings-form #business-phone-number"
  ).value = "";
  accountSettingsModal.querySelector(
    ".account-settings-form #whatsapp-phone-number"
  ).value = "";
  accountSettingsModal.querySelector(
    ".account-settings-form #business-type"
  ).textContent = "";
  accountSettingsModal.querySelector(
    ".account-settings-form #currency"
  ).textContent = "";
};

function manageAccountSettingsModal() {
  populateAccountSettingsModal(businessProfile);
  accountSettingsModal.showModal();

  const editAvatarBtn = accountSettingsModal.querySelector(
    ".edit-avatar .edit-button"
  );
  editAvatarBtn.addEventListener("click", () => {
    const profilePhotoModal = existingModal.cloneNode(true);

    const modalAlreadyExists = document.querySelector("#profile-photo-modal");
    if (modalAlreadyExists) return;

    profilePhotoModal.id = "profile-photo-modal";
    profilePhotoModal.classList.add("animated-modal", "active");

    profilePhotoModal.innerHTML = `
      <div class="modal-heading">
        <p>
          <svg width="19" height="16" viewBox="0 0 22 19" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M18.5 2.875H16.1019L14.9375 1.12563C14.8346 0.971384 14.6952 0.844969 14.5316 0.757628C14.368 0.670286 14.1854 0.624726 14 0.625001H8C7.81458 0.624726 7.63197 0.670286 7.46841 0.757628C7.30484 0.844969 7.16541 0.971384 7.0625 1.12563L5.89719 2.875H3.5C2.80381 2.875 2.13613 3.15156 1.64384 3.64385C1.15156 4.13613 0.875 4.80381 0.875 5.5V16C0.875 16.6962 1.15156 17.3639 1.64384 17.8562C2.13613 18.3484 2.80381 18.625 3.5 18.625H18.5C18.8447 18.625 19.1861 18.5571 19.5045 18.4252C19.823 18.2933 20.1124 18.0999 20.3562 17.8562C20.5999 17.6124 20.7933 17.323 20.9252 17.0045C21.0571 16.6861 21.125 16.3447 21.125 16V5.5C21.125 5.15528 21.0571 4.81394 20.9252 4.49546C20.7933 4.17698 20.5999 3.8876 20.3562 3.64385C20.1124 3.40009 19.823 3.20674 19.5045 3.07482C19.1861 2.9429 18.8447 2.875 18.5 2.875ZM18.875 16C18.875 16.0995 18.8355 16.1948 18.7652 16.2652C18.6948 16.3355 18.5995 16.375 18.5 16.375H3.5C3.40054 16.375 3.30516 16.3355 3.23484 16.2652C3.16451 16.1948 3.125 16.0995 3.125 16V5.5C3.125 5.40055 3.16451 5.30516 3.23484 5.23484C3.30516 5.16451 3.40054 5.125 3.5 5.125H6.5C6.68542 5.12528 6.86803 5.07972 7.03159 4.99237C7.19516 4.90503 7.33459 4.77862 7.4375 4.62438L8.60187 2.875H13.3972L14.5625 4.62438C14.6654 4.77862 14.8048 4.90503 14.9684 4.99237C15.132 5.07972 15.3146 5.12528 15.5 5.125H18.5C18.5995 5.125 18.6948 5.16451 18.7652 5.23484C18.8355 5.30516 18.875 5.40055 18.875 5.5V16ZM11 5.875C10.11 5.875 9.23995 6.13892 8.49993 6.63339C7.75991 7.12785 7.18314 7.83066 6.84254 8.65293C6.50195 9.47519 6.41283 10.38 6.58647 11.2529C6.7601 12.1258 7.18868 12.9276 7.81802 13.557C8.44736 14.1863 9.24918 14.6149 10.1221 14.7885C10.995 14.9622 11.8998 14.8731 12.7221 14.5325C13.5443 14.1919 14.2471 13.6151 14.7416 12.8751C15.2361 12.135 15.5 11.265 15.5 10.375C15.4988 9.18191 15.0243 8.03804 14.1806 7.19439C13.337 6.35075 12.1931 5.87624 11 5.875ZM11 12.625C10.555 12.625 10.12 12.493 9.74997 12.2458C9.37996 11.9986 9.09157 11.6472 8.92127 11.236C8.75097 10.8249 8.70642 10.3725 8.79323 9.93605C8.88005 9.49959 9.09434 9.09868 9.40901 8.78401C9.72368 8.46934 10.1246 8.25505 10.561 8.16823C10.9975 8.08142 11.4499 8.12598 11.861 8.29627C12.2722 8.46657 12.6236 8.75496 12.8708 9.12497C13.118 9.49498 13.25 9.92999 13.25 10.375C13.25 10.9717 13.0129 11.544 12.591 11.966C12.169 12.3879 11.5967 12.625 11 12.625Z" fill="#2D2C2C"/>
          </svg>
          <span>Profile Photo</span>
        </p>
      </div>
      <div class="modal-body">
        <div class="button-container">
          <div class="swap-button"></div>
        </div>
        <div class="avatars show">
          <button class="male-select-photo-btn">
            <svg width="28" height="24" viewBox="0 0 28 24" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M16 8C16 7.60444 16.1173 7.21776 16.3371 6.88886C16.5568 6.55996 16.8692 6.30362 17.2346 6.15224C17.6001 6.00087 18.0022 5.96126 18.3902 6.03843C18.7781 6.1156 19.1345 6.30608 19.4142 6.58579C19.6939 6.86549 19.8844 7.22186 19.9616 7.60982C20.0387 7.99778 19.9991 8.39991 19.8478 8.76537C19.6964 9.13082 19.44 9.44318 19.1111 9.66294C18.7822 9.8827 18.3956 10 18 10C17.4696 10 16.9609 9.78929 16.5858 9.41421C16.2107 9.03914 16 8.53043 16 8ZM27.5 3V21C27.5 21.663 27.2366 22.2989 26.7678 22.7678C26.2989 23.2366 25.663 23.5 25 23.5H3C2.33696 23.5 1.70107 23.2366 1.23223 22.7678C0.763392 22.2989 0.5 21.663 0.5 21V3C0.5 2.33696 0.763392 1.70107 1.23223 1.23223C1.70107 0.763392 2.33696 0.5 3 0.5H25C25.663 0.5 26.2989 0.763392 26.7678 1.23223C27.2366 1.70107 27.5 2.33696 27.5 3ZM3.5 3.5V13.465L7.7325 9.2325C8.20132 8.76382 8.83709 8.50053 9.5 8.50053C10.1629 8.50053 10.7987 8.76382 11.2675 9.2325L16.4137 14.375L18.5613 12.2288C19.0301 11.7601 19.6658 11.4968 20.3288 11.4968C20.9917 11.4968 21.6274 11.7601 22.0963 12.2288L24.5 14.6362V3.5H3.5ZM3.5 20.5H18.2925L9.5 11.7075L3.5 17.7075V20.5ZM24.5 20.5V18.875L20.3288 14.7038L18.535 16.5L22.535 20.5H24.5Z" fill="#FF0828"/>
            </svg>
            <input type="file" id="male-image-input" accept="image/*" />
          </button>
        </div>
        <div class="avatars">
          <button class="female-select-photo-btn">
            <svg width="28" height="24" viewBox="0 0 28 24" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M16 8C16 7.60444 16.1173 7.21776 16.3371 6.88886C16.5568 6.55996 16.8692 6.30362 17.2346 6.15224C17.6001 6.00087 18.0022 5.96126 18.3902 6.03843C18.7781 6.1156 19.1345 6.30608 19.4142 6.58579C19.6939 6.86549 19.8844 7.22186 19.9616 7.60982C20.0387 7.99778 19.9991 8.39991 19.8478 8.76537C19.6964 9.13082 19.44 9.44318 19.1111 9.66294C18.7822 9.8827 18.3956 10 18 10C17.4696 10 16.9609 9.78929 16.5858 9.41421C16.2107 9.03914 16 8.53043 16 8ZM27.5 3V21C27.5 21.663 27.2366 22.2989 26.7678 22.7678C26.2989 23.2366 25.663 23.5 25 23.5H3C2.33696 23.5 1.70107 23.2366 1.23223 22.7678C0.763392 22.2989 0.5 21.663 0.5 21V3C0.5 2.33696 0.763392 1.70107 1.23223 1.23223C1.70107 0.763392 2.33696 0.5 3 0.5H25C25.663 0.5 26.2989 0.763392 26.7678 1.23223C27.2366 1.70107 27.5 2.33696 27.5 3ZM3.5 3.5V13.465L7.7325 9.2325C8.20132 8.76382 8.83709 8.50053 9.5 8.50053C10.1629 8.50053 10.7987 8.76382 11.2675 9.2325L16.4137 14.375L18.5613 12.2288C19.0301 11.7601 19.6658 11.4968 20.3288 11.4968C20.9917 11.4968 21.6274 11.7601 22.0963 12.2288L24.5 14.6362V3.5H3.5ZM3.5 20.5H18.2925L9.5 11.7075L3.5 17.7075V20.5ZM24.5 20.5V18.875L20.3288 14.7038L18.535 16.5L22.535 20.5H24.5Z" fill="#FF0828"/>
            </svg>
            <input type="file" id="female-image-input" accept="image/*" />
          </button>
        </div>
      </div>
    `;

    const maleAvatars = [
      "./assets/icons/avatars/male-avatar-1.svg",
      "./assets/icons/avatars/male-avatar-2.svg",
      "./assets/icons/avatars/male-avatar-3.svg",
      "./assets/icons/avatars/male-avatar-4.svg",
      "./assets/icons/avatars/male-avatar-5.svg",
      "./assets/icons/avatars/male-avatar-6.svg",
      "./assets/icons/avatars/male-avatar-7.svg",
      "./assets/icons/avatars/male-avatar-8.svg",
      "./assets/icons/avatars/male-avatar-9.svg",
      "./assets/icons/avatars/male-avatar-10.svg",
    ];
    const FemaleAvatars = [
      "./assets/icons/avatars/avatar-1.svg",
      "./assets/icons/avatars/avatar-2.svg",
      "./assets/icons/avatars/avatar-3.svg",
      "./assets/icons/avatars/avatar-4.svg",
      "./assets/icons/avatars/avatar-5.svg",
      "./assets/icons/avatars/avatar-6.svg",
      "./assets/icons/avatars/avatar-7.svg",
      "./assets/icons/avatars/avatar-8.svg",
      "./assets/icons/avatars/avatar-9.svg",
      "./assets/icons/avatars/avatar-10.svg",
    ];

    const avatarsContainers = profilePhotoModal.querySelectorAll(".avatars");
    const profilePhoto = accountSettingsModal.querySelector(".avatar");

    maleAvatars.forEach((avatarUrl) => {
      let buttonInAvatars = avatarsContainers[0].querySelector("button");
      const img = document.createElement("img");
      img.src = avatarUrl;
      img.alt = "Avatar";
      img.classList.add("avatar-image");

      img.addEventListener("click", () => {
        profilePhoto.src = avatarUrl;

        profilePhotoModal.classList.remove("active");
        profilePhotoModal.classList.add("closing");

        setTimeout(() => {
          profilePhotoModal.classList.remove("closing");
          profilePhotoModal.close();
          profilePhotoModal.remove();
        }, 400);
      });

      if (buttonInAvatars) {
        avatarsContainers[0].insertBefore(img, buttonInAvatars);
      } else {
        avatarsContainers[0].appendChild(img);
      }
    });
    FemaleAvatars.forEach((avatarUrl) => {
      let buttonInAvatars = avatarsContainers[1].querySelector("button");
      const img = document.createElement("img");
      img.src = avatarUrl;
      img.alt = "Avatar";
      img.classList.add("avatar-image");

      img.addEventListener("click", () => {
        profilePhoto.src = avatarUrl;

        profilePhotoModal.classList.remove("active");
        profilePhotoModal.classList.add("closing");

        setTimeout(() => {
          profilePhotoModal.classList.remove("closing");
          profilePhotoModal.close();
          profilePhotoModal.remove();
        }, 400);
      });

      if (buttonInAvatars) {
        avatarsContainers[1].insertBefore(img, buttonInAvatars);
      } else {
        avatarsContainers[1].appendChild(img);
      }
    });

    const selectMaleCustomAvatarBtn = profilePhotoModal.querySelector(
      ".male-select-photo-btn"
    );
    selectMaleCustomAvatarBtn.addEventListener("click", () => {
      initializeImageEditor("male-image-input", (result, buttonId) => {
        console.log(`Result for ${buttonId}:`, result);
        // const maleProfilePhoto = document.querySelector("#male-profile-photo");
        // if (maleProfilePhoto) {
        //   maleProfilePhoto.src = result.url;
        // }
      });
    });

    // For a female avatar button
    const selectFemaleCustomAvatarBtn = profilePhotoModal.querySelector(
      ".female-select-photo-btn"
    );
    selectFemaleCustomAvatarBtn.addEventListener("click", () => {
      initializeImageEditor("female-image-input", (result, buttonId) => {
        console.log(`Result for ${buttonId}:`, result);
        // Handle female avatar specific logic
        const femaleProfilePhoto = document.querySelector(
          "#female-profile-photo"
        );
        if (femaleProfilePhoto) {
          femaleProfilePhoto.src = result.url;
        }
      });
    });

    main.appendChild(profilePhotoModal);
    profilePhotoModal.showModal();

    const photoButtonContainer =
      profilePhotoModal.querySelector(".swap-button");
    photoButtonContainer.addEventListener("click", (event) => {
      const rect = photoButtonContainer.getBoundingClientRect();
      const clickX = event.clientX;

      const isLeftClick = clickX < rect.left + rect.width / 2;

      if (isLeftClick) {
        photoButtonContainer.classList.remove("right-clicked");
        photoButtonContainer.classList.add("left-clicked");

        avatarsContainers[0].classList.add("show");
        avatarsContainers[1].classList.remove("show");
      } else {
        photoButtonContainer.classList.remove("left-clicked");
        photoButtonContainer.classList.add("right-clicked");

        avatarsContainers[0].classList.remove("show");
        avatarsContainers[1].classList.add("show");
      }
    });

    profilePhotoModal.addEventListener("click", (event) => {
      if (event.target === profilePhotoModal) {
        profilePhotoModal.classList.remove("active");
        profilePhotoModal.classList.add("closing");

        setTimeout(() => {
          profilePhotoModal.classList.remove("closing");
          profilePhotoModal.close();
          profilePhotoModal.remove();
        }, 400);
      }
    });
  });
  const updateButton = accountSettingsModal.querySelector("#confirm-update");
  updateButton.addEventListener("click", () => {
    // Select the element
    const businessBgCoverElement =
      accountSettingsModal.querySelector(".profile-bg");
    const style = window.getComputedStyle(businessBgCoverElement);
    const backgroundImage = style.backgroundImage;
    let backgroundImageUrl;

    if (backgroundImage !== "none") {
      const urlMatch = backgroundImage.match(/url\(["']?([^"')]+)["']?\)/);
      backgroundImageUrl = urlMatch ? urlMatch[1] : null;
    } else {
      backgroundImageUrl = "";
    }

    // const ownersNameInput = modal.querySelector("form ")
    // const ownersNameInput = modal.querySelector("form ")
    const formData = {
      ownersName: accountSettingsModal
        .querySelector("#owners-name")
        .value.trim(),
      businessName: accountSettingsModal
        .querySelector("#business-name")
        .value.trim(),
      phoneNumber: accountSettingsModal
        .querySelector("#business-phone-number")
        .value.trim(),
      whatsappNumber: accountSettingsModal
        .querySelector("#whatsapp-phone-number")
        .value.trim(),
      businessAvatar: accountSettingsModal.querySelector(".avatar").src,
      businessCover: backgroundImageUrl,
      businessType:
        accountSettingsModal.querySelector("#business-type").textContent,
      currency: accountSettingsModal.querySelector("#currency").textContent,
    };

    const changedFields = {};

    Object.keys(formData).forEach((field) => {
      if (formData[field] === "" || formData[field] == businessProfile[field]) {
        return;
      }
      changedFields[field] = formData[field];
    });

    if (Object.keys(changedFields).length > 0) {
      updateDatabase(changedFields);
    }
  });

  async function updateDatabase(changedFields) {
    try {
      Object.assign(businessProfile, changedFields);

      console.log("Updated fields:", changedFields);
      console.log("Updated database:", businessProfile);

      createAlert(
        "account updated",
        "./assets/icons/filled-check.svg",
        "green-4"
      );
      populateAccountSettingsModal(businessProfile);
      clearAccountSettingsForm();
      populateNavbar();
    } catch (error) {
      console.error("Error updating settings:", error);
      showNotification("Failed to update settings", "error");
    }
  }

  const closeButton = accountSettingsModal.querySelector(
    "#account-settings-modal .close-button"
  );
  closeButton.addEventListener("click", () => {
    accountSettingsModal.close();
  });
}

// Function to create an editor instance for a specific button
function createEditorInstance(buttonId, onCompleteCallback) {
  const inputFieldId = buttonId;

  let inputField = document.querySelector(`#${inputFieldId}`);
  if (!inputField) {
    inputField = document.createElement("input");
    inputField.type = "file";
    inputField.id = inputFieldId;
    inputField.accept = "image/*";
    inputField.style.display = "none";
    document.body.appendChild(inputField);
  }

  const imageEditor = new ImageEdit({
    inputFieldId: inputFieldId,
    editModalId: "crop-modal",
    onEdit: async (editedData) => {
      try {
        const result = await handleImageUpload(
          editedData,
          imageEditor,
          onCompleteCallback,
          buttonId
        );

        // Call the completion callback with the result and original button ID
        onCompleteCallback(result, buttonId);
      } catch (error) {
        console.error("Upload failed or was cancelled:", error);
      }
    },
  });

  return imageEditor;
}

// Initialize editor for any button
function initializeImageEditor(buttonId, onComplete) {
  return createEditorInstance(buttonId, onComplete);
}

const handleImageUpload = (data, imageEditor, onCompleteCallback, buttonId) => {
  return new Promise((resolve, reject) => {
    const uploadImageModal = document.querySelector("#upload-image-modal");
    const cropPhotoModal = document.querySelector("#crop-modal");
    const profilePhotoModal = document.querySelector("#profile-photo-modal");
    let isReplacing = false;

    uploadImageModal.showModal();

    // Get progress elements
    const previewImage = uploadImageModal.querySelector("#preview");
    previewImage.src = data.url;
    const progressContainer = uploadImageModal.querySelector("#uploadProgress");
    const imageTitle = uploadImageModal.querySelector(".image-title");
    const uploadStatus = uploadImageModal.querySelectorAll(
      ".upload-progress-title"
    );
    const replaceImageBtn =
      uploadImageModal.querySelector("#photo-replace-btn");
    const cropButton = uploadImageModal.querySelector(".crop-image-button");
    const cancelButton = uploadImageModal.querySelector(".cancel-button");
    const publishButton = uploadImageModal.querySelector(".done-button");

    // Show progress
    progressContainer.style.display = "flex";
    imageTitle.textContent = data.name;
    uploadStatus[0].classList.remove("hide");
    replaceImageBtn.classList.add("hide");
    cropButton.classList.remove("show");
    cancelButton.classList.add("show");
    publishButton.classList.remove("show");

    // Simulate upload
    const totalSize = data.size;
    let loadedSize = 0;
    const chunkSize = totalSize / 20;

    const updateProgress = () => {
      loadedSize = Math.min(loadedSize + chunkSize, totalSize);
      const progress = Math.round((loadedSize / totalSize) * 100);

      const progressBar = document.getElementById("progressBar");
      const progressPercentage = document.getElementById("progressPercentage");
      const progressElement = document.querySelector(".progress");
      const sizeElement = document.querySelector(".size");

      progressBar.style.setProperty("--progress", `${progress}%`);
      progressBar.style.cssText = `--progress: ${progress}%;`;
      progressBar.style.setProperty("width", `${progress}%`);

      progressPercentage.textContent = `${progress}%`;
      progressElement.textContent = formatFileSize(loadedSize);
      sizeElement.textContent = formatFileSize(totalSize);

      if (progress < 100) {
        setTimeout(updateProgress, Math.random() * 200 + 100);
      } else {
        setTimeout(() => {
          progressBar.style.width = "100%";
          progressPercentage.textContent = "100%";
          replaceImageBtn.classList.remove("hide");
          uploadStatus[0].classList.add("hide");
          cropButton.classList.add("show");
          cancelButton.classList.remove("show");
          publishButton.classList.add("show");

          // Update input if needed
          const dataTransfer = new DataTransfer();
          dataTransfer.items.add(data.file);
          if (imageEditor.inputField.hasAttribute("name")) {
            imageEditor.inputField.files = dataTransfer.files;
          }
        }, 500);
      }
    };

    // Clean up existing event listeners
    const cleanupListeners = () => {
      publishButton.removeEventListener("click", publishHandler);
      replaceImageBtn.removeEventListener("click", replaceHandler);
      cropButton.removeEventListener("click", cropHandler);
      cancelButton.removeEventListener("click", cancelHandler);
    };

    // Event handler functions
    const publishHandler = async () => {
      try {
        onCompleteCallback(
          {
            success: true,
            url: data.url,
            file: data.file,
          },
          buttonId
        );

        imageEditor.destroy();
        uploadImageModal.close();
        cropPhotoModal.close();
        if (profilePhotoModal) {
          profilePhotoModal.close();
          profilePhotoModal.remove();
        }
        cleanupListeners();
        resolve({
          success: true,
          url: data.url,
          file: data.file,
        });
      } catch (error) {
        console.error("Error in publish handler:", error);
        reject(error);
      }
    };

    const replaceHandler = () => {
      isReplacing = true;

      // Create a temporary input for file selection
      const tempInput = document.createElement("input");
      tempInput.type = "file";
      tempInput.accept = "image/*";
      tempInput.style.display = "none";
      document.body.appendChild(tempInput);

      tempInput.addEventListener("change", async (event) => {
        if (event.target.files && event.target.files[0]) {
          const file = event.target.files[0];

          // Clean up
          document.body.removeChild(tempInput);
          cleanupListeners();
          uploadImageModal.close();

          if (cropPhotoModal && cropPhotoModal.open) {
            cropPhotoModal.close();
          }

          // Destroy old editor
          if (imageEditor) {
            imageEditor.destroy();
          }

          // Wait for cleanup to complete
          setTimeout(() => {
            // Create button element to trigger new editor
            const newButton = document.createElement("button");
            newButton.style.display = "none";
            document.body.appendChild(newButton);

            // Initialize new editor
            const newEditor = createEditorInstance(
              buttonId,
              onCompleteCallback
            );

            // Set up the input with the new file
            const newInput = document.querySelector(buttonId);
            if (newInput) {
              const dataTransfer = new DataTransfer();
              dataTransfer.items.add(file);
              newInput.files = dataTransfer.files;

              // Simulate button click to trigger editor
              newButton.click();
              document.body.removeChild(newButton);

              // Trigger change event after a short delay
              setTimeout(() => {
                newInput.dispatchEvent(new Event("change", { bubbles: true }));
              }, 50);
            }
          }, 100);
        }
      });

      tempInput.click();
    };

    const cropHandler = () => {
      uploadImageModal.close();
    };

    const cancelHandler = () => {
      if (!isReplacing) {
        imageEditor.destroy();
      }
      uploadImageModal.close();
      if (cropPhotoModal && cropPhotoModal.open) {
        cropPhotoModal.close();
      }
      cleanupListeners();
      reject(new Error("Upload cancelled"));
    };

    // Add event listeners
    publishButton.addEventListener("click", publishHandler);
    replaceImageBtn.addEventListener("click", replaceHandler);
    cropButton.addEventListener("click", cropHandler);
    cancelButton.addEventListener("click", cancelHandler);

    updateProgress();
  });
};

const accountSettingsButton = document.querySelector(
  "#account-settings-button"
);
accountSettingsButton.addEventListener("click", () => {
  manageAccountSettingsModal();
});

const editAccountButton = document.querySelector("#qr-code #edit-profile");
editAccountButton.addEventListener("click", () => {
  manageAccountSettingsModal();
});

// QR Code Modal
function QRCodeModal(user) {
  const modal = document.getElementById("qr-code-modal");

  const qrCode = main.querySelector(".qr-code");
  qrCode.src = user;

  modal.showModal();

  const closeButton = modal.querySelector(".close-button");
  closeButton.addEventListener("click", () => {
    modal.close();
  });
}

const userQRButton = document.querySelector("#qr-code #user-qr-button");
userQRButton.addEventListener("click", () => {
  QRCodeModal("./assets/images/qr.png");
});

const globalQRButton = document.querySelector("#qr-code #global-qr-button");
globalQRButton.addEventListener("click", () => {
  QRCodeModal("./assets/images/qr-2.png");
});

document
  .querySelector("#story-modal .upload-button")
  .addEventListener("click", () => {
    const storyModal = document.querySelector("#story-modal");
    const container = storyModal.querySelector(".column-one");

    const viewImageSection = storyModal.querySelector(".view-image-section");
    const backgroundImage = viewImageSection.querySelector(".image-container");
    // Initialize the image editor
    const imageEditor = new ImageEdit({
      inputFieldId: "fileInput",
      editModalId: "story-modal",
      onEdit: async (editedData) => {
        const cropImageSection = cropModal.querySelector(".crop-image-section");
        container.classList.remove("select");
        container.classList.remove("crop");
        container.classList.add("view");
        backgroundImage.style.backgroundImage = url(editedData.url);
      },
    });
  });

// About Discount Modal
const aboutDiscountButtons = document.querySelectorAll(".about-discount");
let modalTimeout;

aboutDiscountButtons.forEach((button) => {
  button.addEventListener("mouseenter", () => {
    if (document.getElementById("about-discount-modal")) return;

    const modal = existingModal.cloneNode(true);
    modal.id = "about-discount-modal";
    modal.classList.add("lined-modal");

    modal.innerHTML = `
      <div class="modal-heading">
        <p>
          <svg width="18" height="18" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M9.125 6.875C9.125 6.57833 9.21298 6.28832 9.3778 6.04165C9.54262 5.79497 9.77689 5.60271 10.051 5.48918C10.3251 5.37565 10.6267 5.34594 10.9176 5.40382C11.2086 5.4617 11.4759 5.60456 11.6857 5.81434C11.8954 6.02412 12.0383 6.29139 12.0962 6.58236C12.1541 6.87334 12.1244 7.17494 12.0108 7.44903C11.8973 7.72311 11.705 7.95738 11.4584 8.1222C11.2117 8.28703 10.9217 8.375 10.625 8.375C10.2272 8.375 9.84565 8.21696 9.56434 7.93566C9.28304 7.65436 9.125 7.27282 9.125 6.875ZM21.125 11C21.125 13.0025 20.5312 14.9601 19.4186 16.6251C18.3061 18.2902 16.7248 19.5879 14.8747 20.3543C13.0246 21.1206 10.9888 21.3211 9.02471 20.9305C7.06066 20.5398 5.25656 19.5755 3.84055 18.1595C2.42454 16.7435 1.46023 14.9393 1.06955 12.9753C0.678878 11.0112 0.879387 8.97543 1.64572 7.12533C2.41206 5.27523 3.70981 3.69392 5.37486 2.58137C7.0399 1.46882 8.99747 0.875 11 0.875C13.6844 0.877978 16.258 1.94567 18.1562 3.84383C20.0543 5.74199 21.122 8.3156 21.125 11ZM18.875 11C18.875 9.44247 18.4131 7.91992 17.5478 6.62488C16.6825 5.32985 15.4526 4.32049 14.0136 3.72445C12.5747 3.12841 10.9913 2.97246 9.46367 3.27632C7.93607 3.58017 6.53288 4.3302 5.43154 5.43153C4.3302 6.53287 3.58018 7.93606 3.27632 9.46366C2.97246 10.9913 3.12841 12.5747 3.72445 14.0136C4.32049 15.4526 5.32985 16.6825 6.62489 17.5478C7.91993 18.4131 9.44248 18.875 11 18.875C13.0879 18.8728 15.0896 18.0424 16.566 16.566C18.0424 15.0896 18.8728 13.0879 18.875 11ZM12.125 14.4387V11.375C12.125 10.8777 11.9275 10.4008 11.5758 10.0492C11.2242 9.69754 10.7473 9.5 10.25 9.5C9.98433 9.4996 9.72708 9.59325 9.52383 9.76435C9.32058 9.93544 9.18444 10.173 9.13952 10.4348C9.09461 10.6967 9.14381 10.966 9.27843 11.195C9.41304 11.4241 9.62438 11.5981 9.875 11.6863V14.75C9.875 15.2473 10.0725 15.7242 10.4242 16.0758C10.7758 16.4275 11.2527 16.625 11.75 16.625C12.0157 16.6254 12.2729 16.5318 12.4762 16.3607C12.6794 16.1896 12.8156 15.952 12.8605 15.6902C12.9054 15.4283 12.8562 15.159 12.7216 14.93C12.587 14.7009 12.3756 14.5269 12.125 14.4387Z" fill="#2D2C2C"/>
          </svg>
          <span>About Discount</span>
        </p>
      </div>
      <div class="modal-body">
        <span>How it works</span>
        <p>
          Set Discounts are auto applied to relative days if the Calendar Date range is not set.
        </p>
      </div>
    `;

    main.appendChild(modal);
    modal.showModal();

    const modalSections = modal.querySelectorAll(".modal-heading, .modal-body");

    modalSections.forEach((section) => {
      section.addEventListener("mouseenter", () => {
        // modal.close();
        // modal.remove();
      });

      section.addEventListener("mouseleave", () => {
        modal.close();
        modal.remove();
      });
    });
  });
});

const editPublishButton = document.querySelector(
  "#dishes #edit-form .create-form-header .publish-button"
);
editPublishButton.addEventListener("click", () => {
  createAlert("dish published", "./assets/icons/filled-check.svg", "green-4");
});

// open payment settings modal
const paymentSettingsModal = document.querySelector("#online-payment-modal");
const paymentSettingsModalBtn = document.querySelector(
  "#settings .payment-settings-modal-btn"
);
const paymentSettingsCloseModalBtn =
  paymentSettingsModal.querySelector(".close-button");
paymentSettingsModalBtn.addEventListener("click", () => {
  paymentSettingsModal.showModal();
});
paymentSettingsCloseModalBtn.addEventListener("click", () => {
  paymentSettingsModal.close();
});
