const homePage = document.querySelector("#home");
// const restaurantID = localStorage.getItem("id");

// Populate Navbar
const navbar = document.querySelector(".top-nav");
const restaurantStatusBtns = navbar.querySelectorAll(".toggle-button");

restaurantStatusBtns.forEach((button) => {
  button.addEventListener("click", async () => {
    const buttonText = button.querySelector(".status");
    const buttonSwitch = button.querySelector("img");

    try {
      button.disabled = true;
      if (button.classList.contains("open")) {
        let updatedData = {
          businessStatus: "close",
        };
        const updatedStatus = await update(
          "restaurants",
          restaurantID,
          updatedData
        );
        if (updatedStatus) {
          button.classList.replace("open", "close");
          buttonText.textContent = "Close";
          buttonSwitch.src = "./assets/icons/toggle-off.svg";
        }
      } else if (button.classList.contains("close")) {
        let updatedData = {
          businessStatus: "open",
        };
        const updatedStatus = await update(
          "restaurants",
          restaurantID,
          updatedData
        );
        if (updatedStatus) {
          button.classList.replace("close", "open");
          buttonText.textContent = "Open";
          buttonSwitch.src = "./assets/icons/toggle-on.svg";
        }
      }
    } catch (error) {
      createAlert("couldn't update status", "./assets/icons/bin.svg", "red-5");
    } finally {
      button.disabled = false;
    }
  });
});

// Toggle dropdown in recent orders category
let recentOrders = document.querySelectorAll(".recent-orders .order");

recentOrders.forEach((order) => {
  let order_dropdown_button = order.querySelector(
    ".order-info .order-dropdown-button"
  );
  if (order_dropdown_button) {
    order_dropdown_button.addEventListener("click", () => {
      order.classList.toggle("open");
    });
  }
});

const earningsBtn = document.querySelector(
  ".side-nav .nav-items .earnings-button"
);
const earningsCloseBtn = document.querySelector(
  ".earnings-container .earnings-heading .close-btn"
);
const earningsContainer = document.querySelector(".earnings-container");
earningsBtn.addEventListener("click", () => {
  earningsContainer.classList.add("open");
  sideBar.classList.remove("open");
});
earningsCloseBtn.addEventListener("click", () => {
  earningsContainer.classList.remove("open");
});
