const dishesPage = document.querySelector("#dishes");
let activePage = "menu";
let previousPage = "categorized";
let currentPage = "categorized";
let customizationSearch = false;

// let restaurantID = localStorage.getItem(id);
function clearShowClass(elements) {
  elements.forEach((item) => item?.classList.remove("show"));
}
let previousCategoryPage;

const dishesSubPages = dishesPage.querySelectorAll(":scope > *");
const categorizedDishes = dishesPage.querySelector(".categorized-container");
const dishesSectionHeader = categorizedDishes.querySelector(".dishes-header");
const dishesDirectChildren = dishesSectionHeader.querySelectorAll(":scope > *");

const categorized_content = categorizedDishes.querySelector(
  ".categorized-content"
);
const categorizedDishesPages =
  categorized_content.querySelectorAll(":scope > *");

if (categorizedDishesPages[0]?.classList.contains("show")) {
  clearShowClass(dishesDirectChildren);
  dishesDirectChildren[2]?.classList.add("show");
  dishesDirectChildren[4]?.classList.add("show", "open-modal-btn");
} else if (categorizedDishesPages[1]?.classList.contains("show")) {
  clearShowClass(dishesDirectChildren);
  dishesDirectChildren[3]?.classList.add("show");
  dishesDirectChildren[5]?.classList.add("show");
} else if (categorizedDishesPages[2]?.classList.contains("show")) {
  clearShowClass(dishesDirectChildren);
  dishesDirectChildren[3]?.classList.add("show");
}

// Handle the swap button animation
const dishesButtonContainer = document.querySelector(
  ".dishes-header .swap-button"
);
dishesButtonContainer.addEventListener("click", (event) => {
  const rect = dishesButtonContainer.getBoundingClientRect();
  const clickX = event.clientX;

  const isLeftClick = clickX < rect.left + rect.width / 2;

  if (isLeftClick) {
    dishesButtonContainer.classList.remove("right-clicked");
    dishesButtonContainer.classList.add("left-clicked");
    clearShowClass(categorizedDishesPages);
    clearShowClass(dishesDirectChildren);

    categorizedDishesPages[0].classList.add("show");
    dishesDirectChildren[2]?.classList.add("show");
    dishesDirectChildren[4]?.classList.add("show");

    activePage = "menu";
  } else {
    dishesButtonContainer.classList.remove("left-clicked");
    dishesButtonContainer.classList.add("right-clicked");
    clearShowClass(categorizedDishesPages);
    clearShowClass(dishesDirectChildren);

    categorizedDishesPages[1].classList.add("show");
    dishesDirectChildren[3]?.classList.add("show");
    dishesDirectChildren[5]?.classList.add("show");

    activePage = "dishes";
  }
});

// Manage Uncategorized dishes
const uncategorizedDishes = dishesPage.querySelector(
  ".uncategorized-container"
);

dishesDirectChildren[3].addEventListener("click", () => {
  uncategorizedDishes.classList.add("show");
  categorizedDishes.classList.remove("show");

  currentPage = "uncategorized";

  let titleSpan = document.getElementById("page-title");
  titleSpan.innerHTML = "Dishes & Menu &nbsp; > &nbsp; Uncategorized Dish";
});

const addToCategoryButton = uncategorizedDishes.querySelector(
  ".dishes-header > button"
);
addToCategoryButton.addEventListener("click", () => {
  selectMenuCategoryModal(menuData.categories).then((category) => {
    if (category) {
      selectMenuCategoryButton.textContent = category;
      selectMenuCategoryInput.classList.add("selected");
    } else {
    }
  });
});

const uncategorizedCardTemplate = uncategorizedDishes.querySelector(
  "#uncategorized-dish-card"
);

const uncategorizedBackBtn = document.querySelector(
  ".uncategorized-container .dishes-header > p > button"
);
uncategorizedBackBtn.addEventListener("click", () => {
  categorizedDishes.classList.add("show");
  uncategorizedDishes.classList.remove("show");

  previousPage = "categorized";
  currentPage = "categorized";

  let titleSpan = document.getElementById("page-title");
  titleSpan.innerHTML = "Dishes & Menu";
});

// Manage Create Dish Form
let newMenuCategories = [];
let newSideItems = [];
let newDish = [];
let workingDish;
let workingItem;

const createDishForm = document.getElementById("create-form");
const createDishForm_backbtn = dishesPage.querySelector(
  ".create-form .create-form-header > p > button"
);
dishesDirectChildren[5].addEventListener("click", () => {
  clearShowClass(dishesSubPages);
  createDishForm.classList.add("show");

  currentPage = "create-dish-form";

  const dataID = generateUniqueId("dish");

  newDish = {
    id: dataID,
  };

  let titleSpan = document.getElementById("page-title");
  titleSpan.innerHTML = "Dishes & Menu &nbsp; > &nbsp; Create Dish";
});
createDishForm_backbtn.addEventListener("click", () => {
  clearShowClass(dishesSubPages);
  categorizedDishes.classList.add("show");

  clearShowClass(categorizedDishesPages);
  categorizedDishesPages[1].classList.add("show");

  let titleSpan = document.getElementById("page-title");
  titleSpan.innerHTML = "Dishes & Menu";

  currentPage = "categorized";

  clearShowClass(dishesDirectChildren);
  categorizedDishesPages[1].classList.add("show");
  dishesDirectChildren[3]?.classList.add("show");
  dishesDirectChildren[5]?.classList.add("show");
});

const createFormItemCategoryBtns =
  createDishForm.querySelectorAll(".new-category-btn");
const createFormAddItemsBackBtn = createDishForm.querySelector(
  ".create-form-header .back-button"
);

createFormItemCategoryBtns.forEach((button) => {
  button.addEventListener("click", () => {
    newItemCategoryModal().then((category) => {
      if (category) {
        let newCategory = {
          id: category.id,
          name: category.name,
          type: category.type,
          noOfSides: category.noOfSides,
          required: category.required,
          status: "enabled",
          dishId: newDish.id,
          items: [],
        };
        newDish.sideItems.push(newCategory);

        createAlert(
          "menu list updated",
          "./assets/icons/filled-check.svg",
          "green-4"
        );
      } else {
      }
    });
  });
});

const selectMenuCategoryInput = createDishForm.querySelector("#menu-category");
const selectMenuCategoryButton = createDishForm.querySelector(
  "#menu-category > button"
);

selectMenuCategoryButton.addEventListener("click", () => {
  selectMenuCategoryModal(menuData.categories).then((category) => {
    if (category) {
      selectMenuCategoryButton.textContent = category;
      selectMenuCategoryInput.classList.add("selected");
    } else {
    }
  });
});

const createDishAddItemButtons =
  createDishForm.querySelectorAll(".add-items-btn");
createDishAddItemButtons.forEach((button) => {
  button.addEventListener("click", () => {
    previousCategoryPage = "create-dish";
    currentPage = "add-item-form";

    clearShowClass(dishesSubPages);
    addItemForm.classList.add("show");
    createDishForm.classList.remove("show");

    const dataID = generateUniqueId("sideItem");
    newItem = {
      id: dataID,
    };

    let titleSpan = document.getElementById("page-title");
    titleSpan.innerHTML = "Dishes & Menu &nbsp; > &nbsp; Add Item";
  });
});

const createFormPublishBtns =
  createDishForm.querySelectorAll(".publish-button");
createFormPublishBtns.forEach((button) => {
  button.addEventListener("click", async () => {
    const formData = gatherFormData("", createDishForm);

    formData.sideItems = newDish.sideItems;
    formData.id = newDish.id;

    if (formData.category) {
      menuData.categories.forEach((item) => {
        if (item.name.toLowerCase() == formData.category) {
          formData.categoryId = item.id;
          item.dishes.push(formData);
        }
      });
      try {
        let updatedData = {
          categories: menuData.categories,
        };
        await updateIfHasValue(
          "menus",
          menuData.id,
          "businessID",
          restaurantID,
          updatedData
        );
        populateCardsByCategory(menuData.categories);
        populateInfoCards();
        populateDishesInfoCard();
      } catch (error) {
        createAlert(
          "couldn't create new categoryr",
          "./assets/icons/bin.svg",
          "red-5"
        );
      }
    } else {
      menuData.uncategorizedItems.push(formData);
      try {
        let updatedData = {
          uncategorizedItems: menuData.uncategorizedItems,
        };
        await updateIfHasValue(
          "menus",
          menuData.id,
          "businessID",
          restaurantID,
          updatedData
        );
        populateUncategorizedContainer(menuData.uncategorizedItems);
      } catch (error) {
        createAlert(
          "couldn't create new categoryr",
          "./assets/icons/bin.svg",
          "red-5"
        );
      }
    }

    newDish = {};
    clearForm("", createDishForm);

    createAlert(
      "menu list updated",
      "./assets/icons/filled-check.svg",
      "green-4"
    );
  });
});

// // Manage Add Item Form
const addItemForm = document.getElementById("add-item-form");
const addItemsBackBtn = addItemForm.querySelector(
  ".create-form-header .back-button"
);
addItemsBackBtn.addEventListener("click", () => {
  if (previousCategoryPage == "create-dish") {
    clearShowClass(dishesSubPages);
    createDishForm.classList.add("show");

    currentPage = "create-dish-form";

    let titleSpan = document.getElementById("page-title");
    titleSpan.innerHTML = "Dishes & Menu &nbsp; > &nbsp; Create Dish";
  } else if (previousCategoryPage == "edit-dish") {
    clearShowClass(dishesSubPages);
    editDishForm.classList.add("show");

    currentPage = "edit-dish-form";

    let titleSpan = document.getElementById("page-title");
    titleSpan.innerHTML = "Dishes & Menu &nbsp; > &nbsp; Edit Dish";
  }
});

const addItemFormSelectCategoryInput =
  addItemForm.querySelector("#menu-category3");
const addItemFormSelectCategoryBtn = addItemForm.querySelector(
  "#menu-category3 > button"
);

addItemFormSelectCategoryBtn.addEventListener("click", () => {
  if (previousCategoryPage == "create-dish") {
    selectItemCategoryModal(newDish.sideItems).then((category) => {
      if (category) {
        addItemFormSelectCategoryBtn.textContent = category;
        addItemFormSelectCategoryInput.classList.add("selected");
      } else {
      }
    });
  } else if (previousCategoryPage == "edit-dish") {
    selectItemCategoryModal(workingDish.sideItems).then((category) => {
      if (category) {
        addItemFormSelectCategoryBtn.textContent = category;
        addItemFormSelectCategoryInput.classList.add("selected");
      } else {
      }
    });
  }
});

const addItemsPublishBtns = addItemForm.querySelectorAll(".publish-button");
addItemsPublishBtns.forEach((button) => {
  button.addEventListener("click", () => {
    const formData = gatherFormData(3, addItemForm);

    formData.id = newItem.id;

    if (previousCategoryPage == "create-dish") {
      newDish.sideItems.forEach((item) => {
        if (item.name.toLowerCase() == formData.category) {
          formData.categoryId = item.id;
          item.items.push(formData);
        }
      });
      createAlert(
        "item published",
        "./assets/icons/filled-check.svg",
        "green-4"
      );

      newItem = {};

      setTimeout(() => {
        clearForm(3, addItemForm);

        clearShowClass(dishesSubPages);
        createDishForm.classList.add("show");

        currentPage = "create-dish-form";

        let titleSpan = document.getElementById("page-title");
        titleSpan.innerHTML = "Dishes & Menu &nbsp; > &nbsp; Create Dish";

        const customizationContainer = createDishForm.querySelector(
          ".customization-container"
        );
        displayNewItem(newDish.sideItems, customizationContainer);
      }, 800);
    } else if (previousCategoryPage == "edit-dish") {
      workingDish.sideItems.forEach((item) => {
        if (item.name.toLowerCase() == formData.category) {
          formData.categoryId = item.id;
          item.items.push(formData);
        }
      });
      createAlert(
        "item published",
        "./assets/icons/filled-check.svg",
        "green-4"
      );

      newItem = {};

      setTimeout(() => {
        clearForm(3, addItemForm);

        clearShowClass(dishesSubPages);
        editDishForm.classList.add("show");

        currentPage = "edit-dish-form";

        let titleSpan = document.getElementById("page-title");
        titleSpan.innerHTML = "Dishes & Menu &nbsp; > &nbsp; Edit Dish";

        const customizationContainer = editDishForm.querySelector(
          ".customization-container"
        );
        displayNewItem(workingDish.sideItems, customizationContainer);
      }, 800);
    }
  });
});

// // Manage Add Item Form
const editItemForm = document.getElementById("edit-item-form");
const editItemsBackBtn = editItemForm.querySelector(
  ".create-form-header .back-button"
);
editItemsBackBtn.addEventListener("click", () => {
  if (previousCategoryPage == "create-dish") {
    clearShowClass(dishesSubPages);
    createDishForm.classList.add("show");

    currentPage = "create-dish-form";

    let titleSpan = document.getElementById("page-title");
    titleSpan.innerHTML = "Dishes & Menu &nbsp; > &nbsp; Create Dish";
  } else if (previousCategoryPage == "edit-dish") {
    clearShowClass(dishesSubPages);
    editDishForm.classList.add("show");

    currentPage = "edit-dish-form";

    let titleSpan = document.getElementById("page-title");
    titleSpan.innerHTML = "Dishes & Menu &nbsp; > &nbsp; Edit Dish";
  }
});

const editItemFormSelectCategoryInput =
  editItemForm.querySelector("#menu-category4");
const editItemFormSelectCategoryBtn = editItemForm.querySelector(
  "#menu-category4 > button"
);

editItemFormSelectCategoryInput.addEventListener("click", () => {
  if (previousCategoryPage == "create-dish") {
    selectItemCategoryModal(newDish.sideItems).then((category) => {
      if (category) {
        editItemFormSelectCategoryBtn.textContent = category;
        editItemFormSelectCategoryInput.classList.add("selected");
      } else {
      }
    });
  } else if (previousCategoryPage == "edit-dish") {
    selectItemCategoryModal(workingDish.sideItems).then((category) => {
      if (category) {
        editItemFormSelectCategoryBtn.textContent = category;
        editItemFormSelectCategoryInput.classList.add("selected");
      } else {
      }
    });
  }
});

const editItemsPublishBtns = editItemForm.querySelectorAll(".publish-button");
editItemsPublishBtns.forEach((button) => {
  button.addEventListener("click", () => {
    const formData = gatherFormData(4, editItemForm);

    createAlert("item published", "./assets/icons/filled-check.svg", "green-4");

    if (previousCategoryPage == "create-dish") {
      newDish.sideItems.forEach((item) => {
        if (item.name == formData.category) {
          item.items.push(formData);
        }
      });

      workingItem = {};

      setTimeout(() => {
        clearForm(4, editItemForm);
        clearShowClass(dishesSubPages);
        createDishForm.classList.add("show");

        let titleSpan = document.getElementById("page-title");
        titleSpan.innerHTML = "Dishes & Menu &nbsp; > &nbsp; Create Dish";

        currentPage = "create-dish-form";

        const customizationContainer = createDishForm.querySelector(
          ".customization-container"
        );
        displayNewItem(newDish.sideItems, customizationContainer);
      }, 800);
    } else if (previousCategoryPage == "edit-dish") {
      workingDish.sideItems.forEach((item) => {
        if (item.name == formData.category) {
          item.items.push(formData);
        }
      });

      workingItem = {};

      setTimeout(() => {
        clearShowClass(dishesSubPages);
        editDishForm.classList.add("show");

        currentPage = "edit-dish-form";

        let titleSpan = document.getElementById("page-title");
        titleSpan.innerHTML = "Dishes & Menu &nbsp; > &nbsp; Edit Dish";

        const customizationContainer = editDishForm.querySelector(
          ".customization-container"
        );
        displayNewItem(workingDish.sideItems, customizationContainer);
      }, 800);
    }
  });
});

function displayNewItem(data, container) {
  const customizationContainer = container.querySelector(
    ".customization-body .items-container"
  );
  customizationContainer.innerHTML = "";
  const items = data ? data.flatMap((category) => category.items) : [];
  if (items.length > 0) {
    container.classList.remove("empty");
    populateCustomizationSection(data, customizationContainer);
  } else {
    container.classList.add("empty");
  }
}

// Function to populate the menu table
const createMenuButtons = document.querySelectorAll(
  "#dishes .dishes-header .create-button"
);
createMenuButtons[0].addEventListener("click", () => {
  newMenuCategoryModal().then(async (category) => {
    if (category) {
      const dateTime = new Date();
      let newCategory = {
        id: category.id,
        name: category.name,
        type: category.type,
        dateCreated: dateTime,
        availability: true,
        status: "enabled",
        dishes: [],
      };
      try {
        menuData.categories.push(newCategory);

        let updatedData = {
          categories: menuData.categories,
        };
        await updateIfHasValue(
          "menus",
          menuData.id,
          "businessID",
          restaurantID,
          updatedData
        );
        populateMenuCategoryTable(menuData.categories);
        populateInfoCards();
        populateDishesInfoCard();
      } catch (error) {
        createAlert(
          "couldn't create new categoryr",
          "./assets/icons/bin.svg",
          "red-5"
        );
      }
    } else {
    }
  });
});

// select Menu Category Modal
const selectMenuCategoryModal = (data) => {
  return new Promise((resolve) => {
    const modal = existingModal.cloneNode(true);
    modal.id = "select-menu-category-modal";
    modal.classList.add("category-modal", "lined-modal");

    modal.innerHTML = `
      <div class="modal-heading">
        <p>
          <span>Select Menu Category</span>
        </p>
        <button type="button" class="close-button">
          <img
            src="./assets/icons/close.svg"
            alt="close icon"
            class="close-icon"
          />
        </button>
      </div>
      <div class="modal-body">
        <div class="search-section">
          <div class="search-container" id="select-category-search">
            <input
              type="text"
              placeholder="Search"
            />
            <svg
              width="20"
              height="20"
              viewBox="0 0 24 24"
              fill="none"
              xmlns="http://www.w3.org/2000/svg"
            >
              <path
                d="M21.7959 20.2041L17.3437 15.75C18.6787 14.0104 19.3019 11.8282 19.087 9.64606C18.8722 7.46389 17.8353 5.44515 16.1867 3.99936C14.5382 2.55356 12.4014 1.78898 10.2098 1.8607C8.01829 1.93243 5.93607 2.83509 4.38558 4.38558C2.83509 5.93607 1.93243 8.01829 1.8607 10.2098C1.78898 12.4014 2.55356 14.5382 3.99936 16.1867C5.44515 17.8353 7.46389 18.8722 9.64606 19.087C11.8282 19.3019 14.0104 18.6787 15.75 17.3437L20.2059 21.8006C20.3106 21.9053 20.4348 21.9883 20.5715 22.0449C20.7083 22.1015 20.8548 22.1307 21.0028 22.1307C21.1508 22.1307 21.2973 22.1015 21.4341 22.0449C21.5708 21.9883 21.695 21.9053 21.7997 21.8006C21.9043 21.696 21.9873 21.5717 22.044 21.435C22.1006 21.2983 22.1298 21.1517 22.1298 21.0037C22.1298 20.8557 22.1006 20.7092 22.044 20.5725C21.9873 20.4357 21.9043 20.3115 21.7997 20.2069L21.7959 20.2041ZM4.12499 10.5C4.12499 9.23914 4.49888 8.0066 5.19938 6.95823C5.89987 5.90987 6.89551 5.09277 8.06039 4.61026C9.22527 4.12775 10.5071 4.00151 11.7437 4.24749C12.9803 4.49347 14.1162 5.10063 15.0078 5.99219C15.8994 6.88375 16.5065 8.01966 16.7525 9.25629C16.9985 10.4929 16.8722 11.7747 16.3897 12.9396C15.9072 14.1045 15.0901 15.1001 14.0418 15.8006C12.9934 16.5011 11.7608 16.875 10.5 16.875C8.80977 16.8733 7.18927 16.201 5.99411 15.0059C4.79894 13.8107 4.12673 12.1902 4.12499 10.5Z"
                fill="currentColor"
                fill-opacity="0.6"
              />
            </svg>
          </div>
          <button id="add-category">
            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M19.375 10C19.375 10.2984 19.2565 10.5845 19.0455 10.7955C18.8345 11.0065 18.5484 11.125 18.25 11.125H11.125V18.25C11.125 18.5484 11.0065 18.8345 10.7955 19.0455C10.5845 19.2565 10.2984 19.375 10 19.375C9.70163 19.375 9.41548 19.2565 9.2045 19.0455C8.99353 18.8345 8.875 18.5484 8.875 18.25V11.125H1.75C1.45163 11.125 1.16548 11.0065 0.954505 10.7955C0.743526 10.5845 0.625 10.2984 0.625 10C0.625 9.70163 0.743526 9.41548 0.954505 9.2045C1.16548 8.99353 1.45163 8.875 1.75 8.875H8.875V1.75C8.875 1.45163 8.99353 1.16548 9.2045 0.954505C9.41548 0.743526 9.70163 0.625 10 0.625C10.2984 0.625 10.5845 0.743526 10.7955 0.954505C11.0065 1.16548 11.125 1.45163 11.125 1.75V8.875H18.25C18.5484 8.875 18.8345 8.99353 19.0455 9.2045C19.2565 9.41548 19.375 9.70163 19.375 10Z" fill="#FF0828"/>
            </svg>
          </button>
        </div>
        <ul class="select-category-list">
          <template id="select-category-template">
            <li class="draggable-item">
              <div>
                <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M16.9173 8.04438L10.8057 10.4894L15.1379 16.0591C15.2293 16.1756 15.2969 16.309 15.3366 16.4517C15.3763 16.5944 15.3875 16.7435 15.3694 16.8905C15.3514 17.0375 15.3045 17.1795 15.2315 17.3083C15.1584 17.4372 15.0606 17.5503 14.9438 17.6413C14.8269 17.7323 14.6932 17.7992 14.5503 17.8384C14.4075 17.8776 14.2583 17.8882 14.1114 17.8696C13.9645 17.8509 13.8227 17.8035 13.6941 17.7299C13.5656 17.6564 13.4528 17.5582 13.3623 17.4409L9.00011 11.8328L4.63792 17.4409C4.45423 17.6751 4.18523 17.8269 3.88984 17.8632C3.59445 17.8994 3.29673 17.8171 3.06187 17.6343C2.82701 17.4516 2.67414 17.1832 2.63673 16.8879C2.59933 16.5927 2.68044 16.2946 2.8623 16.0591L7.19449 10.4894L1.08292 8.04438C0.943013 7.99153 0.815045 7.91131 0.706503 7.80841C0.597962 7.70552 0.511026 7.58202 0.45078 7.44513C0.390534 7.30824 0.358188 7.16071 0.355633 7.01118C0.353078 6.86164 0.380366 6.71309 0.4359 6.57422C0.491435 6.43536 0.574101 6.30896 0.679064 6.20242C0.784028 6.09588 0.909181 6.01133 1.0472 5.95373C1.18523 5.89614 1.33335 5.86664 1.48291 5.86696C1.63247 5.86729 1.78046 5.89743 1.91824 5.95563L7.87511 8.33875V1.75C7.87511 1.45163 7.99364 1.16548 8.20462 0.954505C8.41559 0.743526 8.70174 0.625 9.00011 0.625C9.29848 0.625 9.58463 0.743526 9.7956 0.954505C10.0066 1.16548 10.1251 1.45163 10.1251 1.75V8.33875L16.082 5.95563C16.2198 5.89743 16.3678 5.86729 16.5173 5.86696C16.6669 5.86664 16.815 5.89614 16.953 5.95373C17.091 6.01133 17.2162 6.09588 17.3212 6.20242C17.4261 6.30896 17.5088 6.43536 17.5643 6.57422C17.6199 6.71309 17.6471 6.86164 17.6446 7.01118C17.642 7.16071 17.6097 7.30824 17.5494 7.44513C17.4892 7.58202 17.4023 7.70552 17.2937 7.80841C17.1852 7.91131 17.0572 7.99153 16.9173 8.04438Z" fill="#2D2C2C" fill-opacity="0.2"/>
                </svg>
                <span></span>
              </div>
            </li>
          </template>
        </ul>
      </div>
    `;

    main.appendChild(modal);
    modal.showModal();

    const container = modal.querySelector(".select-category-list");

    // Populate the container with elements
    const template = modal.querySelector("#select-category-template");

    function populateContainer(data) {
      container
        .querySelectorAll(":not(template)")
        .forEach((child) => child.remove());

      data.forEach((item) => {
        const clone = template.content.cloneNode(true);
        const nameSpan = clone.querySelector("div span");

        nameSpan.textContent = item.name;

        const listItem = clone.querySelector(".draggable-item");
        listItem.dataset.id = item.id; // Add a unique identifier

        container.appendChild(clone);

        listItem.addEventListener("click", () => {
          modal.close();
          modal.remove();
          resolve(item.name);
        });
      });
    }

    populateContainer(data);
    setupDropdownDelegation(modal);

    const selectCategorySearchInput = modal.querySelector(
      "#select-category-search > input"
    );

    selectCategorySearchInput.addEventListener("input", (event) => {
      const hasValue = event.target.value.trim() !== "";

      if (hasValue) {
        const searchValue = event.target.value.toLowerCase();
        const filteredData = data.filter((item) =>
          item.name.toLowerCase().includes(searchValue)
        );

        populateContainer(filteredData);
      } else {
        container.innerHTML = "";
        populateContainer(data);
      }
    });

    const addCategoryBtn = modal.querySelector("#add-category");
    addCategoryBtn.addEventListener("click", () => {
      newMenuCategoryModal().then(async (category) => {
        if (category) {
          const dateTime = new Date();
          let newCategory = {
            id: category.id,
            name: category.name,
            type: category.type,
            dateCreated: dateTime,
            availability: true,
            status: "enabled",
            dishes: [],
          };
          try {
            menuData.categories.push(newCategory);

            let updatedData = {
              categories: menuData.categories,
            };
            await updateIfHasValue(
              "menus",
              menuData.id,
              "businessID",
              restaurantID,
              updatedData
            );
            populateMenuCategoryTable(menuData.categories);
            populateContainer(menuData.categories);
            populateInfoCards();
            populateDishesInfoCard();
          } catch (error) {
            createAlert(
              "couldn't create new categoryr",
              "./assets/icons/bin.svg",
              "red-5"
            );
          }
        } else {
        }
      });
    });

    const closeButton = modal.querySelector(".close-button");
    closeButton.addEventListener("click", () => {
      modal.close();
      modal.remove();
    });
  });
};

const selectItemCategoryModal = (data) => {
  return new Promise((resolve) => {
    const modal = existingModal.cloneNode(true);
    modal.id = "select-item-category-modal";
    modal.classList.add("category-modal", "lined-modal");

    modal.innerHTML = `
      <div class="modal-heading">
        <p>
          <span>Select Item Category</span>
        </p>
        <button type="button" class="close-button">
          <img
            src="./assets/icons/close.svg"
            alt="close icon"
            class="close-icon"
          />
        </button>
      </div>
      <div class="modal-body">
        <div class="search-section">
          <div class="search-container" id="select-category-search">
            <input
              type="text"
              placeholder="Search"
            />
            <svg
              width="20"
              height="20"
              viewBox="0 0 24 24"
              fill="none"
              xmlns="http://www.w3.org/2000/svg"
            >
              <path
                d="M21.7959 20.2041L17.3437 15.75C18.6787 14.0104 19.3019 11.8282 19.087 9.64606C18.8722 7.46389 17.8353 5.44515 16.1867 3.99936C14.5382 2.55356 12.4014 1.78898 10.2098 1.8607C8.01829 1.93243 5.93607 2.83509 4.38558 4.38558C2.83509 5.93607 1.93243 8.01829 1.8607 10.2098C1.78898 12.4014 2.55356 14.5382 3.99936 16.1867C5.44515 17.8353 7.46389 18.8722 9.64606 19.087C11.8282 19.3019 14.0104 18.6787 15.75 17.3437L20.2059 21.8006C20.3106 21.9053 20.4348 21.9883 20.5715 22.0449C20.7083 22.1015 20.8548 22.1307 21.0028 22.1307C21.1508 22.1307 21.2973 22.1015 21.4341 22.0449C21.5708 21.9883 21.695 21.9053 21.7997 21.8006C21.9043 21.696 21.9873 21.5717 22.044 21.435C22.1006 21.2983 22.1298 21.1517 22.1298 21.0037C22.1298 20.8557 22.1006 20.7092 22.044 20.5725C21.9873 20.4357 21.9043 20.3115 21.7997 20.2069L21.7959 20.2041ZM4.12499 10.5C4.12499 9.23914 4.49888 8.0066 5.19938 6.95823C5.89987 5.90987 6.89551 5.09277 8.06039 4.61026C9.22527 4.12775 10.5071 4.00151 11.7437 4.24749C12.9803 4.49347 14.1162 5.10063 15.0078 5.99219C15.8994 6.88375 16.5065 8.01966 16.7525 9.25629C16.9985 10.4929 16.8722 11.7747 16.3897 12.9396C15.9072 14.1045 15.0901 15.1001 14.0418 15.8006C12.9934 16.5011 11.7608 16.875 10.5 16.875C8.80977 16.8733 7.18927 16.201 5.99411 15.0059C4.79894 13.8107 4.12673 12.1902 4.12499 10.5Z"
                fill="currentColor"
                fill-opacity="0.6"
              />
            </svg>
          </div>
          <button id="add-item-category">
            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M19.375 10C19.375 10.2984 19.2565 10.5845 19.0455 10.7955C18.8345 11.0065 18.5484 11.125 18.25 11.125H11.125V18.25C11.125 18.5484 11.0065 18.8345 10.7955 19.0455C10.5845 19.2565 10.2984 19.375 10 19.375C9.70163 19.375 9.41548 19.2565 9.2045 19.0455C8.99353 18.8345 8.875 18.5484 8.875 18.25V11.125H1.75C1.45163 11.125 1.16548 11.0065 0.954505 10.7955C0.743526 10.5845 0.625 10.2984 0.625 10C0.625 9.70163 0.743526 9.41548 0.954505 9.2045C1.16548 8.99353 1.45163 8.875 1.75 8.875H8.875V1.75C8.875 1.45163 8.99353 1.16548 9.2045 0.954505C9.41548 0.743526 9.70163 0.625 10 0.625C10.2984 0.625 10.5845 0.743526 10.7955 0.954505C11.0065 1.16548 11.125 1.45163 11.125 1.75V8.875H18.25C18.5484 8.875 18.8345 8.99353 19.0455 9.2045C19.2565 9.41548 19.375 9.70163 19.375 10Z" fill="#FF0828"/>
            </svg>
          </button>
        </div>
        <ul class="select-category-list">
          <template id="select-category-template">
            <li class="draggable-item">
              <div>
                <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M16.9173 8.04438L10.8057 10.4894L15.1379 16.0591C15.2293 16.1756 15.2969 16.309 15.3366 16.4517C15.3763 16.5944 15.3875 16.7435 15.3694 16.8905C15.3514 17.0375 15.3045 17.1795 15.2315 17.3083C15.1584 17.4372 15.0606 17.5503 14.9438 17.6413C14.8269 17.7323 14.6932 17.7992 14.5503 17.8384C14.4075 17.8776 14.2583 17.8882 14.1114 17.8696C13.9645 17.8509 13.8227 17.8035 13.6941 17.7299C13.5656 17.6564 13.4528 17.5582 13.3623 17.4409L9.00011 11.8328L4.63792 17.4409C4.45423 17.6751 4.18523 17.8269 3.88984 17.8632C3.59445 17.8994 3.29673 17.8171 3.06187 17.6343C2.82701 17.4516 2.67414 17.1832 2.63673 16.8879C2.59933 16.5927 2.68044 16.2946 2.8623 16.0591L7.19449 10.4894L1.08292 8.04438C0.943013 7.99153 0.815045 7.91131 0.706503 7.80841C0.597962 7.70552 0.511026 7.58202 0.45078 7.44513C0.390534 7.30824 0.358188 7.16071 0.355633 7.01118C0.353078 6.86164 0.380366 6.71309 0.4359 6.57422C0.491435 6.43536 0.574101 6.30896 0.679064 6.20242C0.784028 6.09588 0.909181 6.01133 1.0472 5.95373C1.18523 5.89614 1.33335 5.86664 1.48291 5.86696C1.63247 5.86729 1.78046 5.89743 1.91824 5.95563L7.87511 8.33875V1.75C7.87511 1.45163 7.99364 1.16548 8.20462 0.954505C8.41559 0.743526 8.70174 0.625 9.00011 0.625C9.29848 0.625 9.58463 0.743526 9.7956 0.954505C10.0066 1.16548 10.1251 1.45163 10.1251 1.75V8.33875L16.082 5.95563C16.2198 5.89743 16.3678 5.86729 16.5173 5.86696C16.6669 5.86664 16.815 5.89614 16.953 5.95373C17.091 6.01133 17.2162 6.09588 17.3212 6.20242C17.4261 6.30896 17.5088 6.43536 17.5643 6.57422C17.6199 6.71309 17.6471 6.86164 17.6446 7.01118C17.642 7.16071 17.6097 7.30824 17.5494 7.44513C17.4892 7.58202 17.4023 7.70552 17.2937 7.80841C17.1852 7.91131 17.0572 7.99153 16.9173 8.04438Z" fill="#2D2C2C" fill-opacity="0.2"/>
                </svg>
                <span></span>
              </div>
            </li>
          </template>
        </ul>
      </div>
    `;

    main.appendChild(modal);
    modal.showModal();

    const container = modal.querySelector(".select-category-list");

    // Populate the container with elements
    const template = modal.querySelector("#select-category-template");

    function populateContainer(data) {
      container
        .querySelectorAll(":not(template)")
        .forEach((child) => child.remove());

      data?.forEach((item) => {
        const clone = template.content.cloneNode(true);
        const nameSpan = clone.querySelector("div span");

        nameSpan.textContent = item.name;

        const listItem = clone.querySelector(".draggable-item");
        listItem.dataset.id = item.id; // Add a unique identifier

        container.appendChild(clone);

        listItem.addEventListener("click", () => {
          modal.close();
          modal.remove();
          resolve(item.name);
        });
      });
    }

    populateContainer(data);
    setupDropdownDelegation(modal);

    const selectCategorySearchInput = modal.querySelector(
      "#select-category-search > input"
    );

    selectCategorySearchInput.addEventListener("input", (event) => {
      const hasValue = event.target.value.trim() !== "";

      if (hasValue) {
        const searchValue = event.target.value.toLowerCase();
        const filteredData = data?.filter((item) =>
          item.name.toLowerCase().includes(searchValue)
        );

        populateContainer(filteredData);
      } else {
        container.innerHTML = "";
        populateContainer(data);
      }
    });

    const addCategoryBtn = modal.querySelector("#add-item-category");
    addCategoryBtn.addEventListener("click", () => {
      newItemCategoryModal().then((category) => {
        if (category) {
          let newCategory = {
            id: category.id,
            name: category.name,
            type: category.type,
            noOfSides: category.noOfSides,
            required: category.required,
            status: "enabled",
            dishId: null,
            items: [],
          };
          console.log(newDish);
          if (previousCategoryPage == "create-dish") {
            newCategory.dishId = newDish.id;
            newDish.sideItems = [];
            newDish.sideItems.push(newCategory);
            populateContainer(newDish.sideItems);
          } else if (previousCategoryPage == "edit-dish") {
            newCategory.dishId = workingDish.id;
            workingDish.sideItems = [];
            workingDish.sideItems.push(newCategory);
            populateContainer(workingDish.sideItems);
          }

          createAlert(
            "menu list updated",
            "./assets/icons/filled-check.svg",
            "green-4"
          );
        } else {
        }
      });
    });

    const closeButton = modal.querySelector(".close-button");
    closeButton.addEventListener("click", () => {
      modal.close();
      modal.remove();
    });
  });
};

// Open Rearrange Category modal
const rearrangeMenuBtn = document.querySelector(
  "#dishes .categorized-container table thead > tr > th:nth-child(8) .static-dropdown .rearrange-button"
);
rearrangeMenuBtn.addEventListener("click", async () => {
  rearrangeCategoryModal(menuData.categories).then(async (rearrangedData) => {
    if (rearrangedData) {
      try {
        menuData.categories = rearrangedData;
        let updatedData = {
          categories: menuData.categories,
        };
        await updateIfHasValue(
          "menus",
          menuData.id,
          "businessID",
          restaurantID,
          updatedData
        );
        populateMenuCategoryTable(menuData.categories);
        populateCardsByCategory(menuData.categories);
      } catch (error) {
        createAlert(
          "couldn't edit category",
          "./assets/icons/bin.svg",
          "red-5"
        );
      }
    } else {
      console.log("Modal closed without saving.");
    }
  });
});

// Make menu categories available or unavailable
const makeAvailableBtn = document.querySelector(
  "#dishes .categorized-container table thead th:nth-child(8) .static-dropdown .make-available-button"
);
makeAvailableBtn.addEventListener("click", () => {
  menuData.categories.forEach(async (item) => {
    const updatedCategories = menuData.categories.map((obj) =>
      obj.id === item.id ? { ...obj, availability: true } : obj
    );
    menuData.categories = updatedCategories;
    try {
      let updatedData = {
        categories: menuData.categories,
      };
      await updateIfHasValue(
        "menus",
        menuData.id,
        "businessID",
        restaurantID,
        updatedData
      );
      populateMenuCategoryTable(menuData);
      dishesMenuInfo.innerHTML = menuData.categories.length;
      populateCardsByCategory(menuData.categories);
    } catch (error) {
      createAlert("couldn't edit category", "./assets/icons/bin.svg", "red-5");
    }
  });
});

const makeUnavailableBtn = document.querySelector(
  "#dishes .categorized-container table thead > tr > th:nth-child(8) .static-dropdown .make-unavailable-button"
);
makeUnavailableBtn.addEventListener("click", () => {
  menuData.categories.forEach(async (item) => {
    const updatedCategories = menuData.categories.map((obj) =>
      obj.id === item.id ? { ...obj, availability: false } : obj
    );
    menuData.categories = updatedCategories;
    try {
      let updatedData = {
        categories: menuData.categories,
      };
      await updateIfHasValue(
        "menus",
        menuData.id,
        "businessID",
        restaurantID,
        updatedData
      );
      populateMenuCategoryTable(menuData.categories);
      populateCardsByCategory(menuData.categories);
    } catch (error) {
      createAlert("couldn't edit category", "./assets/icons/bin.svg", "red-5");
    }
  });
});

//Menu Categories Filters
const enabledFilterBtn = document.querySelector(
  "#dishes .categorized-container table thead th:nth-child(7) .static-dropdown .enabled-filter-button"
);
const disabledFilterBtn = document.querySelector(
  "#dishes .categorized-container table thead th:nth-child(7) .static-dropdown .disabled-filter-button"
);
const clearFilterBtns = document.querySelectorAll(
  "#dishes .categorized-container table thead th:nth-child(7) .static-dropdown .clear-filter-button, #dishes .categorized-container header .select-dropdown .clear-filter-button"
);
const availableFilterBtn = document.querySelector(
  "#dishes .categorized-container header .select-dropdown .dropdown .available-filter-button"
);
const unavailableFilterBtn = document.querySelector(
  "#dishes .categorized-container header .select-dropdown .unavailable-filter-button"
);
const vegetarianFilterBtn = document.querySelector(
  "#dishes .categorized-container header .select-dropdown .vegetarian-filter-button"
);
const nonVegetarianFilterBtn = document.querySelector(
  "#dishes .categorized-container header .select-dropdown .nonvegetarian-filter-button"
);

enabledFilterBtn.addEventListener("click", () => {
  const filteredMenuCategories = menuData.categories.filter(
    (item) => item.status === "enabled"
  );
  populateMenuCategoryTable(filteredMenuCategories);
});
disabledFilterBtn.addEventListener("click", () => {
  const filteredMenuCategories = menuData.categories.filter(
    (item) => item.status === "disabled"
  );
  populateMenuCategoryTable(filteredMenuCategories);
});
availableFilterBtn.addEventListener("click", () => {
  const filteredMenuCategories = menuData.categories.filter(
    (item) => item.availability === true
  );
  console.log("clicked");
  populateMenuCategoryTable(filteredMenuCategories);
});
unavailableFilterBtn.addEventListener("click", () => {
  const filteredMenuCategories = menuData.categories.filter(
    (item) => item.availability === false
  );
  populateMenuCategoryTable(filteredMenuCategories);
});
vegetarianFilterBtn.addEventListener("click", () => {
  const filteredMenuCategories = menuData.categories.filter(
    (item) => item.type === "vegetarian"
  );
  populateMenuCategoryTable(filteredMenuCategories);
});
nonVegetarianFilterBtn.addEventListener("click", () => {
  const filteredMenuCategories = menuData.categories.filter(
    (item) => item.type === "non-vegetarian"
  );
  populateMenuCategoryTable(filteredMenuCategories);
});
clearFilterBtns.forEach((button) => {
  button.addEventListener("click", () => {
    populateMenuCategoryTable(menuData.categories);
  });
});

function populateCustomizationSection(data, container) {
  container.innerHTML = "";
  let counter = 0;

  data?.forEach((category, index) => {
    const customizationContainerId = `customization-category-${category.name}`;
    let customizationContainer = document.getElementById(
      customizationContainerId
    );

    if (!customizationContainer) {
      customizationContainer = document.createElement("div");
      customizationContainer.id = customizationContainerId;
      customizationContainer.classList.add("category-section");

      // Add category header
      const header = document.createElement("div");
      header.classList.add("category-header");
      header.innerHTML = `
              <div>
                <svg
                  width="16"
                  height="16"
                  viewBox="0 0 18 18"
                  fill="none"
                  xmlns="http://www.w3.org/2000/svg"
                >
                  <path
                    d="M8.25 4.5C8.25 5.24168 8.03007 5.96671 7.61801 6.58339C7.20596 7.20007 6.62029 7.68072 5.93506 7.96455C5.24984 8.24838 4.49584 8.32264 3.76841 8.17795C3.04098 8.03325 2.3728 7.6761 1.84835 7.15165C1.3239 6.6272 0.966751 5.95902 0.822057 5.23159C0.677362 4.50416 0.751625 3.75016 1.03545 3.06494C1.31928 2.37972 1.79993 1.79405 2.41661 1.38199C3.0333 0.969935 3.75832 0.750002 4.5 0.750002C5.49456 0.750002 6.44839 1.14509 7.15165 1.84835C7.85491 2.55161 8.25 3.50544 8.25 4.5ZM13.5 8.25C14.2417 8.25 14.9667 8.03007 15.5834 7.61801C16.2001 7.20596 16.6807 6.62029 16.9646 5.93506C17.2484 5.24984 17.3226 4.49584 17.1779 3.76841C17.0333 3.04098 16.6761 2.3728 16.1517 1.84835C15.6272 1.3239 14.959 0.966751 14.2316 0.822057C13.5042 0.677362 12.7502 0.751625 12.0649 1.03545C11.3797 1.31928 10.794 1.79993 10.382 2.41661C9.96993 3.0333 9.75 3.75832 9.75 4.5C9.75 5.49456 10.1451 6.44839 10.8484 7.15165C11.5516 7.85491 12.5054 8.25 13.5 8.25ZM4.5 9.75C3.75832 9.75 3.0333 9.96993 2.41661 10.382C1.79993 10.794 1.31928 11.3797 1.03545 12.0649C0.751625 12.7502 0.677362 13.5042 0.822057 14.2316C0.966751 14.959 1.3239 15.6272 1.84835 16.1517C2.3728 16.6761 3.04098 17.0333 3.76841 17.1779C4.49584 17.3226 5.24984 17.2484 5.93506 16.9646C6.62029 16.6807 7.20596 16.2001 7.61801 15.5834C8.03007 14.9667 8.25 14.2417 8.25 13.5C8.25 12.5054 7.85491 11.5516 7.15165 10.8484C6.44839 10.1451 5.49456 9.75 4.5 9.75ZM13.5 9.75C12.7583 9.75 12.0333 9.96993 11.4166 10.382C10.7999 10.794 10.3193 11.3797 10.0355 12.0649C9.75162 12.7502 9.67736 13.5042 9.82206 14.2316C9.96675 14.959 10.3239 15.6272 10.8484 16.1517C11.3728 16.6761 12.041 17.0333 12.7684 17.1779C13.4958 17.3226 14.2498 17.2484 14.9351 16.9646C15.6203 16.6807 16.206 16.2001 16.618 15.5834C17.0301 14.9667 17.25 14.2417 17.25 13.5C17.25 12.5054 16.8549 11.5516 16.1517 10.8484C15.4484 10.1451 14.4946 9.75 13.5 9.75Z"
                    fill="#2D2C2C"
                    fill-opacity="0.4"
                  />
                </svg>
                <div class="header-info">
                  <span>${category.name}</span>
                  <button class="toggle-button ${
                    category.status === "enabled" ? "enabled" : "disabled"
                  }">
                    <span class="button-text">${category.status}</span>
                    <img
                      src="${
                        category.status === "enabled"
                          ? "./assets/icons/toggle-on.svg"
                          : "./assets/icons/toggle-off.svg"
                      }"
                      alt="toggle-button"
                    />
                  </button>
                </div>
              </div>
              <div class="static-dropdown">
                <button class="dropdown-button">
                  <svg
                    width="18"
                    height="8"
                    viewBox="0 0 28 8"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg"
                  >
                    <path
                      d="M17.5 4C17.5 4.69223 17.2947 5.36892 16.9101 5.9445C16.5256 6.52007 15.9789 6.96867 15.3394 7.23358C14.6999 7.49848 13.9961 7.5678 13.3172 7.43275C12.6383 7.2977 12.0146 6.96436 11.5251 6.47487C11.0356 5.98539 10.7023 5.36175 10.5673 4.68282C10.4322 4.00388 10.5015 3.30015 10.7664 2.66061C11.0313 2.02107 11.4799 1.47444 12.0555 1.08986C12.6311 0.705271 13.3078 0.5 14 0.5C14.9283 0.5 15.8185 0.868749 16.4749 1.52513C17.1313 2.1815 17.5 3.07174 17.5 4ZM4 0.5C3.30777 0.5 2.63108 0.705271 2.05551 1.08986C1.47993 1.47444 1.03133 2.02107 0.766423 2.66061C0.501516 3.30015 0.432205 4.00388 0.567253 4.68282C0.702301 5.36175 1.03564 5.98539 1.52513 6.47487C2.01461 6.96436 2.63825 7.2977 3.31719 7.43275C3.99612 7.5678 4.69985 7.49848 5.33939 7.23358C5.97894 6.96867 6.52556 6.52007 6.91015 5.9445C7.29473 5.36892 7.5 4.69223 7.5 4C7.5 3.07174 7.13125 2.1815 6.47487 1.52513C5.8185 0.868749 4.92826 0.5 4 0.5ZM24 0.5C23.3078 0.5 22.6311 0.705271 22.0555 1.08986C21.4799 1.47444 21.0313 2.02107 20.7664 2.66061C20.5015 3.30015 20.4322 4.00388 20.5673 4.68282C20.7023 5.36175 21.0356 5.98539 21.5251 6.47487C22.0146 6.96436 22.6383 7.2977 23.3172 7.43275C23.9961 7.5678 24.6999 7.49848 25.3394 7.23358C25.9789 6.96867 26.5256 6.52007 26.9101 5.9445C27.2947 5.36892 27.5 4.69223 27.5 4C27.5 3.54037 27.4095 3.08525 27.2336 2.66061C27.0577 2.23597 26.7999 1.85013 26.4749 1.52513C26.1499 1.20012 25.764 0.942313 25.3394 0.766421C24.9148 0.59053 24.4596 0.5 24 0.5Z"
                      fill="#2D2C2C"
                    />
                  </svg>
                </button>
                <div class="dropdown">
                  <div class="dropdown-heading">
                    <span>Action</span>
                  </div>
                  <ul>
                    <li class="edit-category-button">
                      <span>Edit</span>
                    </li>
                    <li class="make-available-button">
                      <span>Make all Items Available</span>
                    </li>
                    <li class="make-unavailable-button">
                      <span>Make all Items Unavailable</span>
                    </li>
                    <li class="rearrange-category-button">
                      <span>Rearrange Item Category</span>
                    </li>
                    <li class="rearrange-items-button">
                      <span>Rearrange Items</span>
                    </li>
                    <li class="delete-button">
                      <span>Delete</span>
                      <svg
                        width="12"
                        height="13"
                        viewBox="0 0 12 13"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          d="M11.5 2H9V1.5C9 1.10218 8.84196 0.720644 8.56066 0.43934C8.27936 0.158035 7.89782 0 7.5 0H4.5C4.10218 0 3.72064 0.158035 3.43934 0.43934C3.15804 0.720644 3 1.10218 3 1.5V2H0.5C0.367392 2 0.240215 2.05268 0.146447 2.14645C0.0526785 2.24021 0 2.36739 0 2.5C0 2.63261 0.0526785 2.75979 0.146447 2.85355C0.240215 2.94732 0.367392 3 0.5 3H1V12C1 12.2652 1.10536 12.5196 1.29289 12.7071C1.48043 12.8946 1.73478 13 2 13H10C10.2652 13 10.5196 12.8946 10.7071 12.7071C10.8946 12.5196 11 12.2652 11 12V3H11.5C11.6326 3 11.7598 2.94732 11.8536 2.85355C11.9473 2.75979 12 2.63261 12 2.5C12 2.36739 11.9473 2.24021 11.8536 2.14645C11.7598 2.05268 11.6326 2 11.5 2ZM5 9.5C5 9.63261 4.94732 9.75979 4.85355 9.85355C4.75979 9.94732 4.63261 10 4.5 10C4.36739 10 4.24021 9.94732 4.14645 9.85355C4.05268 9.75979 4 9.63261 4 9.5V5.5C4 5.36739 4.05268 5.24021 4.14645 5.14645C4.24021 5.05268 4.36739 5 4.5 5C4.63261 5 4.75979 5.05268 4.85355 5.14645C4.94732 5.24021 5 5.36739 5 5.5V9.5ZM8 9.5C8 9.63261 7.94732 9.75979 7.85355 9.85355C7.75979 9.94732 7.63261 10 7.5 10C7.36739 10 7.24021 9.94732 7.14645 9.85355C7.05268 9.75979 7 9.63261 7 9.5V5.5C7 5.36739 7.05268 5.24021 7.14645 5.14645C7.24021 5.05268 7.36739 5 7.5 5C7.63261 5 7.75979 5.05268 7.85355 5.14645C7.94732 5.24021 8 5.36739 8 5.5V9.5ZM8 2H4V1.5C4 1.36739 4.05268 1.24021 4.14645 1.14645C4.24021 1.05268 4.36739 1 4.5 1H7.5C7.63261 1 7.75979 1.05268 7.85355 1.14645C7.94732 1.24021 8 1.36739 8 1.5V2Z"
                          fill="#FF0828"
                        />
                      </svg>
                    </li>
                  </ul>
                </div>
              </div>
          `;
      customizationContainer.appendChild(header);

      const toggleSwitch = header.querySelector(".toggle-button");
      toggleSwitch.addEventListener("click", () => {
        if (category.status == "enabled") {
          const updatedCategories = workingDish.sideItems.map((obj) =>
            obj.id === category.id ? { ...obj, status: "disabled" } : obj
          );
          workingDish.sideItems = updatedCategories;
          populateCustomizationSection(workingDish.sideItems, container);
        } else if (category.status == "disabled") {
          const updatedCategories = workingDish.sideItems.map((obj) =>
            obj.id === category.id ? { ...obj, status: "enabled" } : obj
          );
          workingDish.sideItems = updatedCategories;
          populateCustomizationSection(workingDish.sideItems, container);
        }
      });

      const body = document.createElement("div");
      body.classList.add("category-body");

      customizationContainer.appendChild(body);
      container.appendChild(customizationContainer);

      const editCategoryBtn = header.querySelector(
        ".static-dropdown .edit-category-button"
      );
      editCategoryBtn.addEventListener("click", () => {
        editItemCategoryModal(category).then((newData) => {
          if (newData) {
            const updatedCategories = workingDish.sideItems.map((obj) =>
              obj.id === newData.id ? newData : obj
            );
            workingDish.sideItems = updatedCategories;
            const updatedItems = workingDish.sideItems[index].items.map(
              (item) =>
                item.category === category.name.toLowerCase()
                  ? { ...item, category: newData.name, type: newData.type }
                  : item
            );
            workingDish.sideItems[index].items = updatedItems;
            populateCustomizationSection(workingDish.sideItems, container);
          } else {
          }
        });
      });

      const makeAvailableBtn = header.querySelector(
        ".static-dropdown .make-available-button"
      );
      makeAvailableBtn.addEventListener("click", () => {
        workingDish.sideItems[index].items.forEach((item) => {
          item.status = "enabled";
          populateCustomizationSection(workingDish.sideItems, container);
        });
      });

      const makeUnavailableBtn = header.querySelector(
        ".static-dropdown .make-unavailable-button"
      );
      makeUnavailableBtn.addEventListener("click", () => {
        workingDish.sideItems[index].items.forEach((item) => {
          item.status = "disabled";
          populateCustomizationSection(workingDish.sideItems, container);
        });
      });

      const rearrangeCategoryBtn = header.querySelector(
        ".static-dropdown .rearrange-category-button"
      );
      rearrangeCategoryBtn.addEventListener("click", () => {
        rearrangeItemCategoryModal(workingDish.sideItems).then(
          (rearrangedData) => {
            if (rearrangedData) {
              workingDish.sideItems = rearrangedData;
              populateCustomizationSection(workingDish.sideItems, container);
            } else {
              console.log("Modal closed without saving.");
            }
          }
        );
      });

      const rearrangeItemsBtn = header.querySelector(
        ".static-dropdown .rearrange-items-button"
      );
      rearrangeItemsBtn.addEventListener("click", () => {
        rearrangeItemsModal(
          category.name,
          workingDish.sideItems[index].items
        ).then(async (rearrangedData) => {
          if (rearrangedData) {
            workingDish.sideItems[index].items = rearrangedData;
            populateCustomizationSection(workingDish.sideItems, container);
          } else {
            console.log("Modal closed without saving.");
          }
        });
      });

      const itemDeleteButton = header.querySelector(
        ".static-dropdown .delete-button"
      );
      itemDeleteButton.addEventListener("click", () => {
        console.log("show");
        const existingModal = document.querySelector(".modal-wrapper");
        const modal = existingModal.cloneNode(true);

        const modalAlreadyExists = document.querySelector(
          "#delete-category-modal"
        );
        if (modalAlreadyExists) return;

        modal.id = "delete-category-modal";
        modal.classList.add("confirm-modal", "lined-modal");

        modal.innerHTML = `
          <div class="modal-heading">
            <p>
              <svg width="20" height="22" viewBox="0 0 20 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M18.25 4.5H14.875V3.375C14.875 2.67881 14.5984 2.01113 14.1062 1.51884C13.6139 1.02656 12.9462 0.75 12.25 0.75H7.75C7.05381 0.75 6.38613 1.02656 5.89384 1.51884C5.40156 2.01113 5.125 2.67881 5.125 3.375V4.5H1.75C1.45163 4.5 1.16548 4.61853 0.954505 4.8295C0.743526 5.04048 0.625 5.32663 0.625 5.625C0.625 5.92337 0.743526 6.20952 0.954505 6.4205C1.16548 6.63147 1.45163 6.75 1.75 6.75H2.125V19.5C2.125 19.9973 2.32254 20.4742 2.67417 20.8258C3.02581 21.1775 3.50272 21.375 4 21.375H16C16.4973 21.375 16.9742 21.1775 17.3258 20.8258C17.6775 20.4742 17.875 19.9973 17.875 19.5V6.75H18.25C18.5484 6.75 18.8345 6.63147 19.0455 6.4205C19.2565 6.20952 19.375 5.92337 19.375 5.625C19.375 5.32663 19.2565 5.04048 19.0455 4.8295C18.8345 4.61853 18.5484 4.5 18.25 4.5ZM7.375 3.375C7.375 3.27554 7.41451 3.18016 7.48483 3.10984C7.55516 3.03951 7.65054 3 7.75 3H12.25C12.3495 3 12.4448 3.03951 12.5152 3.10984C12.5855 3.18016 12.625 3.27554 12.625 3.375V4.5H7.375V3.375ZM15.625 19.125H4.375V6.75H15.625V19.125ZM8.875 9.75V15.75C8.875 16.0484 8.75647 16.3345 8.5455 16.5455C8.33452 16.7565 8.04837 16.875 7.75 16.875C7.45163 16.875 7.16548 16.7565 6.9545 16.5455C6.74353 16.3345 6.625 16.0484 6.625 15.75V9.75C6.625 9.45163 6.74353 9.16548 6.9545 8.9545C7.16548 8.74353 7.45163 8.625 7.75 8.625C8.04837 8.625 8.33452 8.74353 8.5455 8.9545C8.75647 9.16548 8.875 9.45163 8.875 9.75ZM13.375 9.75V15.75C13.375 16.0484 13.2565 16.3345 13.0455 16.5455C12.8345 16.7565 12.5484 16.875 12.25 16.875C11.9516 16.875 11.6655 16.7565 11.4545 16.5455C11.2435 16.3345 11.125 16.0484 11.125 15.75V9.75C11.125 9.45163 11.2435 9.16548 11.4545 8.9545C11.6655 8.74353 11.9516 8.625 12.25 8.625C12.5484 8.625 12.8345 8.74353 13.0455 8.9545C13.2565 9.16548 13.375 9.45163 13.375 9.75Z" fill="#2D2C2C"/>
              </svg>
              <span>Delete?</span>
            </p>
          </div>
          <div class="modal-body">
            <span>Oh No!👊🏾</span>
            <h2>Are you sure you want this item deleted? </h2>
            <div>
              <svg width="35" height="35" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M19.9173 10.5444L13.8057 12.9894L18.1379 18.5591C18.2293 18.6756 18.2969 18.809 18.3366 18.9517C18.3763 19.0944 18.3875 19.2435 18.3694 19.3905C18.3514 19.5375 18.3045 19.6795 18.2315 19.8083C18.1584 19.9372 18.0606 20.0503 17.9438 20.1413C17.8269 20.2323 17.6932 20.2992 17.5503 20.3384C17.4075 20.3776 17.2583 20.3882 17.1114 20.3696C16.9645 20.3509 16.8227 20.3035 16.6941 20.2299C16.5656 20.1564 16.4528 20.0582 16.3623 19.9409L12.0001 14.3328L7.63792 19.9409C7.45423 20.1751 7.18523 20.3269 6.88984 20.3632C6.59445 20.3994 6.29673 20.3171 6.06187 20.1343C5.82701 19.9516 5.67414 19.6832 5.63673 19.3879C5.59933 19.0927 5.68044 18.7946 5.8623 18.5591L10.1945 12.9894L4.08292 10.5444C3.94301 10.4915 3.81504 10.4113 3.7065 10.3084C3.59796 10.2055 3.51103 10.082 3.45078 9.94513C3.39053 9.80824 3.35819 9.66071 3.35563 9.51118C3.35308 9.36164 3.38037 9.21309 3.4359 9.07422C3.49143 8.93536 3.5741 8.80896 3.67906 8.70242C3.78403 8.59588 3.90918 8.51133 4.0472 8.45373C4.18523 8.39614 4.33335 8.36664 4.48291 8.36696C4.63247 8.36729 4.78046 8.39743 4.91824 8.45563L10.8751 10.8388V4.25C10.8751 3.95163 10.9936 3.66548 11.2046 3.4545C11.4156 3.24353 11.7017 3.125 12.0001 3.125C12.2985 3.125 12.5846 3.24353 12.7956 3.4545C13.0066 3.66548 13.1251 3.95163 13.1251 4.25V10.8388L19.082 8.45563C19.2198 8.39743 19.3678 8.36729 19.5173 8.36696C19.6669 8.36664 19.815 8.39614 19.953 8.45373C20.091 8.51133 20.2162 8.59588 20.3212 8.70242C20.4261 8.80896 20.5088 8.93536 20.5643 9.07422C20.6199 9.21309 20.6471 9.36164 20.6446 9.51118C20.642 9.66071 20.6097 9.80824 20.5494 9.94513C20.4892 10.082 20.4023 10.2055 20.2937 10.3084C20.1852 10.4113 20.0572 10.4915 19.9173 10.5444Z" fill="white"/>
              </svg>
              <p>
                Deleting a category will remove all dishes in the category.
              </p>
            </div>
            <p class="button-section">
            <button id="confirm-delete">
              Delete
            </button>
            <button id="cancel-button">Cancel</button>
            </p>
          </div>
        `;
        main.appendChild(modal);
        modal.showModal();

        const cancelButton = modal.querySelector("#cancel-button");
        cancelButton.addEventListener("click", () => {
          modal.close();
          modal.remove();
        });

        const deleteButton = modal.querySelector("#confirm-delete");
        deleteButton.addEventListener("click", () => {
          workingDish.sideItems = workingDish.sideItems.filter(
            (item) => item.id !== category.id
          );

          createAlert("deleted", "./assets/icons/bin.svg", "red-5");
          setTimeout(() => {
            modal.close();
            modal.remove();
            setTimeout(() => {
              populateCustomizationSection(workingDish.sideItems, container);
            }, 500);
          }, 800);
        });
      });
    }

    const body = customizationContainer.querySelector(".category-body");
    // Populate items in the category
    category.items.forEach((item, index) => {
      counter++;
      const card = document.createElement("div");
      card.classList.add("category-card");
      if (item.status === "disabled") {
        card.classList.add("disabled");
      }
      card.innerHTML = `
        <span class="id">
          ${counter}
        </span>
        <div class="content">
          <div>
            <img
              src="${
                item.image ? item.image : "./assets/images/squared-logo.png"
              }"
              alt="food"
            />
            <p>
              <span class="title">${item.name}</span>
              <span class="price"> $${item.price.regularPrice}</span>
            </p>
          </div>
          <button class="delete-button">
            <svg width="20" height="22" viewBox="0 0 20 22" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M18.25 4.33984H14.875V3.21484C14.875 2.51865 14.5984 1.85097 14.1062 1.35869C13.6139 0.866405 12.9462 0.589844 12.25 0.589844H7.75C7.05381 0.589844 6.38613 0.866405 5.89384 1.35869C5.40156 1.85097 5.125 2.51865 5.125 3.21484V4.33984H1.75C1.45163 4.33984 1.16548 4.45837 0.954505 4.66935C0.743526 4.88033 0.625 5.16648 0.625 5.46484C0.625 5.76321 0.743526 6.04936 0.954505 6.26034C1.16548 6.47132 1.45163 6.58984 1.75 6.58984H2.125V19.3398C2.125 19.8371 2.32254 20.314 2.67417 20.6657C3.02581 21.0173 3.50272 21.2148 4 21.2148H16C16.4973 21.2148 16.9742 21.0173 17.3258 20.6657C17.6775 20.314 17.875 19.8371 17.875 19.3398V6.58984H18.25C18.5484 6.58984 18.8345 6.47132 19.0455 6.26034C19.2565 6.04936 19.375 5.76321 19.375 5.46484C19.375 5.16648 19.2565 4.88033 19.0455 4.66935C18.8345 4.45837 18.5484 4.33984 18.25 4.33984ZM7.375 3.21484C7.375 3.11539 7.41451 3.02 7.48483 2.94968C7.55516 2.87935 7.65054 2.83984 7.75 2.83984H12.25C12.3495 2.83984 12.4448 2.87935 12.5152 2.94968C12.5855 3.02 12.625 3.11539 12.625 3.21484V4.33984H7.375V3.21484ZM15.625 18.9648H4.375V6.58984H15.625V18.9648ZM8.875 9.58984V15.5898C8.875 15.8882 8.75647 16.1744 8.5455 16.3853C8.33452 16.5963 8.04837 16.7148 7.75 16.7148C7.45163 16.7148 7.16548 16.5963 6.9545 16.3853C6.74353 16.1744 6.625 15.8882 6.625 15.5898V9.58984C6.625 9.29148 6.74353 9.00533 6.9545 8.79435C7.16548 8.58337 7.45163 8.46484 7.75 8.46484C8.04837 8.46484 8.33452 8.58337 8.5455 8.79435C8.75647 9.00533 8.875 9.29148 8.875 9.58984ZM13.375 9.58984V15.5898C13.375 15.8882 13.2565 16.1744 13.0455 16.3853C12.8345 16.5963 12.5484 16.7148 12.25 16.7148C11.9516 16.7148 11.6655 16.5963 11.4545 16.3853C11.2435 16.1744 11.125 15.8882 11.125 15.5898V9.58984C11.125 9.29148 11.2435 9.00533 11.4545 8.79435C11.6655 8.58337 11.9516 8.46484 12.25 8.46484C12.5484 8.46484 12.8345 8.58337 13.0455 8.79435C13.2565 9.00533 13.375 9.29148 13.375 9.58984Z" fill="#FF0828"/>
            </svg>
          </button>
        </div>
        <button class="toggle-button ${
          item.status === "enabled" ? "enabled" : "disabled"
        }">
          <span class="button-text">${
            item.status === "enabled" ? "Enabled" : "Disabled"
          }</span>
          <img
            src="${
              item.status === "enabled"
                ? "./assets/icons/toggle-on.svg"
                : "./assets/icons/toggle-off.svg"
            }"
            alt="toggle-button"
          />
        </button>
    `;

      body.appendChild(card);

      const toggleSwitch = card.querySelector(".toggle-button");
      toggleSwitch.addEventListener("click", () => {
        if (item.status == "enabled") {
          category.items = category.items.map((obj) =>
            obj.id === category.id ? { ...obj, status: "disabled" } : obj
          );
          populateCustomizationSection(workingDish.sideItems, container);
        } else if (item.status == "disabled") {
          category.items = category.items.map((obj) =>
            obj.id === category.id ? { ...obj, status: "enabled" } : obj
          );
          populateCustomizationSection(workingDish.sideItems, container);
        }
      });

      const itemName = card.querySelector(".content .title");
      itemName.addEventListener("click", () => {
        previousCategoryPage = "edit-dish";
        populateForm(4, editItemForm, item);
      });
    });
  });
}

const customizationSearchButtons = document.querySelectorAll(
  ".search-container, .customization-search-button"
);
customizationSearchButtons.forEach((item) => {
  item.addEventListener("click", () => {
    let searchModal = document.getElementById("search-modal");
    searchModal.showModal();
    let searchModalCloseBtn = searchModal.querySelector(
      ".modal-heading .close-button"
    );
    searchModalCloseBtn.addEventListener("click", () => {
      searchModal.close();
    });
    customizationSearch = true;
  });
});

const editFormSelectCategoryInput =
  editDishForm.querySelector("#menu-category2");
const editFormSelectCategoryBtn = editDishForm.querySelector(
  "#menu-category2 > button"
);

editFormSelectCategoryBtn.addEventListener("click", () => {
  selectMenuCategoryModal(menuData.categories).then((category) => {
    if (category) {
      editFormSelectCategoryBtn.textContent = category;
      editFormSelectCategoryInput.classList.add("selected");
    } else {
    }
  });
});

const editFormNewCategoryBtns =
  editDishForm.querySelectorAll(".new-category-btn");

editFormNewCategoryBtns.forEach((button) => {
  button.addEventListener("click", () => {
    newItemCategoryModal().then((category) => {
      if (category) {
        let newCategory = {
          id: category.id,
          name: category.name,
          type: category.type,
          noOfSides: category.noOfSides,
          required: category.required,
          status: "enabled",
          items: [],
        };
        newSideItems.push(newCategory);

        createAlert(
          "menu list updated",
          "./assets/icons/filled-check.svg",
          "green-4"
        );
      } else {
      }
    });
  });
});

const editBackButton = editDishForm.querySelector(".back-button");
editBackButton.addEventListener("click", () => {
  if (previousPage == "categorized") {
    categorizedDishes.classList.add("show");
    uncategorizedDishes.classList.remove("show");
    editDishForm.classList.remove("show");

    currentPage = "categorized";

    let titleSpan = document.getElementById("page-title");
    titleSpan.innerHTML = "Dishes & Menu";
  } else if (previousPage == "uncategorized") {
    uncategorizedDishes.classList.add("show");
    categorizedDishes.classList.remove("show");
    editDishForm.classList.remove("show");

    currentPage = "uncategorized";

    let titleSpan = document.getElementById("page-title");
    titleSpan.innerHTML = "Dishes & Menu &nbsp; > &nbsp; Uncategorized Dish";
  }
});

const editDishAddItemButtons = editDishForm.querySelectorAll(".add-items-btn");
editDishAddItemButtons.forEach((button) => {
  button.addEventListener("click", () => {
    previousCategoryPage = "edit-dish";
    currentPage = "add-item-form";

    clearShowClass(dishesSubPages);
    addItemForm.classList.add("show");
    editDishForm.classList.remove("show");

    const dataID = generateUniqueId("sideItem");
    workingItem = {
      id: dataID,
    };

    let titleSpan = document.getElementById("page-title");
    titleSpan.innerHTML = "Dishes & Menu &nbsp; > &nbsp; Add Item";
  });
});

const editFormPublishBtns = editDishForm.querySelectorAll(".publish-button");
editFormPublishBtns.forEach((button) => {
  button.addEventListener("click", async () => {
    const formData = gatherFormData(2, editDishForm);
    formData.sideItems = workingDish.sideItems;
    formData.id = workingDish.id;

    workingDish = {};

    menuData.categories.forEach((category) => {
      category.dishes = category.dishes.filter(
        (dish) => dish.id !== formData.id
      );
    });

    if (formData.category) {
      menuData.categories.forEach((item) => {
        if (item.name.toLowerCase() == formData.category) {
          formData.categoryId = item.id;
          item.dishes.push(formData);
        }
      });
      try {
        let updatedData = {
          categories: menuData.categories,
        };
        await updateIfHasValue(
          "menus",
          menuData.id,
          "businessID",
          restaurantID,
          updatedData
        );
        populateCardsByCategory(menuData.categories);
        populateInfoCards();
        populateDishesInfoCard();
      } catch (error) {
        createAlert(
          "couldn't create new categoryr",
          "./assets/icons/bin.svg",
          "red-5"
        );
      }
    } else {
      menuData.uncategorizedItems.push(formData);
      try {
        let updatedData = {
          categories: menuData.categories,
        };
        await updateIfHasValue(
          "menus",
          menuData.id,
          "businessID",
          restaurantID,
          updatedData
        );
        populateUncategorizedContainer(menuData.categories);
        populateInfoCards();
        populateDishesInfoCard();
      } catch (error) {
        createAlert(
          "couldn't create new categoryr",
          "./assets/icons/bin.svg",
          "red-5"
        );
      }
    }

    setTimeout(() => {
      createAlert(
        "menu list updated",
        "./assets/icons/filled-check.svg",
        "green-4"
      );
      setTimeout(() => {
        workingDish = {};
        clearForm("2", editDishForm);
        if (previousPage == "categorized") {
          categorizedDishes.classList.add("show");
          uncategorizedDishes.classList.remove("show");
          editDishForm.classList.remove("show");

          currentPage = "categorized";

          let titleSpan = document.getElementById("page-title");
          titleSpan.innerHTML = "Dishes & Menu";
        } else if (previousPage == "uncategorized") {
          uncategorizedDishes.classList.add("show");
          categorizedDishes.classList.remove("show");
          editDishForm.classList.remove("show");

          currentPage = "uncategorized";

          let titleSpan = document.getElementById("page-title");
          titleSpan.innerHTML =
            "Dishes & Menu &nbsp; > &nbsp; Uncategorized Dish";
        }
      }, 500);
    }, 800);
  });
});

function populateForm(id, form, data) {
  if (id == 2) {
    clearShowClass(dishesSubPages);
    editDishForm.classList.add("show");

    currentPage = "edit-dish-form";

    let titleSpan = document.getElementById("page-title");
    titleSpan.innerHTML = "Dishes & Menu &nbsp; > &nbsp; Edit Dish";

    workingDish = data;

    if (data.category == "uncategorized") {
      editDishForm.querySelector("#menu-category2 > button").textContent = "";
      editFormSelectCategoryInput.classList.remove("selected");
    } else {
      editDishForm.querySelector("#menu-category2 > button").textContent =
        data.category;
      editFormSelectCategoryInput.classList.add("selected");
    }

    const customizationSection = editDishForm.querySelector(
      ".customization-container"
    );
    const customizationContainer =
      customizationSection.querySelector(".items-container");

    if (workingDish.sideItems.length === 0) {
      customizationSection.classList.add("empty");
    } else {
      populateCustomizationSection(
        workingDish.sideItems,
        customizationContainer
      );
      customizationSection.classList.remove("empty");
    }
  } else if (id == 4) {
    clearShowClass(dishesSubPages);
    editItemForm.classList.add("show");

    currentPage = "edit-item-form";

    let titleSpan = document.getElementById("page-title");
    titleSpan.innerHTML = "Dishes & Menu &nbsp; > &nbsp; Edit Item";

    workingItem = data;

    editItemForm.querySelector("#menu-category4 > button").textContent =
      data.category;
    editItemFormSelectCategoryInput.classList.add("selected");

    console.log(data);
  }

  form.querySelector(`#dish-name${id}`).value = data.name;
  form.querySelector(`#dish-type${id} button`).textContent = data.type;
  form.querySelector(`#regular-price${id}`).value = data.price.regularPrice;
  form.querySelector(`#discounted-price${id}`).value =
    data.price.discountedPrice;
  form.querySelector(`#available-qnty${id}`).value =
    data.dailyAvailableQuantity;
  form.querySelector(`#preparation-cost${id}`).value =
    data.dailyPreparationCost;
  form.querySelector(`#item-weight${id}`).value = data.weight;
  form.querySelector(`#description${id}`).value = data.description;
  form.querySelector(`.current-image img`).src = data.image
    ? data.image
    : "./assets/images/squared-logo.png";

  const toggleButton = form.querySelector(".create-form-header .toggle-button");
  if (data.status == "enabled") {
    toggleButton.classList.add("enabled");
    toggleButton.classList.remove("disabled");
    toggleButton.querySelector("span").textContent = "Enabled";
    toggleButton.querySelector("img").src = "./assets/icons/toggle-on.svg";
  } else {
    toggleButton.classList.add("disabled");
    toggleButton.classList.remove("enabled");
    toggleButton.querySelector("span").textContent = "Disabled";
    toggleButton.querySelector("img").src = "./assets/icons/toggle-off.svg";
  }

  function populateAvailability(data) {
    const availability = data.availability;
    form
      .querySelectorAll(".availability-section .available-day")
      .forEach((dayElement) => {
        const day = dayElement.dataset.day;

        if (availability[day]) {
          // If the day exists in the availability object
          const time = availability[day];
          const checkbox = dayElement.querySelector('input[type="checkbox"]');
          const dropdownContainer =
            dayElement.querySelector(".floating-controls");
          const timeSpan = dayElement.querySelector(
            ".floating-controls > button"
          );

          // Mark the checkbox as checked
          checkbox.checked = true;

          // Update styles and content for the day
          dropdownContainer.classList.add("selected");
          dayElement.classList.add("selected");
          timeSpan.textContent = time.replace("&", " & ");
        } else {
          // If the day does not exist in availability, reset the element
          const checkbox = dayElement.querySelector('input[type="checkbox"]');
          const dropdownContainer =
            dayElement.querySelector(".floating-controls");
          const timeSpan = dayElement.querySelector(
            ".floating-controls > button"
          );

          // Uncheck the checkbox and reset content
          checkbox.checked = false;
          // dropdownContainer.classList.add("selected");
          dayElement.classList.remove("selected");
          // timeSpan.textContent = "None";
        }
      });
  }
  populateAvailability(data);
}

// Get form data
function gatherFormData(id, form) {
  const category = form
    .querySelector(`#menu-category${id} > button`)
    .textContent.trim();
  const name = form.querySelector(`#dish-name${id}`).value;
  const type = form.querySelector(`#dish-type${id} button`).textContent.trim();
  const weight = form.querySelector(`#item-weight${id}`).value;
  const description = form.querySelector(`#description${id}`).value;
  const price = form.querySelector(`#regular-price${id}`).value;
  const discountedPrice = form.querySelector(`#discounted-price${id}`).value;
  const preparationCost = form.querySelector(`#preparation-cost${id}`).value;
  const availableQty = form.querySelector(`#available-qnty${id}`).value;
  const image = form.querySelector(".current-image img").src;
  const status = form
    .querySelector(".create-form-header .toggle-button")
    .textContent.trim();

  const dayData = {};
  let atLeastOneChecked = false;

  // Collect day-specific data
  form.querySelectorAll(".available-day").forEach((dayDiv) => {
    const day = dayDiv.dataset.day;
    const checkbox = dayDiv.querySelector("label input");
    const timeInput = dayDiv
      .querySelector(".floating-controls.dropdown button")
      .textContent.trim();

    if (checkbox.checked) {
      atLeastOneChecked = true;
      dayData[day] = timeInput || "none";
    }
  });

  // Validate at least one checkbox
  if (!atLeastOneChecked) {
    alert("Please select at least one day.");
    return;
  }

  if (id == 3 || id == 4) {
    if (
      !category.trim() ||
      !name.trim() ||
      !type.trim() ||
      !price.trim() ||
      !discountedPrice.trim() ||
      !availableQty.trim() ||
      !description.trim()
    ) {
      createAlert(
        "fill all required fields",
        "./assets/icons/filled-check.svg",
        "red-5"
      );
    } else {
      const formData = {
        id: null,
        name: name,
        description: description,
        price: {
          regularPrice: price,
          discountedPrice: discountedPrice,
        },
        image: image,
        status: status.toLowerCase(),
        category: category,
        categoryId: null,
        sideItems: [],
        type: type,
        dailyAvailableQuantity: availableQty,
        dailyPreparationCost: preparationCost,
        weight: weight,
        availability: dayData,
      };

      return formData;
    }
  } else {
    if (
      !name.trim() ||
      !type.trim() ||
      !price.trim() ||
      !discountedPrice.trim() ||
      !availableQty.trim() ||
      !description.trim()
    ) {
      createAlert(
        "fill all required fields",
        "./assets/icons/filled-check.svg",
        "red-5"
      );
    } else {
      let dataID;
      if (id == "") {
        dataID = generateUniqueId("dish");
      } else if (id == 2) {
        dataID = workingDish.id;
      } else if (id == 3) {
        dataID = generateUniqueId("sideItem");
      } else if (id == 4) {
        dataID = workingItem.id;
      }
      const formData = {
        id: dataID,
        name: name,
        description: description,
        price: {
          regularPrice: price,
          discountedPrice: discountedPrice,
        },
        image: image,
        status: status.toLowerCase(),
        category: category.toLowerCase(),
        categoryId: null,
        sideItems: [],
        type: type.toLowerCase(),
        dailyAvailableQuantity: availableQty,
        dailyPreparationCost: preparationCost,
        weight: weight,
        availability: dayData,
      };

      return formData;
    }
  }
}

// Clear form
function clearForm(id, form) {
  form.querySelector(`#menu-category${id} > button`).textContent = "";
  form.querySelector(`#menu-category${id}`).classList.remove("selected");
  form.querySelector(`#dish-name${id}`).value = "";
  form.querySelector(`#dish-type${id} button`).textContent = "";
  form.querySelector(`#regular-price${id}`).value = "";
  form.querySelector(`#available-qnty${id}`).value = "";
  form.querySelector(`#preparation-cost${id}`).value = "";
  form.querySelector(`#item-weight${id}`).value = "";
  form.querySelector(`#discounted-price${id}`).value = "";
  form.querySelector(`#description${id}`).value = "";
  form.querySelector(`.current-image img`).value = "";

  const toggleButton = form.querySelector(".create-form-header .toggle-button");
  toggleButton.classList.add("enabled");
  toggleButton.classList.remove("disabled");
  toggleButton.querySelector("span").textContent = "Enabled";
  toggleButton.querySelector("img").src = "./assets/icons/toggle-on.svg";

  // Uncheck available days
  form.querySelectorAll(".available-day").forEach((dayDiv) => {
    const checkbox = dayDiv.querySelector("label input");
    const dropdownContainer = dayDiv.querySelector(
      ".floating-controls.dropdown"
    );
    let timeInput = dayDiv.querySelector(
      ".floating-controls.dropdown > button"
    );

    if (checkbox.checked) {
      checkbox.checked = false;
      timeInput.textContent = "";
      dropdownContainer.classList.remove("selected");
    }
  });

  if (id == "") {
    const customizationContainer = form.querySelector(
      ".customization-container"
    );
    displayNewItem(newDish.sideItems, customizationContainer);
  }
  if (id == 2) {
    const customizationContainer = form.querySelector(
      ".customization-container"
    );
    displayNewItem(workingDish.sideItems, customizationContainer);
  }
}

// Search feature
const menuSearchInput = document.querySelector("#menu-search > input");
const searchModalBody = document.querySelector("#search-modal .modal-body");
const searchResultContainer = searchModalBody.querySelector(".search-result");

let filteredResults;

menuSearchInput.addEventListener("input", (event) => {
  const hasValue = event.target.value.trim() !== "";

  if (hasValue) {
    searchModalBody.classList.remove("empty");
    const searchValue = event.target.value.toLowerCase();

    if (activePage === "menu") {
      filteredResults = menuData.categories.filter((category) =>
        category.name.toLowerCase().includes(searchValue.toLowerCase())
      );
      searchResultContainer.innerHTML = "";

      if (filteredResults.length === 0) {
        searchResultContainer.innerHTML = "<p>No results found</p>";
      } else {
        filteredResults.forEach((category, index) => {
          const card = document.createElement("div");
          card.classList.add("menu-item-card");

          function populateCard(category) {
            card.innerHTML = `
              <div>
                <span class="menu-item-title">${category.name}</span>
                <div class="menu-item-type">
                  <svg width="24" height="24" fill="none">
                    <use xlink:href="${
                      menuTypeImages[category.type].icon
                    }"></use>
                  </svg>
                  <span>${menuTypeImages[category.type].name}</span>
                </div>
              </div>
              <button class="menu-item-button ${
                category.status == "enabled" ? "enabled" : "disabled"
              }">
                <img
                  src="${
                    category.status == "enabled"
                      ? "./assets/icons/toggle-on.svg"
                      : "./assets/icons/toggle-off.svg"
                  }"
                  alt="toggle-button"
                />
              </button>
            `;
          }

          populateCard(category);
          searchResultContainer.appendChild(card);

          const toggleSwitch = card.querySelector(".menu-item-button");
          toggleSwitch.addEventListener("click", async () => {
            console.log("clicked");

            if (category.status === "enabled") {
              category.status = "disabled";
            } else {
              category.status = "enabled";
            }

            const img = toggleSwitch.querySelector("img");
            img.src =
              category.status === "enabled"
                ? "./assets/icons/toggle-on.svg"
                : "./assets/icons/toggle-off.svg";
            toggleSwitch.classList.toggle(
              "enabled",
              category.status === "enabled"
            );
            toggleSwitch.classList.toggle(
              "disabled",
              category.status !== "enabled"
            );

            try {
              let updatedData = {
                categories: menuData.categories,
              };
              console.log(
                await updateIfHasValue(
                  "menus",
                  menuData.id,
                  "businessID",
                  restaurantID,
                  updatedData
                )
              );
              populateMenuCategoryTable(menuData);
              populateCardsByCategory(menuData.categories);
            } catch (error) {
              createAlert(
                "couldn't edit category",
                "./assets/icons/bin.svg",
                "red-5"
              );
            }
          });
        });
      }
    } else if (activePage === "dishes" && currentPage == "categorized") {
      const filteredResults = menuData.categories
        .flatMap((category) => category.dishes)
        .filter((dish) =>
          dish.name.toLowerCase().includes(searchValue.toLowerCase())
        );

      searchResultContainer.innerHTML = "";

      if (filteredResults.length === 0) {
        searchResultContainer.innerHTML = "<p>No results found</p>";
      } else {
        searchResultContainer.classList.add("dishes");
        filteredResults.forEach((item) => {
          const card = document.createElement("div");
          card.classList.add("dish-item-card");

          if (item.status === "disabled") {
            card.classList.add("disabled");
          }
          const populateCard = () => {
            card.innerHTML = `
                <div class="content">
                  <p>
                    <span class="title">
                      ${item.name}
                    </span>
                    <span class="price"> $${item.price.regularPrice}</span>
                  </p>
                  <button class="toggle-button ${
                    item.status === "enabled" ? "enabled" : "disabled"
                  }">
                    <span class="button-text">${
                      item.status === "enabled" ? "Enabled" : "Disabled"
                    }</span>
                    <img
                      src="${
                        item.status === "enabled"
                          ? "./assets/icons/toggle-on.svg"
                          : "./assets/icons/toggle-off.svg"
                      }"
                      alt="toggle-button"
                    />
                  </button>
                </div>
                <div class="image">
                  <img src="${item.image}" alt="food" />
                  <div class="count">
                    <img src="./assets/icons/pencil.svg" alt="pencil-icon/>
                    <span class="count">${item.id}</span>
                  </div>
                </div>
            `;
          };
          populateCard(item);

          searchResultContainer.appendChild(card);

          const toggleSwitch = card.querySelector(".toggle-button");
          toggleSwitch.addEventListener("click", async () => {
            if (item.status === "enabled") {
              item.status = "disabled";
            } else {
              item.status = "enabled";
            }

            const img = toggleSwitch.querySelector("img");
            img.src =
              item.status === "enabled"
                ? "./assets/icons/toggle-on.svg"
                : "./assets/icons/toggle-off.svg";
            const buttonText = toggleSwitch.querySelector("span");

            buttonText.textContent =
              item.status === "enabled" ? "Enabled" : "Disabled";

            toggleSwitch.classList.toggle("enabled", item.status === "enabled");
            toggleSwitch.classList.toggle(
              "disabled",
              item.status !== "enabled"
            );

            try {
              let updatedData = {
                categories: menuData.categories,
              };
              console.log(
                await updateIfHasValue(
                  "menus",
                  menuData.id,
                  "businessID",
                  restaurantID,
                  updatedData
                )
              );
              populateMenuCategoryTable(menuData.categories);
              populateCardsByCategory(menuData.categories);
            } catch (error) {
              createAlert(
                "couldn't edit category",
                "./assets/icons/bin.svg",
                "red-5"
              );
            }
          });
        });
      }
    } else if (activePage === "dishes" && currentPage == "uncategorized") {
      const filteredResults = menuData.uncategorizedItems.filter((dish) =>
        dish.name.toLowerCase().includes(searchValue.toLowerCase())
      );

      searchResultContainer.innerHTML = "";

      if (filteredResults.length === 0) {
        searchResultContainer.innerHTML = "<p>No results found</p>";
      } else {
        searchResultContainer.classList.add("dishes");
        filteredResults.forEach((item) => {
          const card = document.createElement("div");
          card.classList.add("dish-item-card");

          if (item.status === "disabled") {
            card.classList.add("disabled");
          }
          const populateCard = () => {
            card.innerHTML = `
                <div class="content">
                  <p>
                    <span class="title">
                      ${item.name}
                    </span>
                    <span class="price"> $${item.price.regularPrice}</span>
                  </p>
                  <button class="toggle-button ${
                    item.status === "enabled" ? "enabled" : "disabled"
                  }">
                    <span class="button-text">${
                      item.status === "enabled" ? "Enabled" : "Disabled"
                    }</span>
                    <img
                      src="${
                        item.status === "enabled"
                          ? "./assets/icons/toggle-on.svg"
                          : "./assets/icons/toggle-off.svg"
                      }"
                      alt="toggle-button"
                    />
                  </button>
                </div>
                <div class="image">
                  <img src="${item.image}" alt="food" />
                  <div class="count">
                    <img src="./assets/icons/pencil.svg" alt="pencil-icon/>
                    <span class="count">${item.id}</span>
                  </div>
                </div>
            `;
          };
          populateCard(item);

          searchResultContainer.appendChild(card);

          const toggleSwitch = card.querySelector(".toggle-button");
          toggleSwitch.addEventListener("click", async () => {
            if (item.status === "enabled") {
              item.status = "disabled";
            } else {
              item.status = "enabled";
            }

            const img = toggleSwitch.querySelector("img");
            img.src =
              item.status === "enabled"
                ? "./assets/icons/toggle-on.svg"
                : "./assets/icons/toggle-off.svg";
            const buttonText = toggleSwitch.querySelector("span");

            buttonText.textContent =
              item.status === "enabled" ? "Enabled" : "Disabled";

            toggleSwitch.classList.toggle("enabled", item.status === "enabled");
            toggleSwitch.classList.toggle(
              "disabled",
              item.status !== "enabled"
            );

            try {
              let updatedData = {
                uncategorizedItems: menuData.uncategorizedItems,
              };
              console.log(
                await updateIfHasValue(
                  "menus",
                  menuData.id,
                  "businessID",
                  restaurantID,
                  updatedData
                )
              );
              populateUncategorizedContainer(menuData.uncategorizedItems);
            } catch (error) {
              createAlert(
                "couldn't edit category",
                "./assets/icons/bin.svg",
                "red-5"
              );
            }
          });
        });
      }
    } else if (
      customizationSearch === true &&
      currentPage == "edit-dish-form"
    ) {
      console.log("check");
      filteredResults = workingDish.sideItems.filter((item) =>
        item.name.toLowerCase().includes(searchValue.toLowerCase())
      );
      searchResultContainer.innerHTML = "";

      if (filteredResults.length === 0) {
        searchResultContainer.innerHTML = "<p>No results found</p>";
      } else {
        filteredResults.forEach((item, index) => {
          const card = document.createElement("div");
          card.classList.add("menu-item-card");

          function populateCard(item) {
            card.innerHTML = `
              <div>
                <span class="menu-item-title">${v.name}</span>
                <div class="menu-item-type">
                  <svg width="24" height="24" fill="none">
                    <use xlink:href="${menuTypeImages[item.type].icon}"></use>
                  </svg>
                  <span>${menuTypeImages[item.type].name}</span>
                </div>
              </div>
              <button class="menu-item-button ${
                item.status == "enabled" ? "enabled" : "disabled"
              }">
                <img
                  src="${
                    item.status == "enabled"
                      ? "./assets/icons/toggle-on.svg"
                      : "./assets/icons/toggle-off.svg"
                  }"
                  alt="toggle-button"
                />
              </button>
            `;
          }

          populateCard(item);
          searchResultContainer.appendChild(card);

          const toggleSwitch = card.querySelector(".menu-item-button");
          toggleSwitch.addEventListener("click", async () => {
            if (item.status === "enabled") {
              item.status = "disabled";
            } else {
              item.status = "enabled";
            }

            const img = toggleSwitch.querySelector("img");
            img.src =
              item.status === "enabled"
                ? "./assets/icons/toggle-on.svg"
                : "./assets/icons/toggle-off.svg";
            toggleSwitch.classList.toggle("enabled", item.status === "enabled");
            toggleSwitch.classList.toggle(
              "disabled",
              item.status !== "enabled"
            );
          });
        });
      }
    }
  } else {
    searchModalBody.classList.add("empty");
    searchResultContainer.innerHTML = "";
  }
});
