document.addEventListener('DOMContentLoaded', function() {
    // Get all the dropdown buttons and dropdown contents
    var dropdownButtons = document.querySelectorAll('.dropdown-btn');
    var dropdownContents = document.querySelectorAll('.dropdown-content');

    // Add click event listeners to each button
    dropdownButtons.forEach(function(btn, index) {
        btn.addEventListener('click', function(event) {
            // Toggle the current dropdown
            var currentDropdown = dropdownContents[index];
            
            currentDropdown.style.display = currentDropdown.style.display === 'block' ? 'none' : 'block';

            

            // Close other dropdowns
            dropdownContents.forEach(function(content, idx) {
                if (idx !== index) content.style.display = 'none';
            });

            // Prevent the click from closing itself
            event.stopPropagation();
        });
    });

    // Close all dropdowns if clicked outside
    // window.onclick = function() {
    //     dropdownContents.forEach(function(content) {
    //         content.style.display = 'none';
    //     });
    // };

    window.onclick = function(event) {
        var isSearchInput = event.target.matches('.form-control-search');
        if (!isSearchInput) {
            dropdownContents.forEach(function(content) {
                content.style.display = 'none';
            });
        }
    };
});

if (document.querySelectorAll(".onSubmitForm")) {
    document.querySelectorAll(".onSubmitForm").forEach(item => {
        item.addEventListener('submit', function (e) {
            e.preventDefault()
        })
    })
}

//Morning Open
if (document.querySelector('.morning-open-btn')) {
    document.querySelector('.morning-open-btn').addEventListener("click", function (e) {
        e.preventDefault()
    
        document.querySelector('#morning-open').classList.remove('d-none')

        let timeSlot_1 = document.querySelector("#timeSlots1").children

        Array.from(timeSlot_1).forEach(time => {
            time.addEventListener('click', function () {
                document.querySelector('.morning-open-btn').textContent = time.textContent

                document.querySelector('#morning-open').classList.add('d-none')
            })
        })
    })
}

if (document.querySelector('.evening-open-btn')) {
    document.querySelector('.evening-open-btn').addEventListener("click", function (e) {
        e.preventDefault()
    
        document.querySelector('#evening-open').classList.remove('d-none')

        let timeSlot_3 = document.querySelector("#timeSlots3").children

        Array.from(timeSlot_3).forEach(time => {
            time.addEventListener('click', function () {
                document.querySelector('.evening-open-btn').textContent = time.textContent

                document.querySelector('#evening-open').classList.add('d-none')
            })
        })
    })
}

// if (document.querySelector(".close-morning-open")) {
//     document.querySelector(".close-morning-open").addEventListener('click', function (e) {
//         e.preventDefault()
    
//         document.querySelector('#evening-open').classList.add('d-none')
//     })
// }


//Morning Close

if (document.querySelector('.morning-close-btn')) {
    document.querySelector('.morning-close-btn').addEventListener("click", function (e) {
        e.preventDefault()
    
        document.querySelector('#morning-close').classList.remove('d-none')

        let timeSlot_2 = document.querySelector("#timeSlots2").children

         Array.from(timeSlot_2).forEach(time => {
            time.addEventListener('click', function () {
                document.querySelector('.morning-close-btn').textContent = time.textContent

                document.querySelector('#morning-close').classList.add('d-none')
            })
        })
    })
}

if (document.querySelector('.evening-close-btn')) {
    document.querySelector('.evening-close-btn').addEventListener("click", function (e) {
        e.preventDefault()
    
        document.querySelector('#evening-close').classList.remove('d-none')

        let timeSlot_4 = document.querySelector("#timeSlots4").children

         Array.from(timeSlot_4).forEach(time => {
            time.addEventListener('click', function () {
                document.querySelector('.evening-close-btn').textContent = time.textContent

                document.querySelector('#evening-close').classList.add('d-none')
            })
        })
    })
}

// if (document.querySelector(".close-morning-open-2")) {
//     document.querySelector(".close-morning-open-2").addEventListener('click', function (e) {
//         e.preventDefault()
    
//         document.querySelector('#evening-close').classList.add('d-none')
//     })    
// }

//custom Accordion
var acc = document.querySelectorAll(".accordion-arrow");

acc.forEach(function(accordion) {
    accordion.addEventListener("click", function () {
        this.classList.toggle("active");

      const content = accordion.parentElement.parentElement.parentElement.nextElementSibling
      
      if (content.style.display === "block") {
        content.style.display = "none";
      } else {
        content.style.display = "block";
      }


  });
});

window.onload = function() {
    let modal_overlay = document.querySelector(".intro-modal")

    if (modal_overlay) {
        setTimeout(() => {
            modal_overlay.classList.remove("d-none")
            // document.querySelector('body').classList.add('overflow-hidden')
        }, 1000)
    }
}

// document.querySelector(".close-modal").addEventListener("click", function (e) {
//     let modal_overlay = document.querySelector(".intro-modal")
//     modal_overlay.classList.add("d-none")
//     document.querySelector('body').classList.remove('overflow-hidden')
// })

let serial_num_info = document.querySelectorAll(".serial-num-info")
let info_modal = document.querySelector(".info-modal")

serial_num_info.forEach(item => {
    item.addEventListener("click", function (e) {
        info_modal.classList.remove("d-none")
    })
})

let serial_num_info_2 = document.querySelectorAll(".serial-num-info-2")
let info_modal_2 = document.querySelector(".info-modal-2")

serial_num_info_2.forEach(item => {
    item.addEventListener("click", function (e) {
        info_modal_2.classList.remove("d-none")
    })
})

document.querySelectorAll(".x-close").forEach(item => {
    item.addEventListener("click", function (e) {
        e.preventDefault()
        item.parentElement.parentElement.parentElement.parentElement.parentElement.classList.add("d-none")
    })
})

//close sidebar

let close_sidebar = document.querySelector(".close-sidebar-x")
let dashboard_container = document.querySelector(".dashboard-container")
let sidebar = document.querySelector(".sidebar")
let nav_menu = document.querySelector(".nav-menu")

if (close_sidebar) {
    close_sidebar.addEventListener('click', function (e) {
        sidebar.classList.add('d-none');
        nav_menu.classList.remove('d-none');
        dashboard_container.classList.add('no-sidebar');
    })
}

if (nav_menu) {
    nav_menu.addEventListener("click", function (e) {
        sidebar.classList.remove('d-none');
        nav_menu.classList.add('d-none');
        dashboard_container.classList.remove('no-sidebar');
    })
}

//Unblock & Block Delivery

if (document.querySelector(".block-partner")) {
    document.querySelector(".block-partner").addEventListener('click', function (e) {
        document.querySelector(".notification-modal").classList.remove("d-none")
    })
}

if (document.querySelector(".unblock-partner")) {
    document.querySelector(".unblock-partner").addEventListener('click', function (e) {
        document.querySelector(".notification-modal-2").classList.remove("d-none")
    })
}


document.querySelectorAll(".close-modal-2").forEach(item => {
    item.addEventListener("click", function (e) {
        // item.parentElement.parentElement.parentElement.parentElement.classList.add("d-none")

        document.querySelector(".notification-modal").classList.add("d-none")
    })
})

document.querySelectorAll(".close-modal-3").forEach(item => {
    item.addEventListener("click", function (e) {
        // item.parentElement.parentElement.parentElement.parentElement.classList.add("d-none")

        document.querySelector(".notification-modal-2").classList.add("d-none")
    })
})

if (document.querySelector(".block-btn")) {
    document.querySelector(".block-btn").addEventListener("click", function (e) {
        document.querySelector(".block-partner").classList.add("d-none")
        document.querySelector(".notification-modal").classList.add("d-none")
        document.querySelector(".unblock-partner").classList.remove("d-none")
    })
}

if (document.querySelector(".unblock-btn")) {
    document.querySelector(".unblock-btn").addEventListener("click", function (e) {
        document.querySelector(".unblock-partner").classList.add("d-none")
        document.querySelector(".notification-modal-2").classList.add("d-none")
        document.querySelector(".block-partner").classList.remove("d-none")
    })
}

//Unblock & Block Customer

if (document.querySelector(".block-customer")) {
    document.querySelector(".block-customer").addEventListener('click', function (e) {
        document.querySelector(".notification-modal-3").classList.remove("d-none")
    })
}

if (document.querySelector(".unblock-customer")) {
    document.querySelector(".unblock-customer").addEventListener('click', function (e) {
        document.querySelector(".notification-modal-4").classList.remove("d-none")
    })
}

document.querySelectorAll(".close-modal-4").forEach(item => {
    item.addEventListener("click", function (e) {
        // item.parentElement.parentElement.parentElement.parentElement.classList.add("d-none")

        document.querySelector(".notification-modal-3").classList.add("d-none")
    })
})

document.querySelectorAll(".close-modal-5").forEach(item => {
    item.addEventListener("click", function (e) {
        // item.parentElement.parentElement.parentElement.parentElement.classList.add("d-none")

        document.querySelector(".notification-modal-4").classList.add("d-none")
    })
})

if (document.querySelector(".block-btn-2")) {
    document.querySelector(".block-btn-2").addEventListener("click", function (e) {
        document.querySelector(".block-customer").classList.add("d-none")
        document.querySelector(".notification-modal-3").classList.add("d-none")
        document.querySelector(".unblock-customer").classList.remove("d-none")
    })
}

if (document.querySelector(".unblock-btn-3")) {
    document.querySelector(".unblock-btn-3").addEventListener("click", function (e) {
        document.querySelector(".unblock-customer").classList.add("d-none")
        document.querySelector(".notification-modal-4").classList.add("d-none")
        document.querySelector(".block-customer").classList.remove("d-none")
    })
}

//Reply

document.querySelectorAll(".reply-btn").forEach(reply => {
    reply.addEventListener("click", function (e) {
        reply.parentElement.parentElement.nextElementSibling.classList.remove("d-none")
        reply.classList.add("d-none")
        reply.parentElement.parentElement.parentElement.parentElement.classList.add('border-1')
        console.log(reply.parentElement.parentElement.parentElement.parentElement)
    })
})

// document.querySelectorAll(".reply-btn").forEach(reply => {
//     reply.addEventListener("click", function (e) {
//         document.querySelectorAll(".reply-content").forEach(content_reply => { 
//             content_reply.classList.remove("d-none")
//             reply.classList.add("d-none")
//             content_reply.parentElement.parentElement.classList.add('border-1', 'overflow-hidden')
//         })
//     })
// })


document.querySelectorAll(".close-reply").forEach(item => {
    item.addEventListener("click", function (e) {
        item.parentElement.parentElement.parentElement.parentElement.classList.remove('border-1')
        item.parentElement.parentElement.classList.add("d-none")

        item.parentElement.parentElement.parentElement.children[0].children[1].lastElementChild.classList.remove('d-none')
    })
})


document.querySelectorAll(".comment-arrow").forEach(arrow => {
    arrow.addEventListener("click", function (e) {
        arrow.parentElement.parentElement.parentElement.parentElement.parentElement.classList.toggle('border-1')
    })
})

document.querySelectorAll(".edit-main-comment-btn").forEach(el => {
    el.addEventListener('click', function (e) {
        el.parentElement.parentElement.parentElement.parentElement.nextElementSibling.classList.remove("d-none")

        el.parentElement.parentElement.parentElement.parentElement.classList.add("d-none")
    })
})

document.querySelectorAll(".cancel-comment").forEach(el => {
    el.addEventListener('click', function (e) {
        el.parentElement.classList.add("d-none")

        el.parentElement.previousElementSibling.classList.remove("d-none")
    })
})


document.querySelectorAll(".show-rider").forEach(rider => {
    rider.addEventListener('click', function (e) {
        document.querySelector(".delivery-person-profile").classList.remove("d-none")
    })
})

document.querySelectorAll(".show-customer").forEach(customer => {
    customer.addEventListener('click', function (e) {
        document.querySelector(".customer-person-profile").classList.remove("d-none")
    })
})

document.querySelectorAll(".close-modal-x").forEach(x => {
    x.addEventListener('click', function (e) {
        x.parentElement.parentElement.parentElement.parentElement.classList.add("d-none")
    })
})

if (document.querySelector(".edit-icon")) {
    document.querySelector(".edit-icon").addEventListener("click", function (e) {
        document.querySelector(".profile-modal-avatar").classList.remove("d-none")
    })
}

if (document.querySelector(".approved-crop")) {
    document.querySelector(".approved-crop").addEventListener("click", function (e) {
        document.querySelectorAll(".upload-main").forEach(item => {
            item.classList.remove("d-none")
        })

        document.querySelectorAll(".upload-main-x").forEach(item_2 => {
            item_2.classList.add("d-none")
        })
    })
}

if (document.querySelector(".replace-img")) {
    document.querySelector(".replace-img").addEventListener('click', function (e) {
        document.querySelectorAll(".upload-main").forEach(item => {
            item.classList.add("d-none")
        })

        document.querySelectorAll(".upload-main-x").forEach(item_2 => {
            item_2.classList.remove("d-none")
        })
    })
}

if (document.querySelector(".show-crop-modal")) {
    document.querySelector(".show-crop-modal").addEventListener("click", function (e) {
        document.querySelector(".crop-banner-modal").classList.remove("d-none")
    })
}


if (document.querySelector(".btn-upload-success")) {
    document.querySelector(".btn-upload-success").addEventListener('click', function () {
        document.querySelector(".crop-banner-modal").classList.add("d-none")
    })
}

if (document.querySelector(".account-profile")) {
    document.querySelector(".account-profile").addEventListener("click", function (e) {
        document.querySelector(".profile-modal").classList.remove("d-none")
    })
}

if (document.querySelector(".update-btn")) {
    document.querySelector(".update-btn").addEventListener("click", function (e) {
        document.querySelector(".toast-success-status").classList.remove("d-none")

        setTimeout(() => {
            document.querySelector(".toast-success-status").classList.add("d-none")
        }, 3000)
    })
}

if (document.querySelector(".view-details-modal")) {
    document.querySelector(".view-details-modal").addEventListener("click", function (e) {
        document.querySelector(".info-modal-2").classList.remove("d-none")
    })
}

if (document.querySelector(".complete-order")) {
    document.querySelector(".complete-order").addEventListener("click", function (e) {
        document.querySelector(".completed-order-status").classList.remove("d-none")
        document.querySelector(".complete-order").parentElement.classList.add("d-none")
        document.querySelector(".completed-sect").classList.remove("d-none")

        setTimeout(() => {
            document.querySelector(".completed-order-status").classList.add("d-none")
        }, 2000)
    })
}

if (document.querySelector(".decline-order")) {
    document.querySelector(".decline-order").addEventListener("click", function (e) {
        document.querySelector(".declined-order-status").classList.remove("d-none")
        document.querySelector(".decline-order").parentElement.classList.add("d-none")
        document.querySelector(".declined-sect").classList.remove("d-none")

        setTimeout(() => {
            document.querySelector(".declined-order-status").classList.add("d-none")
        }, 2000)
    })
}

if (document.querySelector(".decline-prepared-order")) {
    document.querySelector(".decline-prepared-order").addEventListener("click", function (e) {
        document.querySelector(".declined-order-status").classList.remove("d-none")
        document.querySelector(".prepared-sect").classList.add("d-none")
        document.querySelector(".declined-sect").classList.remove("d-none")

        setTimeout(() => {
            document.querySelector(".declined-order-status").classList.add("d-none")
        }, 2000)
    })
}


if (document.querySelector(".accept-order")) {
    document.querySelector(".accept-order").addEventListener("click", function (e) {
        document.querySelector(".completed-order-status").classList.remove("d-none")
        document.querySelector(".prepared-sect").classList.remove("d-none")
        document.querySelector(".btn-options").classList.add("d-none")

        setTimeout(() => {
            document.querySelector(".completed-order-status").classList.add("d-none")
        }, 2000)
    })
}


if (document.querySelectorAll(".complete-order-2")) {
    document.querySelectorAll(".complete-order-2").forEach(complete_order => {
        complete_order.addEventListener("click", function (e) {
            document.querySelector(".info-modal-3").classList.remove("d-none")
        })
    })
}

if (document.querySelectorAll(".accept-order-2")) {
    document.querySelectorAll(".accept-order-2").forEach(accept_order => {
        accept_order.addEventListener("click", function (e) {
            document.querySelector(".completed-order-status").classList.remove("d-none")

            setTimeout(() => {
                document.querySelector(".completed-order-status").classList.add("d-none")
            }, 2000)
        })
    })
}

if (document.querySelectorAll(".decline-order-2")) {
    document.querySelectorAll(".decline-order-2").forEach(decline_order => {
        decline_order.addEventListener("click", function (e) {
            document.querySelector(".declined-order-status").classList.remove("d-none")

            setTimeout(() => {
                document.querySelector(".declined-order-status").classList.add("d-none")
            }, 2000)
        })
    })
}


if (document.querySelector(".cancel-decline")) {
    document.querySelector(".cancel-decline").addEventListener("click", function (e) {
        document.querySelector(".info-modal-4").classList.add("d-none")
    })
}

if (document.querySelector(".cancel-decline_2")) {
    document.querySelector(".cancel-decline_2").addEventListener("click", function (e) {
        document.querySelector(".delete-info-modal-4").classList.add("d-none")
    })
}

if (document.querySelector(".decline-order-3")) {
    document.querySelector(".decline-order-3").addEventListener("click", function (e) {
        document.querySelector(".declined-order-status").classList.remove("d-none")
        document.querySelector(".info-modal-4").classList.add("d-none")

        setTimeout(() => {
            document.querySelector(".declined-order-status").classList.add("d-none")
        }, 2000)
    })
}

if (document.querySelectorAll(".decline_refund")) {
    document.querySelectorAll(".decline_refund").forEach(decline_btn => {
        decline_btn.addEventListener('click', function (e) {
            document.querySelector(".info-modal-4").classList.remove("d-none")
        })
    })
}

if (document.querySelectorAll(".delete_dish_menu")) {
     document.querySelectorAll(".delete_dish_menu").forEach(delete_dish => {
        delete_dish.addEventListener('click', function (e) {
            document.querySelector(".delete-info-modal-4").classList.remove("d-none")
        })
    })
}

if (document.querySelectorAll(".track_order")) {
    document.querySelectorAll(".track_order").forEach(track => {
        track.addEventListener('click', function (e) {
            document.querySelector(".info-modal-5").classList.remove("d-none")
        })
    })
}

if (document.querySelector(".track_main_order")) {
    document.querySelector(".track_main_order").addEventListener("click", function (e) {
        document.querySelector(".info-modal-6").classList.remove("d-none")
        document.querySelector(".info-modal-5").classList.add("d-none")
    })

}

if (document.querySelector(".x-close-track")) {
    document.querySelector(".x-close-track").addEventListener("click", function () {
        document.querySelector(".info-modal-6").classList.add("d-none")
    })
}

if (document.querySelector(".get_started")) {
    document.querySelector(".get_started").addEventListener("click", function (e) {
        document.querySelector(".onboarding-modal_start").classList.add("d-none")
        document.querySelector(".onboarding-modal_1").classList.remove("d-none")
    })
}

if (document.querySelector(".btn-continue_1")) {
     document.querySelector(".btn-continue_1").addEventListener("click", function (e) {
        document.querySelector(".onboarding-modal_1").classList.add("d-none")
        document.querySelector(".onboarding-modal_2").classList.remove("d-none")
    })
}

if (document.querySelector(".btn-continue_2")) {
     document.querySelector(".btn-continue_2").addEventListener("click", function (e) {
        document.querySelector(".onboarding-modal_2").classList.add("d-none")
        document.querySelector(".onboarding-modal_3").classList.remove("d-none")
    })
}

if (document.querySelector(".btn-continue_3")) {
     document.querySelector(".btn-continue_3").addEventListener("click", function (e) {
        document.querySelector(".onboarding-modal_3").classList.add("d-none")
        document.querySelector(".onboarding-modal_4").classList.remove("d-none")
    })
}

if (document.querySelector(".btn-continue_4")) {
     document.querySelector(".btn-continue_4").addEventListener("click", function (e) {
        document.querySelector(".onboarding-modal_4").classList.add("d-none")
        document.querySelector(".onboarding-modal_5").classList.remove("d-none")
    })
}

if (document.querySelector(".back-action_1")) {
    document.querySelector(".back-action_1").addEventListener("click", function (e) {
        document.querySelector(".onboarding-modal_1").classList.remove("d-none")
        document.querySelector(".onboarding-modal_2").classList.add("d-none")
    })
}

if (document.querySelector(".back-action_2")) {
    document.querySelector(".back-action_2").addEventListener("click", function (e) {
        document.querySelector(".onboarding-modal_2").classList.remove("d-none")
        document.querySelector(".onboarding-modal_3").classList.add("d-none")
    })
}

if (document.querySelector(".back-action_3")) {
    document.querySelector(".back-action_3").addEventListener("click", function (e) {
        document.querySelector(".onboarding-modal_3").classList.remove("d-none")
        document.querySelector(".onboarding-modal_4").classList.add("d-none")
    })
}

if (document.querySelector(".close-explore")) {
    document.querySelector(".close-explore").addEventListener("click", function (e) {
        document.querySelector(".onboarding-modal_5").classList.add("d-none")
    })
}

// if (document.querySelector(".create_menu")) {
//     document.querySelector(".create_menu").addEventListener('click', function (e) {
//         document.querySelector(".dishes-menu-modal").classList.remove("d-none")
//     })
// }

if (document.querySelectorAll(".create_menu")) {
    document.querySelectorAll(".create_menu").forEach(menu => {
        menu.addEventListener('click', function (e) {
            document.querySelector(".dishes-menu-modal").classList.remove("d-none")
        })
    })
}

if (document.querySelector(".publish_menu")) {
    document.querySelector(".publish_menu").addEventListener("click", function (e) {
        document.querySelector(".completed-menu-status").classList.remove('d-none')
        document.querySelector(".dishes-menu-modal").classList.add("d-none")

        setTimeout(() => {
            document.querySelector(".completed-menu-status").classList.add('d-none')
        }, 2000)
    })
}

if (document.querySelector(".update_menu")) {
    document.querySelector(".update_menu").addEventListener("click", function (e) {
        document.querySelector(".updated-menu-status").classList.remove('d-none')
        document.querySelector(".dishes-menu-modal-edit").classList.add("d-none")

        setTimeout(() => {
            document.querySelector(".updated-menu-status").classList.add('d-none')
        }, 2000)
    })
}

if (document.querySelectorAll(".edit_menu")) {
    document.querySelectorAll(".edit_menu").forEach(item => {
        item.addEventListener("click", function (e) {
            document.querySelector(".dishes-menu-modal-edit").classList.remove("d-none")
        })
    })
}

if (document.querySelector(".delete_menu")) {
    document.querySelector(".delete_menu").addEventListener("click", function (e) {
        document.querySelector(".delete-menu-status").classList.remove('d-none')
        document.querySelector(".info-modal-4").classList.add("d-none")

        setTimeout(() => {
            document.querySelector(".delete-menu-status").classList.add('d-none')
        }, 2000)
    })
}

if (document.querySelector(".delete_menu_2")) {
    document.querySelector(".delete_menu_2").addEventListener("click", function (e) {
        document.querySelector(".delete-menu-status").classList.remove('d-none')
        document.querySelector(".delete-info-modal-4").classList.add("d-none")

        setTimeout(() => {
            document.querySelector(".delete-menu-status").classList.add('d-none')
        }, 2000)
    })
}



// let dropdownMainContainer = document.querySelector(".dropdown-main-container").children

// Array.from(dropdownMainContainer).forEach(item => {
//     item.addEventListener('click', function () {
//        document.querySelector('.dropdown-value').textContent = item.textContent
//     })
// })


let dropdownMainContainer = document.querySelectorAll(".dropdown-main-container")

dropdownMainContainer.forEach(item => {
    Array.from(item.children).forEach(item => {
        item.addEventListener('click', function () {
            item.parentElement.parentElement.parentElement.children[0].children[1].children[0].textContent = item.textContent
        })
    })
})

let checkAll = document.querySelectorAll(".unchecked-icon-all")
let unCheckAll = document.querySelectorAll(".checked-icon-all")
let checkIcon = document.querySelectorAll(".unchecked-icon")
let checked = document.querySelectorAll(".checked-icon")

checkAll.forEach(check => {
    checkIcon.forEach(checkBlank => {
        checked.forEach(checkedItem => {
            unCheckAll.forEach(uncheck => {
                check.addEventListener('click', function (e) {
                    checkBlank.classList.add('d-none')
                    check.classList.add('d-none')
                    checkedItem.classList.remove('d-none')
                    uncheck.classList.remove('d-none')
                })

                uncheck.addEventListener('click', function () {
                    checkBlank.classList.remove('d-none')
                    check.classList.remove('d-none')
                    checkedItem.classList.add('d-none')
                    uncheck.classList.add('d-none')
                })
            })
            
        })
    })
})

document.querySelectorAll(".unchecked-icon").forEach(item => {
    document.querySelectorAll(".checked-icon").forEach(check => {
        item.addEventListener('click', function (e) {
            item.classList.add("d-none")
            item.nextElementSibling.classList.remove('d-none')
        })

        check.addEventListener('click', function (e) {
            check.classList.add("d-none")
            check.previousElementSibling.classList.remove('d-none')
        })
    })
})

// if (document.querySelector(".rearrange-target")) {
//     document.querySelector(".rearrange-target").addEventListener('click', function (e) {
//         document.querySelector(".rearrange-modal").classList.remove("d-none")
//     })
// }

if (document.querySelectorAll(".rearrange-target")) {
    document.querySelectorAll(".rearrange-target").forEach(target => {
        target.addEventListener('click', function () {
            document.querySelector(".rearrange-modal").classList.remove("d-none")
        })
    })
}

if (document.querySelector(".save_arrange")) {
    document.querySelector(".save_arrange").addEventListener("click", function (e) {
        document.querySelector(".updated-menu-status").classList.remove('d-none')
        document.querySelector(".rearrange-modal").classList.add("d-none")

        setTimeout(() => {
            document.querySelector(".updated-menu-status").classList.add('d-none')
        }, 2000)
    })
}

if (document.querySelector(".save_arrange_2")) {
    document.querySelector(".save_arrange_2").addEventListener("click", function (e) {
        document.querySelector(".updated-menu-status").classList.remove('d-none')
        document.querySelector(".rearrange-modal-2").classList.add("d-none")

        setTimeout(() => {
            document.querySelector(".updated-menu-status").classList.add('d-none')
        }, 2000)
    })
}


if (document.querySelector(".search-key")) {
    document.querySelector(".search-key").addEventListener("keyup", function () {
        document.querySelector(".typing-sect").classList.add("d-none")
        document.querySelector(".search-options").classList.remove("d-none")
    })
}

if (document.querySelectorAll(".search-menu")) {
    document.querySelectorAll(".search-menu").forEach(search => {
        search.addEventListener("click", function (e) {
            document.querySelector(".search-menu-modal").classList.remove("d-none")
        })
    })
}

function generateTimeSlots(startHour, endHour, interval) {
    const times = [];
    let currentTime = new Date();
    currentTime.setHours(startHour, 0, 0, 0); // Set start time

    while (currentTime.getHours() < endHour || (currentTime.getHours() === endHour && currentTime.getMinutes() === 0)) {
        let hours = currentTime.getHours();
        let minutes = currentTime.getMinutes().toString().padStart(2, '0');
        let period = hours < 12 ? 'AM' : 'PM';
        
        if (hours === 0) {
            hours = 12; // Convert 0 hour to 12 AM
        } else if (hours > 12) {
            hours -= 12; // Convert to 12-hour format
        }

        hours = hours.toString().padStart(2, '0');
        times.push(`${currentTime.getHours().toString().padStart(2, '0')}:${minutes} ${period}`);
        currentTime.setMinutes(currentTime.getMinutes() + interval); // Increment time by the interval
    }

    return times;
}



//Rearrange Menu

document.addEventListener('DOMContentLoaded', () => {
    // const list = document.getElementById('draggable-list');
    // let draggedItem = null;

    // list.addEventListener('dragstart', (e) => {
    //     if (e.target.classList.contains('dragItem')) {
    //         draggedItem = e.target;
    //         e.target.style.opacity = 0.5;
    //     }
    // });

    // list.addEventListener('dragend', (e) => {
    //     if (e.target.classList.contains('dragItem')) {
    //         e.target.style.opacity = '';
    //     }
    // });

    // list.addEventListener('dragover', (e) => {
    //     e.preventDefault();
    // });

    // list.addEventListener('dragenter', (e) => {
    //     if (e.target.classList.contains('dragItem') && e.target !== draggedItem) {
    //         e.target.style.border = '2px dashed #000';
    //     }
    // });

    // list.addEventListener('dragleave', (e) => {
    //     if (e.target.classList.contains('dragItem')) {
    //         e.target.style.border = '';
    //     }
    // });

    // list.addEventListener('drop', (e) => {
    //     e.preventDefault();
    //     if (e.target.classList.contains('dragItem') && e.target !== draggedItem) {
    //         e.target.style.border = '';
    //         if (isBefore(draggedItem, e.target)) {
    //             list.insertBefore(draggedItem, e.target);
    //         } else {
    //             list.insertBefore(draggedItem, e.target.nextSibling);
    //         }
    //     }
    // });

    const lists = document.querySelectorAll('#draggable-list');
    let draggedItem = null;

    lists.forEach(list => {

        list.addEventListener('dragstart', (e) => {
            if (e.target.classList.contains('dragItem')) {
                draggedItem = e.target;
                e.target.style.opacity = 0.5;
            }
        });

        list.addEventListener('dragend', (e) => {
            if (e.target.classList.contains('dragItem')) {
                e.target.style.opacity = '';
            }
        });

        list.addEventListener('dragover', (e) => {
            e.preventDefault();
        });

        list.addEventListener('dragenter', (e) => {
            if (e.target.classList.contains('dragItem') && e.target !== draggedItem) {
                e.target.style.border = '2px dashed #000';
            }
        });

        list.addEventListener('dragleave', (e) => {
            if (e.target.classList.contains('dragItem')) {
                e.target.style.border = '';
            }
        });

        list.addEventListener('drop', (e) => {
            e.preventDefault();
            if (e.target.classList.contains('dragItem') && e.target !== draggedItem) {
                e.target.style.border = '';
                if (isBefore(draggedItem, e.target)) {
                    list.insertBefore(draggedItem, e.target);
                } else {
                    list.insertBefore(draggedItem, e.target.nextSibling);
                }
            }
        });

        function isBefore(el1, el2) {
            let cur;
            if (el2.parentNode === el1.parentNode) {
                for (cur = el1.previousSibling; cur; cur = cur.previousSibling) {
                    if (cur === el2) return true;
                }
            }
            return false;
        }
    })


    //checkbox
    document.querySelectorAll(".toggle-checkbox").forEach(check => {
        check.addEventListener('change', function () {
            if (check.checked) {
                check.parentElement.parentElement.children[0].textContent = 'Enabled'
                check.parentElement.parentElement.parentElement.parentElement.classList.remove('add-gray')
                console.log(check.parentElement.parentElement.parentElement.parentElement)
                
            } else {
                check.parentElement.parentElement.children[0].textContent = 'Disabled'
                check.parentElement.parentElement.parentElement.parentElement.classList.add('add-gray') 
            }
        })
    })

    //Master CheckBox

    // const masterCheckbox = document.querySelector('.master-checkbox');
        
    // masterCheckbox.addEventListener('change', function () {

    //     if (masterCheckbox.checked) {
    //         masterCheckbox.parentElement.parentElement.children[0].textContent = 'Enabled'
            
    //     } else {
    //         masterCheckbox.parentElement.parentElement.children[0].textContent = 'Disabled'
    //     }

    //     const toggleCheckboxes = document.querySelectorAll('.toggle-checkbox');
    //     toggleCheckboxes.forEach(function(checkbox) {
    //         document.querySelectorAll(".dishes-grid-item").forEach(item => {
    //             if (checkbox.checked = masterCheckbox.checked) {
    //                 item.classList.remove('add-gray')
    //                 item.children[0].children[2].children[0].textContent = 'Enabled'
    //             } else {
    //                 item.classList.add('add-gray')
    //                 item.children[0].children[2].children[0].textContent = 'Disabled'
    //             }
                
    //         })
    //     });
    // });

    // const containers = document.querySelectorAll('.dishes-container-box');

    // containers.forEach(function(container) {
    //     const masterCheckbox = container.querySelector('.master-checkbox');
        
    //     masterCheckbox.addEventListener('change', function () {

    //         if (masterCheckbox.checked) {
    //             masterCheckbox.parentElement.parentElement.children[0].textContent = 'Enabled'
                
    //         } else {
    //             masterCheckbox.parentElement.parentElement.children[0].textContent = 'Disabled'
    //         }

    //         const toggleCheckboxes = container.querySelectorAll('.toggle-checkbox');
            
    //         toggleCheckboxes.forEach(function(checkbox) {
    //             document.querySelectorAll(".dishes-grid-item").forEach(item => {
    //                 if (checkbox.checked = masterCheckbox.checked) {
    //                     item.classList.remove('add-gray')
    //                     item.children[0].children[2].children[0].textContent = 'Enabled'
    //                 } else {
    //                     item.classList.add('add-gray')
    //                     item.children[0].children[2].children[0].textContent = 'Disabled'
    //                 }
                    
    //             })
    //         });
    //     });
    // });

    const containers = document.querySelectorAll('.dishes-container-box');
        
    containers.forEach(function(container) {
        const masterCheckbox = container.querySelector('.master-checkbox');
        const toggleCheckboxes = container.querySelectorAll('.toggle-checkbox');
        
        masterCheckbox.addEventListener('change', function () {
            if (masterCheckbox.checked) {
                masterCheckbox.parentElement.parentElement.children[0].textContent = 'Enabled'
                
            } else {
                masterCheckbox.parentElement.parentElement.children[0].textContent = 'Disabled'
            }

            toggleCheckboxes.forEach(function(checkbox) {
                checkbox.checked = masterCheckbox.checked;

                if (checkbox.checked = masterCheckbox.checked) {
                    checkbox.parentElement.parentElement.children[0].textContent = 'Enabled'
                    checkbox.parentElement.parentElement.parentElement.parentElement.classList.remove('add-gray')
                } else {
                    checkbox.parentElement.parentElement.children[0].textContent = 'Disabled'
                    checkbox.parentElement.parentElement.parentElement.parentElement.classList.add('add-gray') 
                }

            });
        });
    });


    document.querySelectorAll(".rearrange-dish").forEach(dish => {
        dish.addEventListener('click', function () {
            document.querySelector(".rearrange-modal-2").classList.remove('d-none')
        })
    })

    function displayTimeSlots(containerId, startHour, endHour, interval) {
        const timeSlots = generateTimeSlots(startHour, endHour, interval);
        const timeSlotsContainer = document.getElementById(containerId);

        timeSlots.forEach((time, index) => {
            const timeItem = document.createElement('li');
            timeItem.className = 'time_set';
            if (index === 0) {
                timeItem.classList.add('active'); // Make the first item active
            }
            const timeLink = document.createElement('a');
            timeLink.href = '#';
            timeLink.textContent = time;
            timeItem.appendChild(timeLink);
            if (timeSlotsContainer) {
               timeSlotsContainer.appendChild(timeItem); 
            }
        });
    }

    displayTimeSlots('timeSlots1', 8, 12, 30);
    displayTimeSlots('timeSlots2', 15, 23, 30);
    displayTimeSlots('timeSlots3', 15, 23, 30);
    displayTimeSlots('timeSlots4', 15, 23, 30);

    //Float x
    document.querySelectorAll(".float-x").forEach(x => {
        x.addEventListener('click', function () {
            x.parentElement.children[2].value = ''
        })
    })
    
    document.querySelectorAll('.nav_menu-2').forEach(menu => {
        menu.addEventListener("click", function () {
            document.querySelector(".sidebar").classList.add("d-block", "sidebar-fixed")
        })
    })

    document.querySelectorAll(".expanded-icon").forEach(item => {
        item.addEventListener('click', function () {
            document.querySelector(".map-expanded").classList.remove("d-none")
        })
    })

    document.querySelectorAll(".minimise_icon").forEach(item => {
        item.addEventListener('click', function () {
            document.querySelector(".map-expanded").classList.add("d-none")
        })
    })

    document.querySelectorAll(".serial-num-info-takeaway").forEach(takeaway => {
        takeaway.addEventListener('click', function () {
            document.querySelector(".info-modal-takeaway").classList.remove('d-none')
        })
    })

    document.querySelectorAll(".serial-num-info-dine-in").forEach(dine_in => {
        dine_in.addEventListener('click', function () {
            document.querySelector(".info-modal-dine-in").classList.remove('d-none')
        })
    })

    //Change Avatar
    document.querySelectorAll('.avatar_1').forEach(inputElement => {
        inputElement.addEventListener('change', function(event) {
            const file = event.target.files[0];
            if (file) {
                const reader = new FileReader();

                reader.onload = function(e) {
                    // Find the corresponding image element in the same container
                    const imageElement = document.getElementById('imageToReplace');
                    imageElement.src = e.target.result;
                };

                reader.readAsDataURL(file);
            }
        });
    });

    document.querySelectorAll(".replace-avatar-holder img").forEach(img => {
        img.addEventListener('click', function () {
            const baseUrl = window.location.origin + '/';
            const relativeUrl = img.src.replace(baseUrl, '');

            const imageElement = document.getElementById('imageToReplace');
            imageElement.src = relativeUrl;
        })
    })

});


document.addEventListener("DOMContentLoaded", () => {
    const tabButtons = document.querySelectorAll(".tab-button");
    const tabContents = document.querySelectorAll(".tab-content");

    function openTab(tabName) {
        tabContents.forEach((tabContent) => {
            tabContent.style.display = tabContent.classList.contains(tabName) ? "block" : "none";
        });

        tabButtons.forEach((tabButton) => {
            tabButton.classList.toggle("active", tabButton.classList.contains(tabName.replace("-content", "")));
        });
    }

    tabButtons.forEach((tabButton) => {
        tabButton.addEventListener("click", (event) => {
            const tabName = event.currentTarget.classList[1] + "-content";
            openTab(tabName);
        });
    });

    // By default, open the first tab
    openTab("tab-male-content");
});

// document.getElementById('banner_cover').addEventListener('change', function(event) {
//     const file = event.target.files[0];
//     if (file) {
//         const reader = new FileReader();
        
//         reader.onload = function(e) {
//             const imageElement = document.getElementById('imageToReplace2');
//             imageElement.src = e.target.result;
//         };
        
//         reader.readAsDataURL(file);
//     }
// });


window.addEventListener('DOMContentLoaded', function () {
    var image = document.getElementById('crop_image');
    var slider = document.getElementById('myRange');
    var rotationValue = document.getElementById('rotationValue');
    var cropper = new Cropper(image, {
        aspectRatio: 16 / 9,
        viewMode: 1,
        responsive: true,
        autoCropArea: 1,
      crop: function(event) {
        console.log(event.detail.x);
        console.log(event.detail.y);
        console.log(event.detail.width);
        console.log(event.detail.height);
        console.log(event.detail.rotate);
        console.log(event.detail.scaleX);
        console.log(event.detail.scaleY);
      }
    });

    var scaleXButton = document.getElementById('scaleXButton');
    scaleXButton.addEventListener('click', function() {
        var currentScaleX = cropper.getData().scaleX || 1;
        cropper.scaleX(-currentScaleX);
    });

    var scaleYButton = document.getElementById('scaleYButton');
    scaleYButton.addEventListener('click', function() {
        var currentScaleY = cropper.getData().scaleY || 1;
        cropper.scaleY(-currentScaleY);
    });

    slider.addEventListener('input', function() {
        var rotationValue = slider.value;
        cropper.rotateTo(rotationValue); // Rotate image to the slider value
        document.getElementById('rotationValue').textContent = rotationValue;
    });
    
  });

document.getElementById('banner_cover').addEventListener('change', function(event) {
    const file = event.target.files[0];
    if (file) {
        const reader = new FileReader();
        
        reader.onload = function(e) {
            const imageElement = document.querySelectorAll('.imageToReplace2');
            
            imageElement.forEach(img => {
                img.src = e.target.result;
            })
        };
        
        reader.readAsDataURL(file);
    }
});

