<?php
use App\Models\Customer;
$customer = new Customer;
// fetch customer address
$customerAddress = $customer->listAddress($this->sessionData['id']);

?>
<main>
    <div class="header-space container"></div>

    <!-- address -->
    <section class="address-section">
        <p class="text-ml">Address</p>
        <div class="address-container flex-page">
            <ul class="address-list-content page-7 flex-column">
                <?php foreach($customerAddress as $val): ?>
                <li class="address-list-item flex-between dark-wrapper">
                    <div class="address-item-details">
                        <p class="text-normal address-item-name"><?= $val->address_alias; ?></p>
                        <p class="address-item-location text-sl-light">
                            <?= $val->customer_address; ?>
                        </p>
                    </div>
                    <div class="address-btn-container flex">
                        <p class="delete-btn btn text-accent">Delete</p>
                        <p class="edit-btn btn text-normal">Edit</p>
                    </div>
                </li>
                <?php endforeach; ?>
            </ul>
            <div class="address-map page-3">
                <div class="address-current-location">
                    <div class="address-map-content">
                        <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d30774466.70026853!2d60.97953533684291!3d19.684984596410274!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x30635ff06b92b791%3A0xd78c4fa1854213a6!2sIndia!5e0!3m2!1sen!2sng!4v1702270396929!5m2!1sen!2sng" style="border: 0" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                    <div class="light-wrapper">
                        <div class="address-current flex-between">
                            <div>
                                <div class="flex">
                                    <img src="/assets/icons/geo-tag.svg" alt="geo tag icon" />
                                    <p class="text-normal"><?= $this->addressSelected->address_alias; ?></p>
                                </div>
                                <p class="text-sl-light">
                                    <?= $this->addressSelected->customer_address; ?>
                                </p>
                            </div>
                            <img src="/assets/icons/bottom-arrow.svg" alt="bottom arrow icon" />
                        </div>
                        <div class="address-add-location">
                            <a href="" class="text-accent add-location-link">Add more location</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>