<?php

namespace App\Models;

use App\Lib\Database;
use App\Helpers\EmailValidator;
use App\Util\{Helper, FileSystem};

class AdminHandler
{

    protected $db;

    public function __construct()
    {
        $this->db = Database::connectDB();
    }

    public function getAllowedEmails(): array
    {
        $stmt = $this->db->fetch("SELECT auth_emails FROM _config");
        $allowedEmails = explode(',', $stmt->auth_emails);
        return $allowedEmails;
    }

    public function setAllowedEmails(array $allowedEmails): void
    {
        $allowedEmails = implode(',', $allowedEmails);
        $this->db->query("UPDATE _config SET auth_emails = ?", $allowedEmails);
    }

    public function addAllowedEmail(string $email): void
    {
        $allowedEmails = $this->getAllowedEmails();
        $allowedEmails[] = $email;
        $this->setAllowedEmails($allowedEmails);
    }

    public function setAuthCode(string $authCode): void
    {
        $this->db->query("UPDATE _config SET auth_code = ?", $authCode);
    }

    public function getAuthCode(): string
    {
        $stmt = $this->db->fetch("SELECT auth_code FROM _config");
        return $stmt->auth_code;
    }
}
