<?php

declare(strict_types=1);

namespace App\Controller;

use \App\Lib\Controller;
use App\Helpers\MetaTags;

class ErrorController extends Controller
{
    public function __construct()
    {
        //clear_cache();
    }

    public function index()
    {

        $tag = new MetaTags;
        $tag
            ->title('Page Not Found - 404')
            ->meta('author', APP['name'])
            ->meta('application-name', APP['name'])
            ->meta('theme-color', APP['theme'])
            ->meta('msapplication-TileColor', APP['theme'])
            ->meta('color-scheme', 'dark light');

        $this->view('error/404', ['meta' => $tag]);
    }

    public function forbidden()
    {

        $tag = new MetaTags;
        $tag
            ->title('Forbidden')
            ->meta('author', APP['name'])
            ->meta('application-name', APP['name'])
            ->meta('theme-color', APP['theme'])
            ->meta('msapplication-TileColor', APP['theme'])
            ->meta('color-scheme', 'dark light');

        $this->view('errors/403', ['meta' => $tag]);
    }

    public function server()
    {

        $tag = new MetaTags;
        $tag
            ->title('Internal Server Error')
            ->meta('author', APP['name'])
            ->meta('application-name', APP['name'])
            ->meta('theme-color', APP['theme'])
            ->meta('msapplication-TileColor', APP['theme'])
            ->meta('color-scheme', 'dark light');

        $this->view('errors/504', ['meta' => $tag]);
    }
}
