// sidebar arrays
const menuStory = [
  {
    imgSrc: "/assets/restaurant/images/svg/menu-logo.svg",
    header: "Create",
    text: "Dish or Menu etc.",
    secImg: "/assets/restaurant/images/svg/add-green.svg",
    dataset: "pink-bg",
  },
  {
    imgSrc: "/assets/restaurant/images/svg/story.svg",
    header: "Story",
    text: "Create & Manage Story update",
    secImg: "/assets/restaurant/images/svg/upload-blue.svg",
    dataset: "blue-bg",
  },
];

const navigationArray = [
  {
    imgSrc: "/assets/restaurant/images/svg/home-simple-active.svg",
    title: "Home",
    activeImg: "/assets/restaurant/images/svg/HouseSimple.svg",
    isActive: false,
    url: "../pages/home.html",
  },
  {
    imgSrc: "/assets/restaurant/images/svg/Basket.svg",
    title: "Orders",
    activeImg: "/assets/restaurant/images/svg/Basket-active.svg",
    isActive: false,
    url: "../pages/order.html",
  },
  {
    imgSrc: "/assets/restaurant/images/svg/BowlFood.svg",
    title: "Dishes & Menu",
    activeImg: "/assets/restaurant/images/svg/BowlFood-active.svg",
    isActive: false,
  },
  {
    imgSrc: "/assets/restaurant/images/svg/RoadHorizon.svg",
    title: "Delivery Partners",
    activeImg: "/assets/restaurant/images/svg/MopedFront-active.svg",
    isActive: false,
  },
  {
    imgSrc: "/assets/restaurant/images/svg/Percent.svg",
    title: "Discount",
    activeImg: "/assets/restaurant/images/svg/Percent-active.svg",
    isActive: false,
  },
  {
    imgSrc: "/assets/restaurant/images/svg/QrCode.svg",
    title: "QR Code",
    activeImg: "/assets/restaurant/images/svg/QrCode-active.svg",
    isActive: false,
  },
];

const navSecondaryArray = [
  {
    imgSrc: "/assets/restaurant/images/svg/GearSix.svg",
    title: "Settings",
    activeImg: "/assets/restaurant/images/svg/GearSix-active.svg",
    isActive: false,
    url: "../pages/home.html",
    admin: false,
  },
  {
    imgSrc: "/assets/restaurant/images/svg/Whatsapp.svg",
    title: "WhatsApp",
    activeImg: "/assets/restaurant/images/svg/Basket-active.svg",
    isActive: false,
    url: "../pages/order.html",
    admin: true,
  },
  {
    imgSrc: "/assets/restaurant/images/svg/FileText.svg",
    title: "Legal",
    activeImg: "/assets/restaurant/images/svg/FileText-active.svg",
    isActive: false,
    url: "../pages/order.html",
    admin: false,
  },
];

// sidebar header
const sidebarHeader = () => {
  const sidebarLogo = document.createElement("div");
  sidebarLogo.classList.add("side-bar-logo", "flex-between");

  const zoopLogo = new Image();
  zoopLogo.src = "/assets/restaurant/images/svg/zoop-md.svg";
  sidebarLogo.appendChild(zoopLogo);

  const closeBtn = document.createElement("div");
  closeBtn.classList.add("frame-sm", "flex-center");
  closeBtn.addEventListener("click", closeSideBar);

  const cancelSvg = new Image();
  cancelSvg.src = "/assets/restaurant/images/svg/cancel-white.svg";
  closeBtn.appendChild(cancelSvg);

  document.querySelector(".side-bar-header").appendChild(sidebarLogo);
  document.querySelector(".side-bar-header").appendChild(closeBtn);
};

const closeSideBar = () => {
  console.log("sidebar closed...");
};

// sidebar components
const renderMenuStory = () => {
  menuStory.forEach((item) => {
    const sideBarContent = document.createElement("div");
    sideBarContent.classList.add("flex-between", "side-bar-content");
    sideBarContent.id = item.dataset;

    const flexSm = document.createElement("div");
    flexSm.classList.add("flex-sm");

    const flexCenter = document.createElement("div");
    flexCenter.classList.add("flex-center", "frame-md");
    const img = new Image();
    img.src = item.imgSrc;
    flexCenter.appendChild(img);
    flexSm.appendChild(flexCenter);

    const flexColumn = document.createElement("div");
    flexColumn.classList.add("flex-column");
    const p1 = document.createElement("p");
    p1.classList.add("paragraph-text", "bold");
    p1.textContent = item.header;
    const p2 = document.createElement("p");
    p2.classList.add("misc-text");
    p2.textContent = item.text;
    flexColumn.appendChild(p1);
    flexColumn.appendChild(p2);
    flexSm.appendChild(flexColumn);

    const flexCenter2 = document.createElement("div");
    flexCenter2.classList.add("flex-center", "frame-lg");
    const img2 = new Image();
    img2.src = item.secImg;
    flexCenter2.appendChild(img2);
    sideBarContent.appendChild(flexSm);
    sideBarContent.appendChild(flexCenter2);

    document.querySelector(".sidebar-menustory").appendChild(sideBarContent);
  });
};
// sidebar navigations
const renderPrimaryNav = () => {
  navActivity();
  navBtn(navigationArray);
};

const renderSecondaryNav = () => {
  navBtn(navSecondaryArray);
};

const navBtn = (arr) => {
  arr.forEach((nav) => {
    const sidebarNavWrapper = document.createElement("div");
    sidebarNavWrapper.classList.add("sidebar-nav-wrapper");
    if (nav.isActive) {
      sidebarNavWrapper.classList.add("is-active");
    }

    const sidebarNavContent = document.createElement("a");
    sidebarNavContent.classList.add("flex-sm", "sidebar-nav-content");
    sidebarNavContent.setAttribute("href", nav.url);

    const sidebarNavIndicator = document.createElement("div");
    sidebarNavIndicator.classList.add("sidebar-nav-indicator");
    sidebarNavContent.appendChild(sidebarNavIndicator);

    const flexCenter = document.createElement("div");
    flexCenter.classList.add("flex-center", "frame-md");
    const img = new Image();
    img.src = nav.isActive ? nav.activeImg : nav.imgSrc;
    flexCenter.appendChild(img);
    sidebarNavContent.appendChild(flexCenter);

    const p = document.createElement("p");
    p.textContent = nav.title;
    p.classList.add("sidebar-title-text", "paragraph-text", "bold");
    sidebarNavContent.appendChild(p);

    // super admin permission
    if (nav.admin) {
      sidebarNavWrapper.style.pointerEvents = 'none';
    }

    sidebarNavWrapper.appendChild(sidebarNavContent);
    document.querySelector(".side-bar-wrapper").appendChild(sidebarNavWrapper);
  });
};

const navActivity = () => {
  let wrapper = document.querySelector(".wrapper");

  let binary = true;

  if (wrapper.classList.contains("home")) {
    const home = navigationArray.find((nav) => nav.title == "Home");
    home.isActive = binary;
  } else if (wrapper.classList.contains("orders")) {
    const orders = navigationArray.find((nav) => nav.title == "Orders");
    orders.isActive = binary;
  } else if (wrapper.classList.contains("menu")) {
    const menu = navigationArray.find((nav) => nav.title == "Dishes & Menu");
    menu.isActive = binary;
  } else if (wrapper.classList.contains("delivery")) {
    const delivery = navigationArray.find(
      (nav) => nav.title == "Delivery Partners"
    );
    delivery.isActive = binary;
  } else if (wrapper.classList.contains("discount")) {
    const discount = navigationArray.find((nav) => nav.title == "Discount");
    discount.isActive = binary;
  } else if (wrapper.classList.contains("qrcode")) {
    const qrcode = navigationArray.find((nav) => nav.title == "QR Code");
    qrcode.isActive = binary;
  }
};

window.addEventListener("load", () => {
  sidebarHeader();
  renderMenuStory();
  renderPrimaryNav();
  renderSecondaryNav();
});
