// global variables
const modal = document.querySelector(".modal");
const modalHead = document.querySelector(".modal-header");
const modalContent = document.querySelector(".modal-content");
const user = "James";

// modal header
const modalHeader = () => {
  modalHead.innerHTML += `
  <div class="modal-lead flex-sm">
    <div class="flex-center">
      <img src="/assets/restaurant/images/svg/wave.svg" alt="wave icon" />
    </div>
    <p class="paragraph-text">hello!</p>
  </div>
  
  <div class="modal-counter flex-sm">
    <span class="flex-center counter is-active paragraph-text"
      >1</span
    >
    <span class="flex-center counter paragraph-text">2</span>
    <span class="flex-center counter paragraph-text">3</span>
    <span class="flex-center counter paragraph-text">4</span>
  </div>
  <div class="frame-sm flex-center" onclick="closeModal()">
    <img
      src="/assets/restaurant/images/svg/cancel-white.svg"
      alt="cancel icon"
    />
  </div>
  `;
};

// render onboarding
const onboardPage = (content) => {
  const onboardAnimationArr = [
    { transform: "scale(0.8)" },
    { transform: "scale(1)" },
  ];
  
  const onboardTimingArr = {
    duration: 300,
    iterations: 1,
  };
  

  modalContent.innerHTML = ``;
  const onboardContent = document.createElement('div');
  onboardContent.className = "onboard-content"
  onboardContent.innerHTML = content;
  // onboardContent.animate(onboardAnimationArr, onboardTimingArr);
  modalContent.appendChild(onboardContent);
  modalContent.animate(onboardAnimationArr, onboardTimingArr);
};

const onboardPageOne = () => {
  document.querySelector(".modal-counter").style.opacity = "0";

  console.log("running 1...");
  onboardPage(`
        <div class="onboarding-img flex-center onboard-img-1">
              <img
                src="/assets/restaurant/images/onboarding/welcome-order.png"
                alt="welcome to zoop image"
              />
        </div>
        <div class="onboarding full-width flex-column">
              <p class="header-text onboarding-title">
                Welcome, ${user} 👋🏾
              </p>
              <p class="paragraph-light-text modal-text">
                  It’s beautiful to have you here,
                  Let’s set up your restaurant, just few things needed like, Restaurant or Business Name, Dish type, Location and Payment Option. 😉😉
              </p>
        </div>
        <div class="modal-navigation flex-column-center">
          <div class="primary-btn flex-sm"  onclick="onboardPageTwo()">
            <p>Get Started</p>
            <img src="/assets/restaurant/images/svg/right-arrow.svg" alt="arrow icon" />
          </div>
        </div>
`);

};

const onboardPageTwo = () => {
  document.querySelector(".modal-counter").style.opacity = "1";
  modalCounter(0);

  console.log("running 2...");
  onboardPage(
    `
              <div class="onboarding-img flex-center onboard-img-2">
                <img
                  src="/assets/restaurant/images/onboarding/contract.png"
                  alt="welcome to zoop image"
                />
              </div>
              <div class="onboarding full-width flex-column">
                <p class="header-text onboarding-title">
                   ${user}, what should we call your business
                </p>
                <p class="paragraph-light-text modal-text">
                  You can enter your registered business name, select your
                  business type in the field below
                </p>
                <div
                  class="business-info-container flex-center"
                  data-label="Business Name"
                >
                  <input
                    type="text"
                    name="business-name"
                    data-label="Business Name"
                    class="business-info-input business-name"
                    placeholder="Type here..."
                  />
                </div>

                <div
                  class="business-info-container flex-between"
                  data-label="Business Type"
                data-business = "type"><p class="misc-dark-text bold">${localStorage.getItem('business-cat') ||"Restaurant"}</p> 
                <div class="drop-down flex-center">
                <img src="/assets/restaurant/images/svg/dropdown-arrow.svg"     alt="arrow icon" />
              </div>
              </div>
              <div class="modal-navigation flex-column-center">
                <div class="primary-btn flex-sm" onclick="onboardPageThree()">
                  <p>Continue</p>
                  <img src="/assets/restaurant/images/svg/right-arrow.svg"     alt="arrow icon" />
                </div>
                <div class="previous" onclick="onboardPageOne()">
                      <p class="bold">Back</p>
                </div>
              </div>
          `
  );

  const target = document.querySelector('div[data-business = "type"]');
  target.addEventListener("click", () => {
    let arrow = target.children[1];
  
    if (target.childElementCount < 3) {
      // render category card
      arrow.style.rotate = "180deg";
      categoryCard();
    } else {
      // remove category card
      arrow.style.rotate = "0deg";
      removeCategoryCard();
    }
  });
};

const onboardPageThree = () => {
  modalCounter(1);
  console.log("running 3...");
  onboardPage(
    `
              <div class="onboarding-img flex-center onboard-img-2">
                <img
                  src="/assets/restaurant/images/onboarding/timer.png"
                  alt="welcome to zoop image"
                />
              </div>
              <div class="onboarding full-width flex-column">
                <p class="header-text onboarding-title time-title">
                  Let’ set your opening hours
                </p>
                <p class="paragraph-light-text modal-text">
                  Your business opening hours helps customers to know when they can come get their treats 😉
                </p>

                <div class="business-info-container flex-between schedule" data-label="Morning Opening Time in 24H Format" data-early="opening" data-one="opening">
                  <p class="misc-dark-text">${localStorage.getItem('morningOpening') || "8:00 AM"} </p>
                  <div class="drop-down flex-center">
                    <img src="/assets/restaurant/images/svg/dropdown-arrow.svg"     alt="arrow icon" />
                  </div>
                </div>
                <div class="business-info-container flex-between schedule" data-label="Morning Closing Time in 24H Format" data-early="closing" data-two="closing">
                  <p class="misc-dark-text">${localStorage.getItem('morningClosing') || "12:00 PM"}</p>
                  <div class="drop-down flex-center">
                    <img src="/assets/restaurant/images/svg/dropdown-arrow.svg"     alt="arrow icon" />
                  </div>
                </div>
                <div class="business-info-container flex-between schedule" data-label="Evening Opening Time in 24H Format" data-late="opening" data-three="opening">
                  <p class="misc-dark-text">${localStorage.getItem('eveningOpening') || "5:00 PM"}</p>
                  <div class="drop-down flex-center">
                    <img src="/assets/restaurant/images/svg/dropdown-arrow.svg"     alt="arrow icon" />
                  </div>
                </div>
                <div class="business-info-container flex-between schedule" data-label="Evening Closing Time in 24H Format" data-late="closing" data-four="closing">
                  <p class="misc-dark-text">${localStorage.getItem('eveningClosing') || "11:45 PM"}</p>
                  <div class="drop-down flex-center">
                    <img src="/assets/restaurant/images/svg/dropdown-arrow.svg"     alt="arrow icon" />
                  </div>
                </div>
      </div>
      <div class="modal-navigation flex-column-center">
                <div class="primary-btn flex-sm" onclick="onboardPageFour()">
                  <p>Continue</p>
                    <img src="/assets/restaurant/images/svg/right-arrow.svg"     alt="arrow icon" />
                </div>
                <div class="previous" onclick="onboardPageTwo()">
                      <p class="paragraph-text">Back</p>
                </div>
      </div>
    `
  );

  const morningSchedule = document.querySelectorAll("[data-early]");
  const eveningSchedule = document.querySelectorAll("[data-late]");

  renderSchedule(morningSchedule);
  renderSchedule(eveningSchedule);
};

const onboardPageFour = () => {
  modalCounter(2);

  console.log("running 4...");
  onboardPage(
    `
              <div class="onboarding-img flex-center onboard-img-2">
                <img
                  src="/assets/restaurant/images/onboarding/handset icon.png"
                  alt="animated telephone image"
                />
              </div>
              <div class="onboarding full-width flex-column">
                <p class="header-text onboarding-title call-title">
                A call line is also important to your customers
                </p>
                <p class="paragraph-light-text modal-text">
                Yeah, it can be overwhelming sometimes but they need to talk to a support team when they feel that order is taking too long.
                </p>
              </div>
              <div class="flex business-number-input">
                    <div class="business-info-container flex-center" data-label="Phone Number">
                      <input type="tel" class="full-width" placeholder="Enter your number"/>
                    </div>
                    <div class="business-info-container flex-center" data-label="WhatsApp Number">
                      <input type="tel" class="full-width" placeholder="Enter your number"/>
                    </div>
              </div>
              </div>
              <div class="modal-navigation flex-column-center">
              <div class="primary-btn flex-sm" onclick="onboardPageFive()">
                <p>Continue</p>
                <img src="/assets/restaurant/images/svg/right-arrow.svg"     alt="arrow icon" />
              </div>
              <div class="previous" onclick="onboardPageThree()">
                    <p class="paragraph-text">Back</p>
              </div>
    </div>
    `
  );
};

const onboardPageFive = () => {
  modalCounter(3);

  console.log("running 5...");
  onboardPage(
    `
    <div class="onboarding-img flex-center onboard-img-3">
                <img
                  src="/assets/restaurant/images/onboarding/geotag.png"
                  alt="animated geotag image"
                />
              </div>
              <div class="onboarding full-width flex-column">
                <p class="header-text onboarding-title">
                Let’s place your business in the map
                </p>
                <p class="paragraph-light-text modal-text">
                Your business address will helps your customers find you, & your business contact is required too, they’re important
                </p>
              </div>
              <div class="hilite-div">
                <p class="blue-hilite-text hilite-paragraph">Set up your business location on mobile, to do that, login to your business account on your mobile device.</p>
              </div>
              <div class="modal-navigation flex-column-center">
                <div class="primary-btn flex-sm" onclick="onboardPageSix()">
                  <p>Done</p>
                  <img src="/assets/restaurant/images/svg/right-arrow.svg"     alt="arrow icon" />
                </div>
                <div class="previous" onclick="onboardPageFour()">
                      <p class="paragraph-text">Back</p>
                </div>
      </div>
    `
  );
};

const onboardPageSix = () => {
  document.querySelector(".modal-counter").style.opacity = "0";

  console.log("running 6...");
  onboardPage(
    `
    <div class="onboarding-img flex-center onboard-img-2">
              <img
                src="/assets/restaurant/images/onboarding/like.png"
                alt="animated like image"
              />
    </div>
    <div class="onboarding full-width flex-column">
              <p class="header-text onboarding-title like-title">
              Great ${user}! your ready.
              </p>
              <p class="paragraph-light-text modal-text">
              It was a smoooth ride
              </p>
    </div>
    <div class="modal-navigation flex-column-center">
        <div class="primary-btn flex-sm" onclick="closeModal()">
          <p>Let's Explore</p>
          <img src="/assets/restaurant/images/svg/right-arrow.svg" alt="arrow icon" />
        </div>
    </div>
    `
  );
};

// modal counter
const modalCounter = (index) => {
  const counter = document.querySelector(".modal-counter").children;

  for (let count of counter) {
    count.classList.remove("is-active");
    counter[index].classList.add("is-active");
  }
};

// close modal
const closeModal = () => {
  if (modal.classList.contains("is-active") === false) {
    modal.classList.toggle("is-active");
    document.querySelector(".modal-backdrop").style.display = "none";
  }
};

// BUSINESS CATEGORY
// create category card
const categoryCard = () => {
  const parent = document.querySelector('div[data-business = "type"]');

  const categoryArr = ["Restaurant", "Home Kitchen"];

  // category wrapper
  const categoryWrapper = document.createElement("div");
  categoryWrapper.classList.add("category-wrapper", "drop-down-wrapper");

  // category header
  const categoryHeader = document.createElement("div");
  categoryHeader.classList.add("flex-between", "drop-down-header");

  // header text
  const categoryText = document.createElement("p");
  categoryText.textContent = "Business Type";
  categoryText.classList.add("misc-text", "bold");
  categoryHeader.appendChild(categoryText);

  // close category btn
  const closeCategory = document.createElement("div");
  closeCategory.classList.add("close-btn", "flex-center");
  categoryHeader.appendChild(closeCategory);
  closeCategory.addEventListener("click", () => {
    categoryWrapper.remove();
    console.log("close...");
  });

  // close category image
  const img = new Image();
  img.src = "/assets/restaurant/images/svg/cancel-white.svg";
  closeCategory.appendChild(img);

  categoryWrapper.appendChild(categoryHeader);

  // category list
  const categoryList = document.createElement("ul");
  categoryList.classList.add("drop-down-list");

  categoryWrapper.appendChild(categoryList);
  parent.appendChild(categoryWrapper);

  // populate category list
  categoryArr.map((item) => {
    const categoryItem = document.createElement("li");
    categoryItem.classList.add(
      "paragraph-text",
      "drop-down-item",
      "bold",
      "flex",
      "category-item"
    );
    categoryItem.textContent = item;
    categoryList.appendChild(categoryItem);

    categoryItem.addEventListener('click', () => {
      categoryChoice(parent, categoryItem)
    })
  });
};

const categoryChoice = (categoryBtn, item) => {
  let currentCategory = categoryBtn.children[0];
  let chosenCategory = item.textContent;

  localStorage.setItem('business-cat', chosenCategory)
  let update = localStorage.getItem('business-cat');
  currentCategory.textContent = update;
};

// remove card
const removeCategoryCard = () => {
  document.querySelector(".category-wrapper").remove();
};

// SCHEDULING
const scheduleCard = (parent) => {
  scheduleArr = [
    "12:00","12:15","12:30","12:45",
    "01:00","01:15","01:30","01:45",
    "02:00","02:15","02:30","02:45",
    "03:00","03:15","03:30","03:45",
    "04:00","04:15","04:30","04:45",
    "05:00","05:15","05:30","05:45",
    "06:00","06:15","06:30","06:45",
    "07:00","07:15","07:30","07:45",
    "08:00","08:15","08:30","08:45",
    "09:00","09:15","09:30","09:45",
    "10:00","10:15","10:30","10:45",
    "11:00","11:15","11:30","11:45",
    "12:00"
  ];

  // schedule wrapper
  const scheduleWrapper = document.createElement("div");
  scheduleWrapper.className = "drop-down-wrapper schedule-wrapper";

  // schedule header
  const scheduleHeader = document.createElement("div");
  scheduleHeader.className = "drop-down-header flex-between schedule-head";
  scheduleWrapper.appendChild(scheduleHeader);

  // header text
  const scheduleText = document.createElement("p");
  scheduleText.textContent = "Set Time";
  scheduleText.classList.add("misc-dark-text", "bold");
  scheduleHeader.appendChild(scheduleText);

  // close schedule btn
  const closeSchedule = document.createElement("div");
  closeSchedule.classList.add("close-btn", "flex-center");
  scheduleHeader.appendChild(closeSchedule);
  closeSchedule.addEventListener("click", () => {
    scheduleWrapper.remove();
  });

  // close category image
  const img = new Image();
  img.src = "/assets/restaurant/images/svg/cancel-white.svg";
  closeSchedule.appendChild(img);

  // schedule list
  const scheduleList = document.createElement("ul");
  scheduleList.className = "drop-down-grid";
  scheduleWrapper.appendChild(scheduleList);

  scheduleArr.map((item) => {
    const scheduleItem = document.createElement("li");
    scheduleItem.classList.add(
      "paragraph-text",
      "drop-down-item",
      "bold",
      "flex",
      "schedule-item",
    );
    if (parent.closest("[data-late]")) {
      scheduleItem.textContent = item + " " + "PM";
    } else if (parent.closest("[data-early]")) {
      scheduleItem.textContent = item + " " + "AM";
    }
    
    scheduleItem.addEventListener("click", () => {
      scheduleChoice(parent, scheduleItem)
    });

    scheduleList.appendChild(scheduleItem);
  });

  // schedule footer
  const scheduleFooter = document.createElement("div");
  scheduleFooter.className = "flex-right schedule-footer drop-down-footer";
  scheduleFooter.style.gap = "var(--ws-2)";

  // cancel schedule
  const cancelSchedule = document.createElement("p");
  cancelSchedule.className = "paragraph-accent-text bold";
  cancelSchedule.textContent = "Cancel";
  cancelSchedule.addEventListener('click', () => {
    removeScheduleCard();
  })
  scheduleFooter.appendChild(cancelSchedule);

  // OK schedule
  const okSchedule = document.createElement("p");
  okSchedule.className = "paragraph-accent-text bold";
  okSchedule.textContent = "OK";
  okSchedule.addEventListener('click', () => {
    removeScheduleCard();
  })
  scheduleFooter.appendChild(okSchedule);

  scheduleWrapper.appendChild(scheduleFooter);
  parent.appendChild(scheduleWrapper);
};

// render schedule
const renderSchedule = (targets) => {
  targets.forEach((target) => {
    let arrow = target.children[1];
    
    target.addEventListener("click", () => {
      target.addEventListener("click", function () {
        if (target.childElementCount < 3) {
          // render schedule card
          arrow.style.rotate = "180deg";
          scheduleCard(target);
        } else {
          // remove schedule card
          arrow.style.rotate = "0deg";
          removeScheduleCard();
        }
      });
    });
  });
};

// remove schedule card
const removeScheduleCard = () => {
  document.querySelector(".schedule-wrapper").remove();
};

// schedule specificity 
const scheduleChoice = (scheduleBtn, item) => {
  let currentSchedule = scheduleBtn.children[0];
  let chosenSchedule = item.textContent;

  if(scheduleBtn.hasAttribute("data-one")) {
    localStorage.setItem('morningOpening', chosenSchedule);
    let update = localStorage.getItem('morningOpening');
    currentSchedule.textContent = update; 
  } else if (scheduleBtn.hasAttribute("data-two")) {
    localStorage.setItem('morningClosing', chosenSchedule);
    let update = localStorage.getItem('morningClosing');
    currentSchedule.textContent = update; 
  } else if (scheduleBtn.hasAttribute("data-three")) {
    localStorage.setItem('eveningOpening', chosenSchedule);
    let update = localStorage.getItem('eveningOpening');
    currentSchedule.textContent = update; 
  } else if (scheduleBtn.hasAttribute("data-four")) {
    localStorage.setItem('eveningClosing', chosenSchedule);
    let update = localStorage.getItem('eveningClosing');
    currentSchedule.textContent = update; 
  }

  removeScheduleCard();
}

// LOAD TO WINDOW 
window.addEventListener("load", () => {
  modalHeader();
  onboardPage(`
        <div class="onboarding-img flex-center onboard-img-1">
              <img
                src="/assets/restaurant/images/onboarding/welcome-order.png"
                alt="welcome to zoop image"
              />
        </div>
        <div class="onboarding full-width flex-column">
              <p class="header-text onboarding-title">
                Welcome, ${user} 👋🏾
              </p>
              <p class="paragraph-light-text modal-text">
                  It’s beautiful to have you here,
                  Let’s set up your restaurant, just few things needed like, Restaurant or Business Name, Dish type, Location and Payment Option. 😉😉
              </p>
        </div>
        <div class="modal-navigation flex-column-center">
          <div class="primary-btn flex-sm"  onclick="onboardPageTwo()">
            <p>Get Started</p>
            <img src="/assets/restaurant/images/svg/right-arrow.svg" alt="arrow icon" />
          </div>
        </div>
  `);
});
