// GENERAL VARIABLES
  const listBtn = document.querySelector(".list-svg");
  const listMenu = document.querySelector(".list-menu");
  const gridBtn = document.querySelector(".grid-svg");
  const gridMenu = document.querySelector(".grid-menu");

  // display grid menu
  const displayGridMenu = () => {
    gridMenu.classList.add("active");
    listMenu.classList.remove("active");
    gridBtn.classList.add("active");
    listBtn.classList.remove("active");
  };
  gridBtn.addEventListener("click", displayGridMenu);

  // display list menu
  const displayListMenu = () => {
    gridMenu.classList.remove("active");
    listMenu.classList.add("active");
    gridBtn.classList.remove("active");
    listBtn.classList.add("active");
  };
  listBtn.addEventListener("click", displayListMenu);

  // render grid menu
  const renderGridMenu = () => {
    dishes.forEach((dish) => {
      gridMenu.innerHTML += `
            <div class="flex-between restaurant-menu-item">
            <div class="restaurant-food-img">
              <img src="${dish.imgSrc}" alt="food image" />
            </div>
            <div class="restaurant-menu-details flex-column page-7">
              <div class="flex-between">
                <div class="flex-sm">
                  <div class="rect free-stamp flex-sm">
                    <img
                      src="../assets/star-white.svg"
                      alt="white star icon"
                    />
                    <p class="text-sm-light">${dish.rating}</p>
                  </div>
                  ${dish.bestseller || " "}
                </div>
                <div class="hollow-header">
                  <img
                    src="../assets/hollow-heart.svg"
                    alt="hollow heart icon"
                  />
                </div>
              </div>
              <p class="text-normal restaurant-food-menu">${dish.name}</p>
              <p class="restaurant-food-price text-sl">₹250</p>
              <div class="restaurant-btn-container flex-right">
                <div class="sec-add-btn btn flex-center">
                  <img src="../assets/minus.svg" alt="" />
                  <p class="item text-normal">1</p>
                  <img src="../assets/plus.svg" alt="" />
                </div>
                <div class="add-btn btn flex-center" onclick="addToBasket(${dish.id})">
                  <p class="add-btn-text">Add</p>
                </div>
              </div>
            </div>
          </div>
            `;
    });
  };

  renderGridMenu();

  // render list menu
  const renderListMenu = () => {
    dishes.forEach((dish) => {
      listMenu.innerHTML += `
      <a href="../pages/category.html" class="list-menu-item text-normal flex-center">${dish.name}</a>
      `
    })
  }

  renderListMenu();

  // basket array
let basketArr = [];

// add to favorites
function addToBasket(id) {
    
  // check if dish already in basket
  if (basketArr.some((item) => item.id === id)) {
    alert("item exists");
  } else {
    const basketItem = dishes.find((dish) => dish.id === id);

    basketArr.push({...basketItem, numberOfUnits: 1});
  }
  
  updateBasket();
}

const updateBasket = () => {
  console.log("update basket")
}
