// global variables
const pricingBtn = document.querySelector(".pricing-btn");
const sortCategory = document.querySelector(".restaurant-sort-category");
const sortClear = document.querySelector(".restaurant-sort-clear");
const restaurantEl = document.querySelector(".restaurant-content");
const favoriteContent = document.querySelector(".fav-content");

// display sorting list
const displaySortingList = () => {
  sortCategory.classList.toggle("active");
};

pricingBtn.addEventListener("click", displaySortingList);
sortClear.addEventListener("click", displaySortingList);

// render restaurants
const renderRestaurants = () => {
  restaurants.forEach((restaurant) => {
    restaurantEl.innerHTML += `
        <div class="restaurant-tag">
        <div class="restaurant-img">
          <img src="${restaurant.cuisineImg}" alt="restaunrant cuisine" />
          ${restaurant.discount || restaurant.open}
          <div class="discount-stamp rect free-stamp">
            <p class="text-sm-light">Free delivery</p>
          </div>
        </div>
        <div class="restaurant-details">
          <p class="restaurant-name text-normal">${restaurant.name}</p>
          <div class="cuisine-category flex-sm">
            <div class="flex-sm restaurant-rating free-stamp rect">
              <img
                src="/assets/icons/star-white.svg"
                alt="white star rating"
              />
              <p class="text-sm-light">${restaurant.rating || ""}</p>
            </div>
            <div class="rect food-cuisine btn">
              <p class="text-sl">Restaurant</p>
            </div>
            <div class="rect food-cuisine btn">
              <p class="text-sl">Vegetarian</p>
            </div>
            <div class="rect food-cuisine btn">
              <p class="text-sl">Fast Food</p>
            </div>
          </div>
          <div class="restaurant-distance flex-between">
            <div class="flex">
              <p class="text-sl">${restaurant.distance}</p>
              <span class="span-space"></span>
              <p class="text-sl">₹${restaurant.price}</p>
            </div>

            <div class="heart-content">
              <button class="hollow-heart active" onclick="addFavorite(${
                restaurant.id
              })">
                <img
                  src="/assets/icons/hollow-heart.svg"
                  alt="favorite logo"
                />
              </button>
            </div>
          </div>
        </div>
      </div>
        `;
  });
};

renderRestaurants();



// add to favorites
const addFavorite = (id) => {
  // check if restaurant already in favorite
  if (favoritesArr.some((favorite) => favorite.id === id)) {
    alert("already favorite");
  } else {
    const favorite = restaurants.find((restaurant) => restaurant.id === id);

    favoritesArr.push(favorite);
    // console.log(favoritesArr);
  }

  
  
  // update favorites
  updateFavorite();

  // change favorites icons
  changeIcons(id);
};

const changeIcons = (id) => {

  const heartContents = document.querySelectorAll(".heart-content"); 
  heartContents[id].innerHTML = `
  <button class="red-heart active" onclick="removeFavorite(${id})">
    <img
      src="/assets/icons/red-heart.svg"
      alt="favorite logo"
    />
  </button>
  `
};

// favorites array
let favoritesArr = JSON.parse(localStorage.getItem("FAV")) || [];


const updateFavorite = () => {

  // save favoritesArr to local storage
  localStorage.setItem("FAV", JSON.stringify(favoritesArr));

  renderFavItems();
};

const renderFavItems = () => {
  // clear favorites elements
  favoriteContent.innerHTML = "";

  favoritesArr.forEach((item) => {
    favoriteContent.innerHTML += `
        <a href="../pages/restaurant.html" class="restaurant-sec fav flex">
          <div class="restaurant-sec-img">
            <img src="${item.imgSrc}" alt="food image" />
          </div>
          <div class="restaurant-sec-details">
            <p class="restaurant-sec-title text-normal">${item.name}</p>
            <div class="restaurant-sec-rating-cuisine flex-sm">
              <div class="restaurant-sec-rating flex-sm">
                <img src="/assets/icons/star.svg" alt="star rating" />
                <p class="restaurant-sec-rating-figure text-sm">${item.rating}</p>
              </div>
              <p class="restaurant-sec-cuisine text-sm">Chinese</p>
            </div>
          </div>
        </a>
    `;
  });
};
