<?php
use App\Util\Helper;
use App\Models\{Customer, LoginHandler};
use Overtrue\Socialite\SocialiteManager;

$this->isLoggedIn = false;
$selectedAlias = 'Home';
$selectedAddress = 'Choose Location';

if($this->isLoggedIn){
  $customerName = Helper::capitalize($this->sessionData['firstName'] . ' ' . $this->sessionData['lastName']);
  $customerEmail = $this->sessionData['email'];
  $customerAvatar = UPLOADS['customer_dir'] . "/{$this->sessionData['avatar']}";
  $customerID = $this->sessionData['id'];
  // get selected address
  $this->addressSelected = $customer->getSelectedAddress($this->sessionData['id']);

  if($this->addressSelected){
    $selectedAddress = $this->addressSelected->customer_address;
    $selectedAlias = $this->addressSelected->address_alias;
  }

  // fetch customer address
  $customerAddress = $customer->listAddress($this->sessionData['id']);  
}

$config = [
  'google' => [
    'client_id'     => GOOGLE_OAUTH['client_id'],
    'client_secret' => GOOGLE_OAUTH['client_secret'],
    'redirect'      => URLROOT . '/customer/auth/google',
  ],
  'facebook' => [
    'client_id'     => FACEBOOK_OAUTH['app_id'],
    'client_secret' => FACEBOOK_OAUTH['secret'],
    'redirect'      => URLROOT . '/customer/auth/facebook',
  ],
];

$socialite = new SocialiteManager($config);

$googleAuthUrl = $socialite->create('google')->redirect();
$facebookAuthUrl = $socialite->create('facebook')->redirect();
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <link rel="shortcut icon" type="image/x-icon" href="<?= APP['logo-dark']; ?>" />
  <?php
  // add page meta tags
  echo $data['meta'];

  // add custom css
  if (isset($data['custom_css']) && !empty($data['custom_css'])) {
    foreach ($data['custom_css'] as $css) {
      echo "<link rel='stylesheet' href='{$css}' />";
    }
  }
  ?>
  <link rel="stylesheet" href="/assets/css/home.css" />
  <script src="/assets/js/app.js" defer></script>
</head>

<body id="body">
  <div class="wrapper">
    <div class="curtain"></div>
    <!-- header section -->
    <header id="header" class="flex-between container">
      <!-- header logo -->
      <a href="/" class="header-logo">
        <img src="<?= APP['logo-dark']; ?>" alt="zoop logo image" srcset="" />
      </a>

      <!-- address and list -->
      <div class="header-address-container">
        <!-- address on display -->
        <div class="header-address-content btn">
          <div class="header-address-top flex">
            <img src="/assets/icons/geo-tag.svg" alt="geo tag icon" />
            <p class="address-name text-md"><?= $selectedAlias; ?></p>
            <img class="address-pointer-svg" src="/assets/icons/right-arrow.svg" alt="arrow icon" />
          </div>
          <div>
            <p class="text-sl-light address-details">
              <?= $selectedAddress; ?>
            </p>
          </div>
        </div>

        <!-- address options and hidden -->
        <div class="address-options flex-column">
          <div class="address-options-header flex-between">
            <p class="text-md-light">Choose location</p>
            <a href="/customer/address" class="address-add btn flex-sm">
              <img src="/assets/icons/plus.svg" alt="" />
              <p class="text-accent-sl">Add Location</p>
            </a>
          </div>
          <!-- address list -->
          <?php if(!empty($customerAddress)): ?>
          <div class="address-options-list flex-column">
            <?php foreach($customerAddress as $addressList): 
              $selected = $addressList->address_selected == 'true' ? 'active' : '';
            ?>
            <a class="address-options-item <?= $selected; ?> flex-between">
              <div class="address-item-title">
                <p class="address-item-name text-normal"><?= $addressList->address_alias; ?></p>
                <p class="address-item-details text-sl">
                  <?= $addressList->customer_address; ?>
                </p>
              </div>
              <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M12 2C6.49 2 2 6.49 2 12C2 17.51 6.49 22 12 22C17.51 22 22 17.51 22 12C22 6.49 17.51 2 12 2ZM16.78 9.7L11.11 15.37C10.97 15.51 10.78 15.59 10.58 15.59C10.38 15.59 10.19 15.51 10.05 15.37L7.22 12.54C6.93 12.25 6.93 11.77 7.22 11.48C7.51 11.19 7.99 11.19 8.28 11.48L10.58 13.78L15.72 8.64C16.01 8.35 16.49 8.35 16.78 8.64C17.07 8.93 17.07 9.4 16.78 9.7Z" fill="#5C5F6470" />
              </svg>
            </a>
            <?php endforeach; ?>
          </div>
          <?php endif; ?>
        </div>
      </div>

      <!-- navigation -->
      <nav class="nav flex-between">
        <a href="/" class="home-link nav-link active flex-sm">
          <svg class="home-icon" width="24" height="16" viewBox="0 0 24 16" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M12.0001 2.08209C12.6495 2.08209 13.2707 2.13856 13.8918 2.2515C13.8918 2.1668 13.9201 2.08209 13.9201 1.99739C13.9201 0.952684 13.073 0.0773926 12.0001 0.0773926C10.9271 0.0773926 10.0801 0.924449 10.0801 1.99739C10.0801 2.08209 10.0801 2.1668 10.1083 2.2515C10.7295 2.13856 11.3507 2.08209 12.0001 2.08209Z" fill="#8F949B" />
            <path d="M13.9062 3.18601C13.2851 3.07307 12.6639 3.0166 12.0145 3.0166C11.3651 3.0166 10.7439 3.07307 10.1227 3.18601C5.26628 4.08954 1.5957 8.32482 1.5957 13.4354H22.405C22.4333 8.32482 18.7627 4.0613 13.9062 3.18601ZM12.438 4.82365C16.1086 4.82365 20.1462 8.18364 20.1462 11.8542H16.4192C16.4192 8.18364 8.76744 4.82365 12.438 4.82365Z" fill="#8F949B" />
            <path d="M0 14.2007L0.847056 15.923H23.1529L23.9999 14.2007H0Z" fill="#8F949B" />
          </svg>
          <p class="text-sm nav-link-p">Home</p>
        </a>
        <a class="search-link nav-link flex-sm">
          <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path id="Vector" d="M19.6561 18.1081L16.0689 14.5455C18.8699 10.9584 18.5751 5.84774 15.3563 2.62907C13.6609 0.933702 11.4005 0 8.99269 0C6.58488 0 4.3244 0.933702 2.62907 2.62907C0.933702 4.32444 0 6.58484 0 8.99269C0 11.4005 0.933702 13.661 2.62907 15.3563C4.32444 17.0517 6.58484 17.9854 8.99269 17.9854C10.9828 17.9854 12.9485 17.322 14.5209 16.0689L18.0835 19.6805C18.3046 19.9016 18.5749 20 18.8699 20C19.1646 20 19.4349 19.8771 19.6562 19.6805C20.0984 19.2629 20.0984 18.5504 19.656 18.1081L19.6561 18.1081ZM15.7741 8.99265C15.7741 10.8109 15.0617 12.5061 13.784 13.7838C12.5063 15.0615 10.7865 15.7739 8.99287 15.7739C7.19926 15.7739 5.47945 15.0615 4.20173 13.7838C2.924 12.5061 2.2116 10.7863 2.2116 8.99265C2.2116 7.17443 2.92404 5.47923 4.20173 4.20151C5.47941 2.92378 7.19926 2.21138 8.99287 2.21138C10.8111 2.21138 12.5063 2.92383 13.784 4.20151C15.0615 5.47901 15.7741 7.17439 15.7741 8.99265Z" fill="#8F949B" />
          </svg>
          <p class="text-sm nav-link-p">Search</p>
        </a>
        <a href="/customer/favorites" class="favorites-link nav-link flex-sm">
          <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M16.44 3.1001C14.63 3.1001 13.01 3.9801 12 5.3301C10.99 3.9801 9.37 3.1001 7.56 3.1001C4.49 3.1001 2 5.6001 2 8.6901C2 9.8801 2.19 10.9801 2.52 12.0001C4.1 17.0001 8.97 19.9901 11.38 20.8101C11.72 20.9301 12.28 20.9301 12.62 20.8101C15.03 19.9901 19.9 17.0001 21.48 12.0001C21.81 10.9801 22 9.8801 22 8.6901C22 5.6001 19.51 3.1001 16.44 3.1001Z" fill="#8F949B" />
          </svg>
          <p class="text-sm nav-link-p">Favorites</p>
        </a>
        <a href="/basket" class="basket-link nav-link flex-sm">
          <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M19.24 5.58006H18.84L15.46 2.20006C15.19 1.93006 14.75 1.93006 14.47 2.20006C14.2 2.47006 14.2 2.91006 14.47 3.19006L16.86 5.58006H7.14L9.53 3.19006C9.8 2.92006 9.8 2.48006 9.53 2.20006C9.26 1.93006 8.82 1.93006 8.54 2.20006L5.17 5.58006H4.77C3.87 5.58006 2 5.58006 2 8.14006C2 9.11006 2.2 9.75006 2.62 10.1701C2.86 10.4201 3.15 10.5501 3.46 10.6201C3.75 10.6901 4.06 10.7001 4.36 10.7001H19.64C19.95 10.7001 20.24 10.6801 20.52 10.6201C21.36 10.4201 22 9.82006 22 8.14006C22 5.58006 20.13 5.58006 19.24 5.58006Z" fill="#8F949B" />
            <path d="M19.0506 12H4.87064C4.25064 12 3.78064 12.55 3.88064 13.16L4.72064 18.3C5.00064 20.02 5.75064 22 9.08064 22H14.6906C18.0606 22 18.6606 20.31 19.0206 18.42L20.0306 13.19C20.1506 12.57 19.6806 12 19.0506 12ZM10.6106 18.45C10.6106 18.84 10.3006 19.15 9.92064 19.15C9.53064 19.15 9.22064 18.84 9.22064 18.45V15.15C9.22064 14.77 9.53064 14.45 9.92064 14.45C10.3006 14.45 10.6106 14.77 10.6106 15.15V18.45ZM14.8906 18.45C14.8906 18.84 14.5806 19.15 14.1906 19.15C13.8106 19.15 13.4906 18.84 13.4906 18.45V15.15C13.4906 14.77 13.8106 14.45 14.1906 14.45C14.5806 14.45 14.8906 14.77 14.8906 15.15V18.45Z" fill="#8F949B" />
          </svg>
          <p class="text-sm nav-link-p">Basket</p>
        </a>
      </nav>

      <!-- search bar -->
      <div class="search-bar">
        <form class="search-form flex-between">
          <a href="/" class="back-home btn">
            <img src="/assets/icons/back-arrow.svg" alt="back arrow icon" />
          </a>
          <input type="text" name="search" placeholder="Search restaurants, food, etc" class="search-input text-sl" />
          <button type="submit" class="search-btn">
            <img src="/assets/icons/search.svg" alt="search icon" />
          </button>
        </form>
        <!-- search history -->
        <div class="search-history">
          <!-- search history header -->
          <div class="search-history-header flex-between">
            <p class="search-header-p text-md">Past searches</p>
            <p class="btn search-header-close text-accent-sl">Clear</p>
          </div>
          <div class="search-items-container scrollable">
            <div class="search-items-content scroller">
              <!-- display search items -->
              <div class="restaurant-sec flex">
                <div class="restaurant-sec-img">
                  <img src="/assets/restaurant/food.png" alt="food image" />
                </div>
                <div class="restaurant-sec-details">
                  <p class="restaurant-sec-title text-normal">French fries</p>
                  <div class="restaurant-sec-rating-cuisine flex-sm">
                    <div class="restaurant-sec-rating flex-sm">
                      <img src="/assets/icons/star.svg" alt="star rating" />
                      <p class="restaurant-sec-rating-figure text-sm">4.2</p>
                    </div>
                    <span class="span-space"></span>
                    <p class="restaurant-sec-cuisine text-sm">Chinese</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="search-nearest">
            <div class="search-nearest-header">
              <p class="search-nearest-p text-md">Nearest restaurants</p>
            </div>
            <!-- display nearest restaurants -->
            <div class="search-nearest-item flex">
              <div class="search-nearest-img flex-center">
                <img src="/assets/restaurant/rea.png" />
              </div>
              <div class="search-nearest-details">
                <p class="text-sl-dark">Mohabatein</p>
                <p class="text-sm">Restaurant</p>
              </div>
            </div>
            <div class="search-nearest-item flex">
              <div class="search-nearest-img flex-center">
                <img src="/assets/restaurant/kumar.png" />
              </div>
              <div class="search-nearest-details">
                <p class="text-sl-dark">Al Bek Kitchen</p>
                <p class="text-sm">Restaurant</p>
              </div>
            </div>
            <div class="search-nearest-item flex">
              <div class="search-nearest-img flex-center">
                <img src="/assets/restaurant/lavish.png" />
              </div>
              <div class="search-nearest-details">
                <p class="text-sl-dark">Lavish</p>
                <p class="text-sm">Hotel</p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- user profile -->
      <div class="user-profile">
        <div class="profile-id">
          <img src="/upload/storage/restaurant/restaurant-member.png" alt="profile picture" />
        </div>
        <!-- profile floater -->
        <div class="profile">
          <?php if(!$this->isLoggedIn): ?>
          <!-- profile authentication -->
          <div class="login-container">
              <div class="login-content flex-column">
                  <div class="flex">
                      <div class="login-img flex-center">
                          <img src="/assets/icons/anonymous.svg" alt="anonymous user image" />
                      </div>
                      <div class="login-text">
                          <p class="text-normal">Login to order food</p>
                          <p class="text-sl-light">Sign in with social links</p>
                      </div>
                  </div>
                  <div class="login-link-container flex-column">
                      <a onclick="window.location.href='<?= $googleAuthUrl; ?>'" class="login-google login-link flex-center">
                          <span class="google-auth flex">
                              <img src="/assets/icons/google.svg" alt="google icon" />
                              <p class="text-sl-dark">Login via Google</p>
                          </span>
                      </a>
                      <a onclick="window.location.href='<?= $facebookAuthUrl; ?>'" class="login-facebook login-link flex-center">
                          <span class="google-auth flex">
                              <img src="/assets/icons/facebook.svg" alt="facebook icon" />
                              <p class="text-sl-dark">Login via Facebook</p>
                          </span>
                      </a>
                  </div>

              </div>
          </div>
          <?php endif; ?>

          <?php if($this->isLoggedIn): 
          ?>
          <a href="/customer/profile" class="profile-details flex-between">
            <div class="flex">
              <div class="profile-img">
                <img width="100" src="<?= $customerAvatar; ?>" alt="profile picture" />
              </div>
              <div class="profile-name">
                <p class="text-normal"><?= $customerName; ?></p>
                <p class="text-sl-light">View Profile</p>
              </div>
            </div>
            <div>
              <img src="/assets/icons/right-arrow.svg" alt="right arrow icon" />
            </div>
          </a>
          <div class="profile-order-favorite flex">
            <a href="/customer/order" class="profile-orders profile-sec flex-center">
              <span class="flex-sm">
                <img src="/assets/icons/orders-box.svg" alt="order box icon" />
                <p class="text-sl-dark">My Orders</p>
              </span>
            </a>
            <a href="/customer/favorites" class="profile-favorites profile-sec flex-center">
              <span class="flex-sm">
                <img src="/assets/icons/heart-light.svg" alt="heart icon" />
                <p class="text-sl-dark">My Favorites</p>
              </span>
            </a>
          </div>
          <div class="profile-address-basket">
            <div class="profile-address-basket-link">
              <a href="/customer/address" class="flex-between">
                <span class="flex-sm">
                  <img src="/assets/icons/geo-tag-light.svg" alt="geo tag icon" />
                  <p class="text-sl-dark">My Address</p>
                </span>
                <img src="/assets/icons/right-arrow.svg" alt="right arrow icon" />
              </a>
            </div>
            <div class="profile-address-basket-link">
              <a href="/customer/address" class="flex-between">
                <span class="flex-sm">
                  <img src="/assets/icons/basket-light.svg" alt="geo tag icon" />
                  <p class="text-sl-dark">My Zoop Basket</p>
                </span>
                <img src="/assets/icons/right-arrow.svg" alt="right arrow icon" />
              </a>
            </div>
            <a href="/customer/logout" class="profile-logout-btn flex-center btn">
              <p class="text-accent">Logout</p>
            </a>
          </div>
          <?php endif; ?>

        </div>
      </div>
    </header>