<?php
declare(strict_types=1);

namespace App\Models;

use App\Lib\Database;
use App\Models\{UserSession};
use App\Util\{Helper, FileSystem, Utility};

class ImportData
{
    protected $db;
    public function __construct()
    {
        $this->db = Database::connectDB();
    }

    public function importRestaurantHours($restaurantArray, $batchSize = 100)
    {
        $result = $this->db->transaction(function ($database) use ($restaurantArray, $batchSize) {
            
            $batchCounter = 0;
            set_time_limit(0);
            // Divide the array into chunks of $batchSize
            $chunkData = array_chunk($restaurantArray, $batchSize);

            foreach ($chunkData as $chunk) {

                $stmt = "INSERT INTO restaurant_hours";
                // Iterate over each element in the chunk
                foreach ($chunk as $index => $restaurant) {
                    $database->query($stmt, [
                        'hour_id' => NULL,
                        'restaurant_id' => (int) $restaurant['id'],
                        'opening_time_morning' => $restaurant['morning_openingtime'],
                        'closing_time_morning' => $restaurant['morning_closingtime'],
                        'opening_time_evening' => $restaurant['evening_openingtime'],
                        'closing_time_evening' => $restaurant['evening_closingtime'],
                    ]);
                }

                // Sleep for 1 second between batches
                sleep(1);
            }

            return true;
            
        });

        if($result){
            Helper::jsonResult([
                "status" => true,  
                "message" => "Data imported successfully.",
            ]);
        }
    }

    public function importRestaurantCharges($restaurantArray, $batchSize = 150)
    {
        $result = $this->db->transaction(function ($database) use ($restaurantArray, $batchSize) {

            $batchCounter = 0;
            set_time_limit(0);
            // Divide the array into chunks of $batchSize
            $chunkData = array_chunk($restaurantArray, $batchSize);

            foreach ($chunkData as $chunk) {

                $stmt = "INSERT INTO restaurant_charges";
                // Iterate over each element in the chunk
                foreach ($chunk as $index => $restaurant) {
                    $database->query($stmt, [
                        'charge_id' => NULL,
                        'restaurant_id' => (int) $restaurant['id'],
                        'platform_fee_type' => $restaurant['platform_fee_type'],
                        'vat_fee_type' => $restaurant['vat_fee_type'],
                        'vat_fee' => $restaurant['vat_fee']
                    ]);
                }

                // Sleep for 1 second between batches
                sleep(1);
            }

            return true;
        });

        if($result){
            Helper::jsonResult([
                "status" => true,  
                "message" => "Data imported successfully.",
            ]);
        }
    }

    public function importRestaurantSetting($restaurantArray, $batchSize = 100)
    {
        $result = $this->db->transaction(function ($database) use ($restaurantArray, $batchSize) {

            $batchCounter = 0;
            set_time_limit(0);
            // Divide the array into chunks of $batchSize
            $chunkData = array_chunk($restaurantArray, $batchSize);

            foreach ($chunkData as $chunk) {

                $stmt = "INSERT INTO restaurant_setting";
                // Iterate over each element in the chunk
                foreach ($chunk as $index => $restaurant) {
                    $database->query($stmt, [
                        'setting_id' => NULL,
                        'restaurant_id' => (int) $restaurant['id'],
                        'dinein_allow' => $restaurant['allow_dinein'],
                        'dinein_table' => '5',
                        'dinein_minimum_order_price' => (float) $restaurant['dinein_takeaway_minOrder'],
                        'delivery_allow' => $restaurant['allow_delivery'],
                        'delivery_minimum_order_price' => (float) $restaurant['dinein_takeaway_minOrder'],
                        'delivery_food_prepare' => '10 Minutes',
                        'delivery_distance' => (double) $restaurant['allow_distance_within'],
                        'delivery_charge' => (float) $restaurant['partner_delivery_charge'],
                        'takeaway_allow' => $restaurant['allow_takeaway'],
                        'takeaway_minimum_order_price' => (float) $restaurant['dinein_takeaway_minOrder'],
                        'vegetarian_allow' => $restaurant['serve_vegetarian'],
                        'non_vegetarian_allow' => $restaurant['serve_non_vegetarian'],
                        'allow_online_payment' => $restaurant['allow_pay_online'],
                    ]);
                }
                // Sleep for 1 second between batches
                sleep(1);
            }

            return true;
        });

        if($result){
            Helper::jsonResult([
                "status" => true,  
                "message" => "Data imported successfully.",
            ]);
        }
    }
}
