<?php
declare(strict_types=1);

namespace App\Models;

use App\Helpers\FileHandler;
use App\Lib\Database;
use App\Models\{UserSession};
use App\Util\{Helper, Locate};
use WebPConvert\WebPConvert;

class Discount
{
    protected $db;
    protected Helper $helper;
    private string $tableName = 'restaurant';

    public function __construct()
    {
        $this->db = Database::connectDB();
        $this->helper = new Helper;
    }

    public function getDiscount(int $partnerId, $type, $week_day)
    {
        $weekDay = Helper::lower($week_day);
        $stmt = $this->db->fetch("SELECT * FROM {$this->tableName}_discount WHERE (discount_type = ? AND restaurant_id = ?) AND discount_day = ? LIMIT 1", $type, $partnerId, $weekDay);
        return $stmt;
    }

    public function getDiscountAll(int $partnerId, $type, $selection = '*')
    {
        $stmt = $this->db->fetchAll("SELECT {$selection} FROM {$this->tableName}_discount WHERE (discount_type = ? AND restaurant_id = ?)", $type, $partnerId);
        return $stmt;
    }

    public function getDeliveryFeeDiscount(int $partnerId, $week_day)
    {
        $weekDay = Helper::lower($week_day);
        $stmt = $this->db->fetch("SELECT * FROM {$this->tableName}_discount_delivery WHERE  restaurant_id = ? AND discount_day = ? LIMIT 1", $partnerId, $weekDay);
        return $stmt;
    }

    public function getDeliveryFeeDiscountAll(int $partnerId, $selection = '*')
    {
        $stmt = $this->db->fetchAll("SELECT {$selection} FROM {$this->tableName}_discount_delivery WHERE  restaurant_id = ?", $partnerId);
        return $stmt;
    }

    public function hasDiscount(int $restaurant_id, string $type)
    {
        $stmt = $this->db->query("SELECT discount_id FROM {$this->tableName}_discount WHERE restaurant_id = ? AND discount_type = ? LIMIT 1", $restaurant_id, $type);
        return $stmt->rowCount() > 0 ?? false;
    }

    public function hasDeliveryDiscount(int $restaurant_id)
    {
        $stmt = $this->db->query("SELECT discount_delivery_id FROM {$this->tableName}_discount_delivery WHERE restaurant_id = ? LIMIT 1", $restaurant_id);
        return $stmt->rowCount() > 0 ?? false;
    }

    public function setDiscount(string $type, array $data, int $restaurant_id): void
    {
        foreach ($data as $discount) {
            $discount_day = $discount['day'];
            $discount_period = $discount['period'];
            $discount_minimum = (float) $discount['minimum_amount'];
            $discount_percent = (float) $discount['percentage'];

            $this->db->query("UPDATE {$this->tableName}_discount SET
            discount_period = '{$discount_period}',
            discount_minimum = '{$discount_minimum}',
            discount_percent = {$discount_percent}
            WHERE (restaurant_id = ? AND discount_type = ?) AND discount_day = ?", $restaurant_id, $type, $discount_day);
        }
    }

    public function addDiscount(string $type, array $data, int $restaurant_id): void
    {

        $insertData = [];
        foreach ($data as $discount) {
            $insertData[] = [
                'discount_id' => NULL,
                'restaurant_id' => $restaurant_id,
                'discount_type' => $type,
                'discount_day' => $discount['day'],
                'discount_period' => $discount['period'],
                'discount_minimum' => (float) $discount['minimum_amount'],
                'discount_percent' => (float) $discount['percentage'],
            ];
        }
        $this->db->query("INSERT INTO {$this->tableName}", ...$insertData);
    }

    public function setDiscountDelivery(array $data, int $restaurant_id): void
    {
        foreach ($data as $discount) {
            $discount_day = $discount['day'];
            $discount_period = $discount['period'];
            $discount_minimum = (float) $discount['minimum_amount'];
            $discount_percent = (float) $discount['percentage'];

            $this->db->query("UPDATE {$this->tableName}_discount_delivery SET
            discount_period = '{$discount_period}',
            discount_minimum = '{$discount_minimum}',
            discount_percent = {$discount_percent}
            WHERE restaurant_id = ? AND discount_day = ?", $restaurant_id, $discount_day);
        }
    }

    public function addDeliveryDiscount(array $data, int $restaurant_id): void
    {

        $insertData = [];
        foreach ($data as $discount) {
            $insertData[] = [
                'discount_delivery_id' => NULL,
                'restaurant_id' => $restaurant_id,
                'discount_day' => $discount['day'],
                'discount_period' => $discount['period'],
                'discount_minimum' => (float) $discount['minimum_amount'],
                'discount_percent' => (float) $discount['percentage'],
            ];
        }
        $this->db->query("INSERT INTO {$this->tableName}_discount_delivery", ...$insertData);
    }
}
