<?php
declare(strict_types=1);

namespace App\Helpers;

use App\Lib\Database;
use App\Util\{FileSystem, Helper};
use InvalidArgumentException;

class Template
{
    private Database $db;

    public function __construct()
    {
        // DATABASE CONNECTION
        $this->db = Database::connectDB();
    }

    public function email(string $templateName): string
    {
        $filePath = \APPROOT . "/Template/{$templateName}.html";
        if (!Helper::isFileExists($filePath)) {
            throw new InvalidArgumentException("Template file not found: {$filePath}");
        }
        return FileSystem::read($filePath);
    }

    public function push(string $templateName): array|null
    {
        $row = $this->db->fetch("SELECT * FROM `_messages` WHERE type = 'push' AND template = ?", $templateName);
        return $row;
    }

    public function sms(string $templateName): array|null
    {
        $row = $this->db->fetch("SELECT * FROM `_messages` WHERE type = 'sms' AND template = ?", $templateName);
        return $row;
    }
}
