<?php

namespace App\Helpers;

class PasswordScore
{
    public static function passwordStrength($password)
    {
        $score = 0;
        $feedback = ['warning' => '', 'suggestions' => []];

        // Check if the password is a dictionary word
        $dictionary = ['password', '123456', 'qwerty', 'admin', 'letmein', 'welcome', 'monkey', 'password1'];
        if (in_array(strtolower($password), $dictionary)) {
            $score = 0;
            $feedback['warning'] = 'Password is extremely guessable.';
        } else {
            // Check length
            $length = strlen($password);
            if ($length >= 8 && $length <= 12) {
                $score++;
            } elseif ($length > 12) {
                $score += 2;
            }

            // Check for digits, special characters, and mixed case
            if (preg_match('/\d/', $password)) {
                $score++;
            }
            if (preg_match('/[!@#$%^&*(),.?":{}|<>]/', $password)) {
                $score++;
            }
            if (preg_match('/[A-Z]/', $password) && preg_match('/[a-z]/', $password)) {
                $score++;
            }

            // Provide suggestions based on score
            if ($score <= 2) {
                $feedback['suggestions'][] = 'Consider using a longer password.';
            }
            if ($score <= 1) {
                $feedback['suggestions'][] = 'Avoid using easily guessable words.';
            }
        }

        return ['score' => $score, 'feedback' => $feedback];
    }
}

