<?php

declare(strict_types=1);

namespace App\Controller;

use App\Lib\Controller;
use App\Helpers\{Template, EmailQueue, TextHelper};
use App\Models\{ImportData, Restaurant, Dish, Customizations, Menu};
use App\Util\Helper;

class CronController extends Controller
{
    public function __construct()
    {
        @header('Access-Control-Allow-Origin: *');
        @header('Access-Control-Allow-Credentials: true');
        @header('Access-Control-Allow-Methods: GET,POST');
        @header('Access-Control-Allow-Headers: Content-Type, Content-Range, Content-Disposition, Content-Description');

    }

    public function backup(?string $param)
    {
    }

    public function import(string $client = null)
    {
        if (empty($client)) {
            @\header("HTTP/1.1 401 Unauthorized");
            Helper::jsonResult(["status" => false, "data" => ["message" => "Unauthorized access to webpage resource"]]);
            exit;
        }

        $importData = new ImportData;
        if(\in_array($client, ['restaurant-hour', 'restaurant-setting', 'restaurant-charge'])){
            if($client === 'restaurant-hour'){
                require_once \APPROOT . '/Database/restaurant.php';
                $importData->importRestaurantHours($restaurant);
            }

            if($client === 'restaurant-setting'){
                require_once \APPROOT . '/Database/restaurant.php';
                $importData->importRestaurantSetting($restaurant);
            }

            if($client === 'restaurant-charge'){
                require_once \APPROOT . '/Database/restaurant.php';
                $importData->importRestaurantCharges($restaurant);
            }
        }
    }

    /**
     * Processes the given action and client parameters and returns an array with the status and data.
     *
     * @param string $action The action to be processed.
     * @param string|null $client The client parameter (optional).
     * @return array An array with the status and data.
     */
    public function process(string $action, string $client = null): array
    {
        $template = new Template;
        $emailQueue = new EmailQueue;

        if (empty($action)) {
            return ["status" => false, "data" => ["message" => "Unauthorized access to webpage resource"]];
        }

        if ($action === 'email') {

            if(\in_array($client, ['send-pending-email'])){
                if($client === 'send-pending-email'){

                    $pendingData = $emailQueue->getPending(QUEUE['send_sequence']);

                    if (!empty($pendingData)) {

                        $emailStatus = $emailQueue->sendPending();

                        if ($emailStatus) {
                            return ['status' => true, 'data' => ['message' => 'Sent email successfully!']];
                        }else{
                            return ['status' => false, 'data' => ['message' => 'Something went wrong!']];
                        }
                    }
                }
            }else{
                return ["status" => false, "data" => ["message" => "Unauthorized access to webpage resource"]];
            }
        }

        if($action === 'restaurant'){
            $restaurant = new Restaurant;
            $allRestaurants = $restaurant->getAll('id,restaurant_email');
            $uploadDirectory =  UPLOADS['public_dir'] . '/restaurant';

            $totalExecuted = 0;
            if($client === 'folder-organization'){
                foreach($allRestaurants as $val){
                    $email = $val->restaurant_email;
                    $id = $val->id;

                    // create a folder using their email
                    if(!\is_dir($uploadDirectory . '/' . $email)){
                        \mkdir($uploadDirectory . '/' . $email, 0777, true);
                    }

                    if(!\is_dir($uploadDirectory . '/' . $email . '/images')){
                        \mkdir($uploadDirectory . '/' . $email . '/images', 0777, true);
                        \mkdir($uploadDirectory . '/' . $email . '/images/dish', 0777, true);
                        \mkdir($uploadDirectory . '/' . $email . '/images/side-item', 0777, true);
                        \mkdir($uploadDirectory . '/' . $email . '/images/status', 0777, true);
                    }

                    if(!\is_dir($uploadDirectory . '/' . $email . '/compressed-images')){
                        \mkdir($uploadDirectory . '/' . $email . '/compressed-images', 0777, true);
                        \mkdir($uploadDirectory . '/' . $email . '/compressed-images/side-item', 0777, true);
                        \mkdir($uploadDirectory . '/' . $email . '/compressed-images/status', 0777, true);
                    }

                    if(!\is_dir($uploadDirectory . '/' . $email . '/videos')){
                        \mkdir($uploadDirectory . '/' . $email . '/videos', 0777, true);
                        \mkdir($uploadDirectory . '/' . $email . '/videos/status', 0777, true);
                    }

                    if(!\is_dir($uploadDirectory . '/' . $email . '/compressed-videos')){
                        \mkdir($uploadDirectory . '/' . $email . '/compressed-videos', 0777, true);
                        \mkdir($uploadDirectory . '/' . $email . '/compressed-videos/status', 0777, true);
                    }

                    $totalExecuted++;
                }

                return ['status' => true, 'message' => 'Total executed: ' . $totalExecuted];
            }


        }

        return ["status" => false, "data" => ["message" => "Unauthorized access to webpage resource"]];
    }
}
